/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.debug;

import com.agilent.tntd.eclipse.debug.AssertionBrokenException;
import com.agilent.tntd.eclipse.debug.InvariantBrokenException;
import com.agilent.tntd.eclipse.debug.InvariantChecking;
import com.agilent.tntd.eclipse.debug.PostconditionBrokenException;
import com.agilent.tntd.eclipse.debug.PreconditionBrokenException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Contract {
    private boolean enabled;
    private InvariantChecking invariantChecker;

    public Contract() {
        this.enabled = false;
        this.invariantChecker = null;
    }

    public Contract(boolean bl) {
        this.enabled = bl;
        this.invariantChecker = null;
    }

    public Contract(boolean bl, InvariantChecking invariantChecking) {
        this.enabled = bl;
        this.invariantChecker = invariantChecking;
    }

    public synchronized void assert(boolean bl) throws AssertionBrokenException {
        if (this.enabled && !bl) {
            throw new AssertionBrokenException("assertion failed");
        }
    }

    public synchronized void assert(boolean bl, String string) throws AssertionBrokenException {
        if (this.enabled && !bl) {
            throw new AssertionBrokenException(string);
        }
    }

    public synchronized void checkInvariant() throws InvariantBrokenException {
        if (this.enabled && this.invariantChecker != null && !this.invariantChecker.invariant()) {
            throw new InvariantBrokenException();
        }
    }

    public synchronized void disable() {
        this.enabled = false;
    }

    public synchronized void enable() {
        this.enabled = true;
    }

    public synchronized void ensure(boolean bl) throws PostconditionBrokenException, InvariantBrokenException {
        this.ensure(bl, "");
    }

    public synchronized void ensure(boolean bl, String string) throws PostconditionBrokenException, InvariantBrokenException {
        if (this.enabled) {
            if (!bl) {
                throw new PostconditionBrokenException(string);
            }
            if (this.invariantChecker != null && !this.invariantChecker.invariant()) {
                throw new InvariantBrokenException();
            }
        }
    }

    public synchronized void require(boolean bl) throws PreconditionBrokenException, InvariantBrokenException {
        this.require(bl, "");
    }

    public synchronized void require(boolean bl, String string) throws PreconditionBrokenException, InvariantBrokenException {
        if (this.enabled) {
            if (this.invariantChecker != null && !this.invariantChecker.invariant()) {
                throw new InvariantBrokenException();
            }
            if (!bl) {
                throw new PreconditionBrokenException(string);
            }
        }
    }

    public synchronized void setInvariantChecker(InvariantChecking invariantChecking) {
        this.invariantChecker = invariantChecking;
    }
}

