/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.issdb.client;

import com.agilent.tntd.eclipse.client.appmodel.GenericRawDataAccess;
import com.agilent.tntd.eclipse.client.appmodel.OperationFailedException;
import com.agilent.tntd.eclipse.client.appmodel.RawDataApplicationDomain;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.RawDataID;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.client.IssApplicationDomain;
import com.agilent.tntd.eclipse.issdb.client.MessageExecuter;
import com.agilent.tntd.eclipse.issdb.client.MessageProcessor;
import com.agilent.tntd.eclipse.issdb.client.ThreadScheduler;
import com.agilent.tntd.eclipse.issdb.common.GroupMessageHandler;
import com.agilent.tntd.eclipse.issdb.common.IssCmdAnonymousUpdateHandler;
import com.agilent.tntd.eclipse.issdb.common.IssCmdKnownObjectChangeHandler;
import com.agilent.tntd.eclipse.issdb.common.IssRspAsyncQueryHandler;
import com.agilent.tntd.eclipse.issdb.common.IssRspAsyncRequestObjectIDHandler;
import com.agilent.tntd.eclipse.issdb.common.IssRspChangeHandler;
import com.agilent.tntd.eclipse.middleware.MessageHandler;
import com.agilent.tntd.eclipse.middleware.WcMessage;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.List;
import java.io.IOException;

public abstract class GenericIssDataAccessor
extends GenericRawDataAccess
implements MessageHandler,
IssCmdAnonymousUpdateHandler,
IssRspAsyncQueryHandler,
IssRspAsyncRequestObjectIDHandler,
IssRspChangeHandler,
IssCmdKnownObjectChangeHandler,
MessageProcessor,
GroupMessageHandler {
    private MessageExecuter myMessageExecuter;
    private volatile boolean queueActivated = false;
    private volatile Object changeResponse = CHANGE_RESPONSE_NOT_RECEIVED;
    private static final Object CHANGE_RESPONSE_NOT_RECEIVED = new Object();
    private static final Object CHANGE_RESPONSE_SUCCESS = new Object();
    private static final Object CHANGE_RESPONSE_FAILED = new Object();
    private Object lock = new Object();
    private List queueBeforeServer = Collections.synchronizedList((List)new ArrayList(119));
    private static byte clientID = (byte)-1;
    private int numberOfMessageBeforeSendingGroup = 0;

    public GenericIssDataAccessor() {
        this.myMessageExecuter = new MessageExecuter(this);
    }

    public final void asyncQuery(RawDataID rawDataID, ApplicationMetaData applicationMetaData) {
        try {
            WcMessage wcMessage = this.createAsyncQuery(rawDataID, applicationMetaData);
            if (this.queueActivated) {
                this.queueBeforeServer.add((Object)wcMessage);
            } else {
                this.transact(wcMessage);
            }
        }
        catch (IOException iOException) {
            throw new OperationFailedException(iOException.toString());
        }
    }

    public final void asyncRequestObjectID(String string) {
        try {
            if (this.queueActivated) {
                if (string == "BEGIN") {
                    System.out.println("Another Queue_Start inside a Queue_Start, please exit your GUI now.");
                } else if (string == "END") {
                    this.queueActivated = false;
                    if (this.queueBeforeServer.size() > 1) {
                        ThreadScheduler.instance().validateInitialisationBarrier();
                        this.sendQueue(this.queueBeforeServer);
                    } else {
                        this.queueBeforeServer.clear();
                        ThreadScheduler.instance().goToBarrier();
                    }
                } else {
                    this.queueBeforeServer.add((Object)this.createRequestObjectID(string));
                }
            } else if (string == "BEGIN") {
                this.queueActivated = true;
                if (!this.queueBeforeServer.isEmpty()) {
                    EventLog.instance().log("Fatal problem: Server not reading fast enough from the socket, the queue for socket to the server in not empty. Exit your application now.");
                }
                this.queueBeforeServer.add(null);
            } else if (string == "END") {
                ThreadScheduler.instance().goToBarrier();
            } else {
                this.transact(this.createRequestObjectID(string));
            }
        }
        catch (IOException iOException) {
            throw new OperationFailedException(iOException.toString());
        }
    }

    public void attachDomain(RawDataApplicationDomain rawDataApplicationDomain) {
        super.attachDomain(rawDataApplicationDomain);
        this.myMessageExecuter.start();
    }

    public boolean change(RawDataID rawDataID, ApplicationData applicationData) {
        int n = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(10);
        ThreadScheduler.instance().createBarrier(2);
        Object object = this.lock;
        synchronized (object) {
            this.changeResponse = CHANGE_RESPONSE_NOT_RECEIVED;
        }
        try {
            object = this.createChangeRequest(rawDataID, applicationData);
            this.transact((WcMessage)object);
        }
        catch (IOException iOException) {
            ThreadScheduler.instance().disableBarrier();
            throw new OperationFailedException(iOException.toString());
        }
        ThreadScheduler.instance().goToBarrier();
        Thread.currentThread().setPriority(n);
        object = this.lock;
        synchronized (object) {
            if (this.changeResponse == CHANGE_RESPONSE_NOT_RECEIVED) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    System.out.println(String.valueOf(Thread.currentThread().toString()) + " was interrupted when waiting for change response");
                }
            }
        }
        return this.getResponse();
    }

    protected abstract WcMessage createAsyncQuery(RawDataID var1, ApplicationMetaData var2) throws IOException;

    protected abstract WcMessage createChangeRequest(RawDataID var1, ApplicationData var2) throws IOException;

    protected abstract WcMessage createRequestObjectID(String var1) throws IOException;

    public void disconnectFromDomain() {
        this.myMessageExecuter.stopReceiving();
        super.disconnectFromDomain();
    }

    public static byte getClientID() {
        return clientID;
    }

    private boolean getResponse() {
        return this.changeResponse == CHANGE_RESPONSE_SUCCESS;
    }

    public final void handleMessage(WcMessage wcMessage) {
        this.myMessageExecuter.schedule(wcMessage);
    }

    public final void notifyAnonymousUpdate(int n, byte by) {
        if (GenericIssDataAccessor.getClientID() == by) {
            if (!this.queueActivated) {
                this.startQueuing();
            }
            ((IssApplicationDomain)this.getDomain()).updateAllIDs(n);
            this.sendQueue();
        } else if (ThreadScheduler.instance().attemptCreateBarrier(1, false)) {
            if (!this.queueActivated) {
                this.startQueuing();
            }
            ((IssApplicationDomain)this.getDomain()).updateAllIDs(n);
            this.sendQueue();
        } else if (n != 2) {
            ((IssApplicationDomain)this.getDomain()).updateAllIDs(n);
        }
    }

    public final void notifyChangeResponse(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            if (bl) {
                this.changeResponse = CHANGE_RESPONSE_SUCCESS;
            } else {
                this.changeResponse = CHANGE_RESPONSE_FAILED;
                if (this.queueActivated) {
                    this.sendQueue();
                }
                ThreadScheduler.instance().goToBarrier();
            }
            this.lock.notifyAll();
        }
    }

    public final void notifyChangeWithData(RawDataID rawDataID, ApplicationData applicationData) {
        this.getDomain().updateSingleID(rawDataID, applicationData);
    }

    public void notifyGroupMessage(short s, byte by) {
        if (!this.queueActivated) {
            this.startQueuing();
        }
        if (GenericIssDataAccessor.getClientID() == by) {
            this.numberOfMessageBeforeSendingGroup = s + 1;
        } else if (ThreadScheduler.instance().attemptCreateBarrier(1, false)) {
            this.numberOfMessageBeforeSendingGroup = s + 1;
        }
    }

    public final void notifyIDForName(RawDataID rawDataID, String string) {
        this.getDomain().notifyIDforName(string, rawDataID);
    }

    public final void notifyRspAsyncQuery(RawDataID rawDataID, ApplicationData applicationData) {
        this.getDomain().updateValueForID(rawDataID, applicationData);
    }

    public final void processMessage(WcMessage wcMessage) {
        wcMessage.execute(this);
        if (this.numberOfMessageBeforeSendingGroup > 0) {
            --this.numberOfMessageBeforeSendingGroup;
            if (this.numberOfMessageBeforeSendingGroup == 0) {
                this.sendQueue();
            }
        }
    }

    private void sendQueue() {
        try {
            this.asyncRequestObjectID("END");
        }
        catch (OperationFailedException operationFailedException) {
            EventLog.instance().log("Request ID for Queue Stop fail to communicate with server");
        }
    }

    protected abstract void sendQueue(List var1) throws IOException;

    protected void setClientID(byte by) {
        clientID = by;
    }

    private void startQueuing() {
        try {
            this.asyncRequestObjectID("BEGIN");
        }
        catch (OperationFailedException operationFailedException) {
            EventLog.instance().log("Request ID for Queue Start fail to communicate with server");
        }
    }

    protected abstract void transact(WcMessage var1) throws IOException;
}

