/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.issdb.client;

import com.agilent.tntd.eclipse.client.appmodel.OperationFailedException;
import com.agilent.tntd.eclipse.client.appmodel.RawDataApplicationDomain;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.RawDataID;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.client.GenericIssDataAccessor;
import com.agilent.tntd.eclipse.issdb.client.IssApplicationDomain;
import com.agilent.tntd.eclipse.issdb.client.IssServerUnavailableException;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericDataReaderWriter;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaDataReaderWriter;
import com.agilent.tntd.eclipse.issdb.common.EclCmdEvent;
import com.agilent.tntd.eclipse.issdb.common.FrameAnonymousUpdateNotify;
import com.agilent.tntd.eclipse.issdb.common.FrameGroupMessage;
import com.agilent.tntd.eclipse.issdb.common.IssCmdAsyncQuery;
import com.agilent.tntd.eclipse.issdb.common.IssCmdChange;
import com.agilent.tntd.eclipse.issdb.common.IssCmdEndSession;
import com.agilent.tntd.eclipse.issdb.common.IssCmdKnownObjectChangeNotify;
import com.agilent.tntd.eclipse.issdb.common.IssCmdRequestObjectID;
import com.agilent.tntd.eclipse.issdb.common.IssDataIDReaderWriter;
import com.agilent.tntd.eclipse.issdb.common.IssResultMetaDataReaderWriter;
import com.agilent.tntd.eclipse.issdb.common.IssRspAsyncQuery;
import com.agilent.tntd.eclipse.issdb.common.IssRspAsyncRequestObjectID;
import com.agilent.tntd.eclipse.issdb.common.IssRspChange;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringReaderWriter;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerReaderWriter;
import com.agilent.tntd.eclipse.middleware.SocketReader;
import com.agilent.tntd.eclipse.middleware.WcMessage;
import com.agilent.tntd.eclipse.middleware.WcObjectTransfer;
import com.sun.java.util.collections.List;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class IssAccess
extends GenericIssDataAccessor {
    private Socket issServer;
    private WcObjectTransfer transfer;
    private SocketReader receiver;

    public IssAccess() throws IssServerUnavailableException {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.initialise(inetAddress, 5002);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IssServerUnavailableException("cannot find local host address");
        }
    }

    public IssAccess(InetAddress inetAddress) throws IssServerUnavailableException {
        this.initialise(inetAddress, 5002);
    }

    public IssAccess(InetAddress inetAddress, int n) throws IssServerUnavailableException {
        this.initialise(inetAddress, n);
    }

    public void attachDomain(RawDataApplicationDomain rawDataApplicationDomain) {
        if (!(rawDataApplicationDomain instanceof IssApplicationDomain)) {
            System.out.println("IssAccess can only run with IssApplicationDomain, cannot set domain " + rawDataApplicationDomain.toString());
            this.close();
            System.exit(1);
        } else {
            super.attachDomain(rawDataApplicationDomain);
        }
    }

    private synchronized void close() {
        this.receiver.stopReceiving();
        try {
            this.transfer.send(new IssCmdEndSession());
        }
        catch (IOException iOException) {
            EventLog.instance().log("Error could not send disconnect command to server." + iOException.toString());
        }
        try {
            this.issServer.close();
        }
        catch (IOException iOException) {
            EventLog.instance().log("Error closing socket with server." + iOException.toString());
        }
        this.issServer = null;
        this.transfer = null;
        this.receiver = null;
    }

    protected WcMessage createAsyncQuery(RawDataID rawDataID, ApplicationMetaData applicationMetaData) throws IOException {
        return new IssCmdAsyncQuery(rawDataID, applicationMetaData);
    }

    protected WcMessage createChangeRequest(RawDataID rawDataID, ApplicationData applicationData) throws IOException {
        return new IssCmdChange(rawDataID, applicationData);
    }

    protected WcMessage createRequestObjectID(String string) throws IOException {
        return new IssCmdRequestObjectID(string);
    }

    public void disconnectFromDomain() {
        this.close();
        super.disconnectFromDomain();
    }

    protected WcObjectTransfer initialise(InetAddress inetAddress, int n) throws IssServerUnavailableException {
        Object object;
        try {
            this.issServer = new Socket(inetAddress, n);
            object = new DataOutputStream(new BufferedOutputStream(this.issServer.getOutputStream(), 60000));
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(this.issServer.getInputStream(), 60000));
            this.transfer = new WcObjectTransfer(dataInputStream, (DataOutputStream)object);
        }
        catch (IOException iOException) {
            throw new IssServerUnavailableException("Can't find eclipse server running on this instrument ");
        }
        this.transfer.registerReaderWriter(new ApplicationGenericDataReaderWriter());
        this.transfer.registerReaderWriter(new ApplicationGenericMetaDataReaderWriter());
        this.transfer.registerReaderWriter(new KnownLengthStringReaderWriter());
        this.transfer.registerReaderWriter(new MaskedIntegerReaderWriter());
        this.transfer.registerReaderWriter(new IssDataIDReaderWriter());
        this.transfer.registerReaderWriter(new IssResultMetaDataReaderWriter());
        this.transfer.registerReaderWriter(new IssCmdChange(null, null));
        this.transfer.registerReaderWriter(new IssCmdEndSession());
        this.transfer.registerReaderWriter(new IssCmdRequestObjectID(null));
        this.transfer.registerReaderWriter(new IssCmdAsyncQuery(null, null));
        this.transfer.registerReaderWriter(new FrameAnonymousUpdateNotify(-1, 0));
        this.transfer.registerReaderWriter(new IssCmdKnownObjectChangeNotify(null, null));
        this.transfer.registerReaderWriter(new EclCmdEvent(null, null));
        this.transfer.registerReaderWriter(new IssRspChange(false));
        this.transfer.registerReaderWriter(new IssRspAsyncRequestObjectID(null, null));
        this.transfer.registerReaderWriter(new IssRspAsyncQuery(null, null));
        this.transfer.registerReaderWriter(new FrameGroupMessage(0, 0));
        try {
            object = this.transfer.getInitialisationString();
            if (((String)object).substring(0, ((String)object).length() - 1).equals("BUSY")) {
                throw new IssServerUnavailableException("Too many clients are already connected to this instrument.");
            }
            if (!((String)object).substring(0, ((String)object).length() - 1).equals("ECLIPSE_SVR3")) {
                throw new IssServerUnavailableException("The server is not compatible with this version of the client.");
            }
        }
        catch (ClassCastException classCastException) {
            throw new IssServerUnavailableException("The server doesn't send its version identifier as a string.");
        }
        catch (IOException iOException) {
            throw new IssServerUnavailableException("Failed to communicate with this server.");
        }
        try {
            this.setClientID(this.transfer.getClientID());
        }
        catch (IOException iOException) {
            throw new IssServerUnavailableException("Failed to communicate with this server.");
        }
        if (!this.transfer.handshake()) {
            throw new IssServerUnavailableException("The server is not compatible with this version of the client.");
        }
        this.receiver = new SocketReader(this.transfer, this);
        this.receiver.start();
        return this.transfer;
    }

    public void sendEvent(RawDataID rawDataID, ApplicationData applicationData) {
        try {
            this.transact(new EclCmdEvent(rawDataID, applicationData));
        }
        catch (IOException iOException) {
            throw new OperationFailedException(iOException.toString());
        }
    }

    protected void sendQueue(List list) throws IOException {
        List list2 = list;
        synchronized (list2) {
            FrameGroupMessage frameGroupMessage = new FrameGroupMessage((short)(list.size() - 1), GenericIssDataAccessor.getClientID());
            list.set(0, (Object)frameGroupMessage);
            this.transfer.sendQueue(list);
        }
    }

    protected synchronized void transact(WcMessage wcMessage) throws IOException {
        this.transfer.send(wcMessage);
    }
}

