/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.issdb.client;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.CompositeDataReader;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.GenericApplicationObjectState;
import com.agilent.tntd.eclipse.client.appmodel.OperationFailedException;
import com.agilent.tntd.eclipse.client.appmodel.RawDataAccess;
import com.agilent.tntd.eclipse.client.appmodel.RawDataApplicationDomain;
import com.agilent.tntd.eclipse.client.appmodel.RawDataApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.applicationobjectstate.RunTimeEventState;
import com.agilent.tntd.eclipse.client.appmodel.applicationobjectstate.RunTimeRegisteredMetaDataState;
import com.agilent.tntd.eclipse.client.appmodel.applicationobjectstate.RunTimeRegisteredMetaDataWithEventState;
import com.agilent.tntd.eclipse.client.appmodel.applicationobjectstate.RunTimeSingleObserverNoMetaDataState;
import com.agilent.tntd.eclipse.client.appmodel.applicationobjectstate.RuntimeCompositeDataState;
import com.agilent.tntd.eclipse.client.appmodel.applicationobjectstate.RuntimePersistentDataState;
import com.agilent.tntd.eclipse.client.appmodel.applicationobjectstate.RuntimeResponsePerObserverState;
import com.agilent.tntd.eclipse.common.data.RawDataID;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.IssDataID;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;

public final class IssApplicationDomain
extends RawDataApplicationDomain {
    private Set theDataSet = new HashSet(500);
    private Set theResultSet = new HashSet(100);
    private Set theGraphSet = new HashSet(50);
    private Set theNonIssSet = new HashSet(500);
    private Set theApplicationSet = new HashSet(100);
    private boolean doingUpdates = false;

    public IssApplicationDomain(RawDataAccess rawDataAccess, String string) {
        super(string, rawDataAccess);
    }

    protected GenericApplicationObjectState createApplicationObjectStateForID(RawDataID rawDataID, String string) {
        GenericApplicationObjectState genericApplicationObjectState;
        if (rawDataID instanceof IssDataID) {
            IssDataID issDataID = (IssDataID)rawDataID;
            switch (issDataID.getTransportPolicy()) {
                case 0: {
                    genericApplicationObjectState = new RunTimeRegisteredMetaDataState();
                    break;
                }
                case 1: {
                    genericApplicationObjectState = new RunTimeSingleObserverNoMetaDataState();
                    break;
                }
                case 2: {
                    CompositeDataReader compositeDataReader = ApplicationManager.instance().getCompositeDataReader(this, string);
                    if (compositeDataReader != null) {
                        genericApplicationObjectState = new RuntimeCompositeDataState(compositeDataReader);
                        break;
                    }
                    EventLog.instance().log("No Composite Data Reader was registered for this name = " + string);
                    genericApplicationObjectState = null;
                    break;
                }
                case 3: {
                    genericApplicationObjectState = new RuntimePersistentDataState();
                    break;
                }
                case 4: {
                    genericApplicationObjectState = new RunTimeEventState();
                    break;
                }
                case 5: {
                    genericApplicationObjectState = new RunTimeRegisteredMetaDataWithEventState();
                    break;
                }
                case 6: {
                    genericApplicationObjectState = new RuntimeResponsePerObserverState();
                    break;
                }
                default: {
                    EventLog.instance().log(String.valueOf(this.toString()) + " doesn't support this type of transport policy for " + rawDataID.toString());
                    genericApplicationObjectState = null;
                }
            }
        } else {
            genericApplicationObjectState = super.createApplicationObjectStateForID(rawDataID, string);
        }
        return genericApplicationObjectState;
    }

    public void disconnectDependencies() {
        Object object = this.getDataLock();
        synchronized (object) {
            this.theDataSet.clear();
            this.theResultSet.clear();
            this.theGraphSet.clear();
            this.theNonIssSet.clear();
            this.theApplicationSet.clear();
            this.theDataSet = null;
            this.theResultSet = null;
            this.theGraphSet = null;
            this.theNonIssSet = null;
            this.theApplicationSet = null;
            super.disconnectDependencies();
        }
    }

    private void proceedWithUpdates(int n) {
        Iterator iterator = null;
        switch (n) {
            case 1: {
                if (this.theDataSet.isEmpty()) break;
                iterator = this.theDataSet.iterator();
                break;
            }
            case 2: {
                if (this.theResultSet.isEmpty()) break;
                iterator = this.theResultSet.iterator();
                break;
            }
            case 3: {
                if (this.theGraphSet.isEmpty()) break;
                iterator = this.theGraphSet.iterator();
                break;
            }
            case 4: {
                if (this.theNonIssSet.isEmpty()) break;
                iterator = this.theNonIssSet.iterator();
                break;
            }
            case 0: {
                this.proceedWithUpdates(1);
                this.proceedWithUpdates(2);
                this.proceedWithUpdates(3);
                this.proceedWithUpdates(4);
                if (this.theApplicationSet.isEmpty()) break;
                iterator = this.theApplicationSet.iterator();
                while (iterator.hasNext()) {
                    try {
                        ((ApplicationObject)iterator.next()).asyncUpdate();
                    }
                    catch (OperationFailedException operationFailedException) {}
                }
                break;
            }
            default: {
                if (n < 10) {
                    EventLog.instance().log(String.valueOf(this.toString()) + " received unknown Anonymous update type :" + n);
                    break;
                }
                if (this.theApplicationSet.isEmpty()) break;
                iterator = this.theApplicationSet.iterator();
                RawDataApplicationObject rawDataApplicationObject = null;
                while (iterator.hasNext()) {
                    try {
                        rawDataApplicationObject = (RawDataApplicationObject)iterator.next();
                        if (rawDataApplicationObject.getID().getType() != n) continue;
                        rawDataApplicationObject.asyncUpdate();
                    }
                    catch (OperationFailedException operationFailedException) {}
                }
                iterator = null;
            }
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                try {
                    ((ApplicationObject)iterator.next()).asyncUpdate();
                }
                catch (OperationFailedException operationFailedException) {}
            }
        }
    }

    public void register(ApplicationObject applicationObject) {
        if (applicationObject instanceof RawDataApplicationObject) {
            this.register((RawDataApplicationObject)applicationObject);
        } else {
            super.register(applicationObject);
        }
    }

    public void register(RawDataApplicationObject rawDataApplicationObject) {
        Object object = this.getDataLock();
        synchronized (object) {
            if (this.doingUpdates) {
                throw new RuntimeException("Adding " + rawDataApplicationObject.toString() + " would have created concurrent modification exception.");
            }
            switch (rawDataApplicationObject.getID().getType()) {
                case 0: 
                case 1: {
                    this.theDataSet.add((Object)rawDataApplicationObject);
                    break;
                }
                case 2: {
                    this.theResultSet.add((Object)rawDataApplicationObject);
                    break;
                }
                case 3: {
                    this.theGraphSet.add((Object)rawDataApplicationObject);
                    break;
                }
                case 4: {
                    this.theNonIssSet.add((Object)rawDataApplicationObject);
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    this.theApplicationSet.add((Object)rawDataApplicationObject);
                    break;
                }
                default: {
                    if (rawDataApplicationObject.getID().getType() <= 9) break;
                    this.theApplicationSet.add((Object)rawDataApplicationObject);
                }
            }
        }
    }

    public String toString() {
        return "Iss Application Domain";
    }

    public void unregister(ApplicationObject applicationObject) {
        if (applicationObject instanceof RawDataApplicationObject) {
            this.unregister((RawDataApplicationObject)applicationObject);
        } else {
            super.unregister(applicationObject);
        }
    }

    public void unregister(RawDataApplicationObject rawDataApplicationObject) {
        Object object = this.getDataLock();
        synchronized (object) {
            if (this.doingUpdates) {
                throw new RuntimeException("Removing " + rawDataApplicationObject.toString() + " would have created concurrent modification exception.");
            }
            super.unregister((ApplicationObject)rawDataApplicationObject);
            if (rawDataApplicationObject.getID() != null) {
                Set set = null;
                switch (rawDataApplicationObject.getID().getType()) {
                    case 0: 
                    case 1: {
                        set = this.theDataSet;
                        break;
                    }
                    case 2: {
                        set = this.theResultSet;
                        break;
                    }
                    case 3: {
                        set = this.theGraphSet;
                        break;
                    }
                    case 4: {
                        set = this.theNonIssSet;
                        break;
                    }
                    default: {
                        set = this.theApplicationSet;
                    }
                }
                if (set != null && set.contains((Object)rawDataApplicationObject)) {
                    set.remove((Object)rawDataApplicationObject);
                }
            }
        }
    }

    public void updateAllIDs(int n) {
        Object object = this.getDataLock();
        synchronized (object) {
            this.doingUpdates = true;
            this.proceedWithUpdates(n);
            this.doingUpdates = false;
        }
    }
}

