/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.issdb.client;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.client.MessageProcessor;
import com.agilent.tntd.eclipse.issdb.common.FrameGroupMessage;
import com.agilent.tntd.eclipse.middleware.BadMessageHandlerException;
import com.agilent.tntd.eclipse.middleware.WcMessage;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.sun.java.util.collections.LinkedList;

public final class MessageExecuter
extends Thread {
    private MessageProcessor myMessageProcessor = null;
    boolean quit = false;
    private LinkedList queue = new LinkedList();
    private volatile int numberOfMessageToReceive = 0;

    public MessageExecuter(MessageProcessor messageProcessor) {
        super(EclipseSystem.instance().getEclipseThreadGroup(), "AsynMsgExe (Asynchronous Message Executer");
        this.setPriority(6);
        this.myMessageProcessor = messageProcessor;
    }

    private void doSchedule(WcMessage wcMessage) {
        this.queue.addLast((Object)wcMessage);
        if (this.numberOfMessageToReceive > 0) {
            --this.numberOfMessageToReceive;
            if (this.numberOfMessageToReceive == 0) {
                MessageExecuter messageExecuter = this;
                synchronized (messageExecuter) {
                    this.notify();
                }
            }
        } else if (this.queue.size() == 1) {
            MessageExecuter messageExecuter = this;
            synchronized (messageExecuter) {
                this.notify();
            }
        }
    }

    private synchronized WcMessage getNextMessage() {
        WcMessage wcMessage = null;
        try {
            if (this.queue.size() == 0 || this.numberOfMessageToReceive != 0) {
                MessageExecuter messageExecuter = this;
                synchronized (messageExecuter) {
                    this.wait();
                }
            }
            if (!this.quit) {
                wcMessage = (WcMessage)this.queue.removeFirst();
                while (this.queue.size() != 0 && wcMessage.equals(this.queue.getFirst())) {
                    this.queue.removeFirst();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " was interrupted.");
        }
        return wcMessage;
    }

    private void processMessage(WcMessage wcMessage) {
        if (wcMessage != null && !this.quit) {
            try {
                this.myMessageProcessor.processMessage(wcMessage);
            }
            catch (BadMessageHandlerException badMessageHandlerException) {
                EventLog.instance().log(String.valueOf(this.toString()) + " received a message " + wcMessage.toString() + " not handled by " + this.myMessageProcessor.toString());
            }
        }
    }

    public void run() {
        do {
            WcMessage wcMessage = this.getNextMessage();
            this.processMessage(wcMessage);
        } while (!this.quit);
    }

    public synchronized void schedule(WcMessage wcMessage) {
        if (this.numberOfMessageToReceive == 0) {
            if (wcMessage instanceof FrameGroupMessage) {
                this.numberOfMessageToReceive = ((FrameGroupMessage)wcMessage).getGroupSize() + 1;
            }
            this.doSchedule(wcMessage);
        } else {
            this.doSchedule(wcMessage);
        }
    }

    public void stopReceiving() {
        this.quit = true;
        MessageExecuter messageExecuter = this;
        synchronized (messageExecuter) {
            this.notify();
        }
    }
}

