/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.issdb.client;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.common.util.SingletonRegistry;
import com.agilent.tntd.eclipse.issdb.client.CyclicBarrier;

public class ThreadScheduler {
    private static ThreadScheduler singletonInstance = null;
    private volatile CyclicBarrier myBarrier;
    private boolean isAnInitialisationBarrier = false;
    private boolean hasValidatedInitialisation = false;
    private Object myLock = new Object();

    private ThreadScheduler() {
    }

    public boolean attemptCreateBarrier(int n, boolean bl) {
        boolean bl2 = false;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myBarrier == null) {
                this.createBarrier(n, bl);
                bl2 = true;
            }
        }
        return bl2;
    }

    public void createBarrier(int n) {
        this.createBarrier(n, false);
    }

    private void createBarrier(int n, boolean bl) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myBarrier == null) {
                this.isAnInitialisationBarrier = bl;
                this.hasValidatedInitialisation = false;
                this.myBarrier = new CyclicBarrier(n);
            } else {
                try {
                    this.myLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    EventLog.instance().log("Wait on the lock to create a barrier was Interrupted.");
                }
                this.createBarrier(n, bl);
            }
        }
    }

    public void createInitialisationBarrier() {
        if (this.isAnInitialisationBarrier) {
            System.out.println("Should not create an Initialisation barrier twice");
        } else {
            this.createBarrier(2, true);
        }
    }

    public void disableBarrier() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myBarrier != null) {
                CyclicBarrier cyclicBarrier = this.myBarrier;
                this.resetBarrierProperties();
                cyclicBarrier.restart();
                cyclicBarrier = null;
            }
        }
    }

    public void goToBarrier() {
        if (this.myBarrier != null) {
            if (this.isAnInitialisationBarrier && !this.hasValidatedInitialisation) {
                this.resetBarrierProperties();
            } else {
                try {
                    if (this.myBarrier.barrier() == 0) {
                        this.resetBarrierProperties();
                        Thread.currentThread();
                        Thread.sleep(1L);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static synchronized ThreadScheduler instance() {
        if (singletonInstance == null) {
            singletonInstance = new ThreadScheduler();
            SingletonRegistry.instance().add(singletonInstance);
        }
        return singletonInstance;
    }

    private void resetBarrierProperties() {
        Object object = this.myLock;
        synchronized (object) {
            this.myBarrier = null;
            this.hasValidatedInitialisation = false;
            this.isAnInitialisationBarrier = false;
            this.myLock.notifyAll();
        }
    }

    public void validateInitialisationBarrier() {
        if (this.isAnInitialisationBarrier) {
            this.hasValidatedInitialisation = true;
        }
    }
}

