/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.issdb.common;

import com.agilent.tntd.eclipse.issdb.common.BoundNumericValue;

public class BoundIntegerValue
extends BoundNumericValue {
    private long value;
    private long minimumValue;
    private long maximumValue;

    public BoundIntegerValue(long l) {
        this.value = l;
        this.minimumValue = Long.MIN_VALUE;
        this.maximumValue = Long.MAX_VALUE;
    }

    public BoundIntegerValue(long l, long l2, long l3) throws IllegalArgumentException {
        this.value = l;
        this.minimumValue = l2;
        this.maximumValue = l3;
        if (l < l2) {
            throw new IllegalArgumentException("Less than minimum");
        }
        if (l > l3) {
            throw new IllegalArgumentException("More than maximum");
        }
    }

    public long getIntMaximumValue() {
        return this.maximumValue;
    }

    public long getIntMinimumValue() {
        return this.minimumValue;
    }

    public long getIntValue() {
        return this.value;
    }

    public double getRealMaximumValue() {
        return this.maximumValue;
    }

    public double getRealMinimumValue() {
        return this.minimumValue;
    }

    public double getRealValue() {
        return this.value;
    }

    public String toString() {
        return "BoundInt[" + this.minimumValue + "<" + this.value + "<" + this.maximumValue + "]";
    }
}

