/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.issdb.common;

import com.agilent.tntd.eclipse.issdb.common.BoundNumericValue;

public class BoundRealValue
extends BoundNumericValue {
    double value;
    double minimumValue;
    double maximumValue;

    public BoundRealValue(double d) {
        this.value = d;
        this.minimumValue = Double.MIN_VALUE;
        this.maximumValue = Double.MAX_VALUE;
    }

    public BoundRealValue(double d, double d2, double d3) throws IllegalArgumentException {
        this.value = d;
        this.minimumValue = d2;
        this.maximumValue = d3;
        if (d < d2) {
            throw new IllegalArgumentException("Less than minimum");
        }
        if (d > d3) {
            throw new IllegalArgumentException("More than maximum");
        }
    }

    public long getIntMaximumValue() {
        return (long)this.maximumValue;
    }

    public long getIntMinimumValue() {
        return (long)this.minimumValue;
    }

    public long getIntValue() {
        return (long)this.value;
    }

    public double getRealMaximumValue() {
        return this.maximumValue;
    }

    public double getRealMinimumValue() {
        return this.minimumValue;
    }

    public double getRealValue() {
        return this.value;
    }

    public String toString() {
        return "BoundReal[" + this.minimumValue + "<" + this.value + "<" + this.maximumValue + "]";
    }
}

