/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.issdb.common;

import com.agilent.tntd.eclipse.common.data.RawDataID;
import com.agilent.tntd.eclipse.common.util.EventLog;

public class IssDataID
implements RawDataID {
    private int type;
    byte transportPolicy;
    int typeIndex;

    public IssDataID(int n, byte by, int n2) {
        this.type = n;
        this.transportPolicy = by;
        this.typeIndex = n2;
        if (n2 > 19999 || by > 9) {
            EventLog.instance().log("Important: Need to change HashCode mechanism for ISSDataID, because " + this.toString() + " is too big");
        }
    }

    public boolean equals(RawDataID rawDataID) {
        if (rawDataID != null && rawDataID instanceof IssDataID) {
            IssDataID issDataID = (IssDataID)rawDataID;
            return this.type == issDataID.type && this.typeIndex == issDataID.typeIndex && this.transportPolicy == issDataID.transportPolicy;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof RawDataID) {
            return this.equals((RawDataID)object);
        }
        return false;
    }

    public byte getTransportPolicy() {
        return this.transportPolicy;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return this.type * 200000 + this.transportPolicy * 20000 + this.typeIndex;
    }

    public String toString() {
        return "DataID[" + this.type + ", " + this.transportPolicy + ", " + this.typeIndex + "]";
    }
}

