/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.issdb.common;

import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.GenericApplicationData;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringDataReceiver;

public class KnownLengthStringValue
extends GenericApplicationData {
    private final String string;

    public KnownLengthStringValue(String string) {
        this.string = string;
    }

    public KnownLengthStringValue(String string, int n) {
        if (n <= string.length()) {
            this.string = string.substring(0, n);
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            while (stringBuffer.length() < n) {
                stringBuffer.append(' ');
            }
            this.string = stringBuffer.toString();
        }
    }

    public boolean equals(KnownLengthStringValue knownLengthStringValue) {
        if (knownLengthStringValue != null && (this.string != null ? this.string.equals(knownLengthStringValue.string) : knownLengthStringValue.string == null)) {
            return super.equals(knownLengthStringValue);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof KnownLengthStringValue) {
            return this.equals((KnownLengthStringValue)object);
        }
        return false;
    }

    public int getLength() {
        return this.string.length();
    }

    public String getValue() {
        return this.string;
    }

    public void receivedBy(ApplicationDataReceiver applicationDataReceiver, ApplicationDataSender applicationDataSender) throws BadApplicationDataReceiverException {
        if (!(applicationDataReceiver instanceof KnownLengthStringDataReceiver)) {
            throw new BadApplicationDataReceiverException();
        }
        KnownLengthStringDataReceiver knownLengthStringDataReceiver = (KnownLengthStringDataReceiver)applicationDataReceiver;
        knownLengthStringDataReceiver.receiveKnownLengthStringData(this, applicationDataSender);
    }

    public String toString() {
        return "KnownLengthStringValue[\"" + this.string + "\", " + (this.description() == null ? "No metaData" : this.description().toString()) + "]";
    }
}

