/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.issdb.common;

public class MaskAccessor
implements Cloneable {
    private long mask;
    private int size;

    public MaskAccessor(int n) {
        this.mask = n;
        this.size = 32;
    }

    public MaskAccessor(long l) {
        this.mask = l;
        this.size = 64;
    }

    private MaskAccessor(long l, int n) {
        this.mask = l;
        this.size = n;
    }

    public MaskAccessor(short s) {
        this.mask = s;
        this.size = 16;
    }

    public boolean areAllBitsClear() {
        return this.mask == 0L;
    }

    public boolean areAllBitsSet() {
        if (this.size == 64) {
            return this.mask == -1L;
        }
        long l = (1L << this.size) - 1L;
        return this.mask == l;
    }

    public void clear(int n) {
        if (n < 0 || this.size <= n) {
            throw new IllegalArgumentException();
        }
        this.mask &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public Object clone() {
        return new MaskAccessor(this.mask, this.size);
    }

    public int countSetBits() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.size) {
            if ((this.mask & 1L << n2) != 0L) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public MaskAccessor createAND(MaskAccessor maskAccessor) {
        return new MaskAccessor(this.mask & maskAccessor.mask);
    }

    public boolean equals(MaskAccessor maskAccessor) {
        boolean bl = false;
        if (maskAccessor != null && maskAccessor.size == this.size && maskAccessor.mask == this.mask) {
            bl = true;
        }
        return bl;
    }

    public long getBits(int n) {
        if (n <= 0 || this.size < n) {
            throw new IllegalArgumentException();
        }
        if (n == 64) {
            return this.mask;
        }
        long l = (1L << n) - 1L;
        return this.mask & l;
    }

    public int getSize() {
        return this.size;
    }

    public long getValue() {
        return this.mask;
    }

    public boolean query(int n) {
        if (n < 0 || this.size <= n) {
            throw new IllegalArgumentException();
        }
        return (this.mask & 1L << n) != 0L;
    }

    public void set(int n) {
        if (n < 0 || this.size <= n) {
            throw new IllegalArgumentException();
        }
        this.mask |= 1L << n;
    }
}

