/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.issdb.common;

import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.GenericApplicationData;
import com.agilent.tntd.eclipse.issdb.common.MaskAccessor;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;

public class MaskedIntegerValue
extends GenericApplicationData {
    private final int value;
    private final long optionMask;
    private final long stateMask;
    private MaskAccessor optionMaskAccessor = null;
    private MaskAccessor stateMaskAccessor = null;
    private static final long DEFAULT_MASK = -1L;

    public MaskedIntegerValue(int n) {
        this.value = n;
        this.optionMask = -1L;
        this.stateMask = -1L;
    }

    public MaskedIntegerValue(int n, long l, long l2) {
        this.value = n;
        this.optionMask = l;
        this.stateMask = l2;
    }

    public MaskedIntegerValue(int n, MaskedIntegerValue maskedIntegerValue) {
        this.value = n;
        this.optionMask = maskedIntegerValue.optionMask;
        this.stateMask = maskedIntegerValue.stateMask;
    }

    public boolean equals(MaskedIntegerValue maskedIntegerValue) {
        if (maskedIntegerValue != null && this.value == maskedIntegerValue.value && this.stateMask == maskedIntegerValue.stateMask && this.optionMask == maskedIntegerValue.optionMask) {
            return super.equals(maskedIntegerValue);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof MaskedIntegerValue) {
            return this.equals((MaskedIntegerValue)object);
        }
        return false;
    }

    public MaskAccessor getOptionMask() {
        if (this.optionMaskAccessor == null) {
            this.optionMaskAccessor = new MaskAccessor(this.optionMask);
        }
        return this.optionMaskAccessor;
    }

    public MaskAccessor getStateMask() {
        if (this.stateMaskAccessor == null) {
            this.stateMaskAccessor = new MaskAccessor(this.stateMask);
        }
        return this.stateMaskAccessor;
    }

    public int getValue() {
        return this.value;
    }

    public boolean hasDifferentMasks(MaskedIntegerValue maskedIntegerValue) {
        return maskedIntegerValue == null ? true : this.optionMask != maskedIntegerValue.optionMask || this.stateMask != maskedIntegerValue.stateMask;
    }

    public void receivedBy(ApplicationDataReceiver applicationDataReceiver, ApplicationDataSender applicationDataSender) throws BadApplicationDataReceiverException {
        if (!(applicationDataReceiver instanceof MaskedIntegerDataReceiver)) {
            throw new BadApplicationDataReceiverException();
        }
        MaskedIntegerDataReceiver maskedIntegerDataReceiver = (MaskedIntegerDataReceiver)applicationDataReceiver;
        maskedIntegerDataReceiver.receiveMaskedIntegerData(this, applicationDataSender);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("MaskedInt[");
        stringBuffer.append(this.value);
        stringBuffer.append(" s");
        stringBuffer.append(Long.toString(this.stateMask, 16));
        stringBuffer.append(" o");
        stringBuffer.append(Long.toString(this.optionMask, 16));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

