/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.issdb.common;

import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.GenericApplicationData;
import com.agilent.tntd.eclipse.issdb.common.TimeDataReceiver;

public class TimeValue
extends GenericApplicationData {
    private int hours;
    private int minutes;
    private int seconds;

    public TimeValue() {
        this.hours = 0;
        this.minutes = 0;
        this.seconds = 0;
    }

    public TimeValue(int n, int n2, int n3) throws IllegalArgumentException {
        if (n < 0 || 23 < n || n2 < 0 || 59 < n2 || n3 < 0 || 59 < n3) {
            throw new IllegalArgumentException();
        }
        this.hours = n;
        this.minutes = n2;
        this.seconds = n3;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void receivedBy(ApplicationDataReceiver applicationDataReceiver, ApplicationDataSender applicationDataSender) throws BadApplicationDataReceiverException {
        if (!(applicationDataReceiver instanceof TimeDataReceiver)) {
            throw new BadApplicationDataReceiverException();
        }
        TimeDataReceiver timeDataReceiver = (TimeDataReceiver)applicationDataReceiver;
        timeDataReceiver.receiveTimeData(this, applicationDataSender);
    }

    public String toString() {
        return "Time[" + this.hours + ":" + this.minutes + ":" + this.seconds + "]";
    }
}

