/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.middleware;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.middleware.MessageHandler;
import com.agilent.tntd.eclipse.middleware.WcMessage;
import com.agilent.tntd.eclipse.middleware.WcObjectTransfer;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import java.io.IOException;

public class SocketReader
extends Thread {
    private MessageHandler handler;
    private WcObjectTransfer transfer;
    private boolean stopped;

    public SocketReader(WcObjectTransfer wcObjectTransfer, MessageHandler messageHandler) {
        super(EclipseSystem.instance().getEclipseThreadGroup(), "Socket Reader");
        this.setPriority(7);
        this.transfer = wcObjectTransfer;
        this.handler = messageHandler;
        this.stopped = false;
    }

    private synchronized boolean isActive() {
        return !this.stopped;
    }

    public void run() {
        try {
            while (this.isActive()) {
                Object object = this.transfer.readFrame();
                if (object instanceof WcMessage) {
                    this.handler.handleMessage((WcMessage)object);
                    continue;
                }
                EventLog.instance().log(String.valueOf(this.toString()) + " received unrecognised object type: " + (object == null ? "null" : object.getClass().getName()));
            }
        }
        catch (IOException iOException) {
            System.out.println(String.valueOf(this.toString()) + " was interrupted by exception " + iOException.toString());
        }
    }

    public synchronized void stopReceiving() {
        this.stopped = true;
    }
}

