/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.middleware;

import com.agilent.tntd.eclipse.bottomlayer.simpletypes.IntegerData;
import com.agilent.tntd.eclipse.middleware.ReusableByteArrayInputStream;
import com.agilent.tntd.eclipse.middleware.WcClassID;
import com.agilent.tntd.eclipse.middleware.cmd.WcCmdHandshake;
import com.agilent.tntd.eclipse.middleware.cmd.WcRspHandshake;
import com.agilent.tntd.eclipse.middleware.rw.ApplicationDataGroupReaderWriter;
import com.agilent.tntd.eclipse.middleware.rw.WcBooleanReaderWriter;
import com.agilent.tntd.eclipse.middleware.rw.WcByteArrayReaderWriter;
import com.agilent.tntd.eclipse.middleware.rw.WcByteReaderWriter;
import com.agilent.tntd.eclipse.middleware.rw.WcCharReaderWriter;
import com.agilent.tntd.eclipse.middleware.rw.WcDoubleReaderWriter;
import com.agilent.tntd.eclipse.middleware.rw.WcFloatReaderWriter;
import com.agilent.tntd.eclipse.middleware.rw.WcLongReaderWriter;
import com.agilent.tntd.eclipse.middleware.rw.WcObjectReaderWriter;
import com.agilent.tntd.eclipse.middleware.rw.WcShortReaderWriter;
import com.agilent.tntd.eclipse.middleware.rw.WcStringReaderWriter;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.PerformanceMonitor;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.List;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WcObjectTransfer {
    private DataInputStream inputStream;
    private DataOutputStream outputStream;
    private final HashMap readers = new HashMap(50);
    private final HashMap writers = new HashMap(50);
    private final ByteArrayOutputStream theOutputByteArrayStream = new ByteArrayOutputStream(10000);
    private final DataOutputStream thePrimitiveJavaDataTypeOutputStream = new DataOutputStream(this.theOutputByteArrayStream);
    private final ReusableByteArrayInputStream theInputByteArrayStream = new ReusableByteArrayInputStream(new byte[0]);
    private final DataInputStream thePrimitiveJavaDataTypeInputStream = new DataInputStream(this.theInputByteArrayStream);
    private final PerformanceMonitor thePerformanceMonitor = EclipseSystem.instance().getPerformanceMonitor();

    public WcObjectTransfer(DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
        this.outputStream = dataOutputStream;
        this.inputStream = dataInputStream;
        this.registerReaderWriter(new WcBooleanReaderWriter());
        this.registerReaderWriter(new WcByteReaderWriter());
        this.registerReaderWriter(new WcByteArrayReaderWriter());
        this.registerReaderWriter(new WcCharReaderWriter());
        this.registerReaderWriter(new WcDoubleReaderWriter());
        this.registerReaderWriter(new WcFloatReaderWriter());
        this.registerReaderWriter(new IntegerData(0));
        this.registerReaderWriter(new WcLongReaderWriter());
        this.registerReaderWriter(new WcShortReaderWriter());
        this.registerReaderWriter(new WcStringReaderWriter());
        this.registerReaderWriter(new ApplicationDataGroupReaderWriter());
        this.registerReaderWriter(new WcCmdHandshake());
        this.registerReaderWriter(new WcRspHandshake(false));
    }

    private void createStreamForCurrentFrame(int n) throws IOException {
        this.thePrimitiveJavaDataTypeInputStream.reset();
        byte[] byArray = new byte[n];
        int n2 = this.inputStream.read(byArray);
        if (n2 != n) {
            int n3 = 1;
            int n4 = 0;
            do {
                if ((n4 = this.inputStream.read(byArray, n2, n - n2)) <= 0) continue;
                n2 += n4;
            } while (n2 < n && ++n3 < 20);
            if (n2 != n) {
                throw new RuntimeException("Frame received is too fragmentated: more than 20 fragments. The size of the Frame is " + n + " bytes.");
            }
        }
        this.theInputByteArrayStream.setArrayForStream(byArray);
        this.setDataInputStream(this.thePrimitiveJavaDataTypeInputStream);
    }

    public byte getClientID() throws IOException {
        byte by = this.readByte();
        this.readByte();
        return by;
    }

    public String getInitialisationString() throws ClassCastException, IOException {
        StringBuffer stringBuffer = new StringBuffer(30);
        char c = '1';
        while (c != '\n') {
            c = (char)this.inputStream.readByte();
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public boolean handshake() {
        int n = 0;
        while (n < 2) {
            try {
                this.send(new WcCmdHandshake());
                byte by = this.readByte();
                if (by == -1) {
                    this.readShort();
                }
                Object object = this.read();
                if (!(object instanceof WcRspHandshake)) {
                    return false;
                }
                if (!((WcRspHandshake)object).isSameVersion()) {
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Object read() throws IOException {
        WcClassID wcClassID = new WcClassID(this.inputStream);
        if (wcClassID.isNullObjectID()) {
            return null;
        }
        WcObjectReaderWriter wcObjectReaderWriter = (WcObjectReaderWriter)this.readers.get((Object)wcClassID);
        Object object = null;
        try {
            object = wcObjectReaderWriter.deserialize(this);
        }
        catch (IOException iOException) {
            System.out.println(" exception in deserialise, id = " + wcClassID.toString());
            System.out.println(" and rw = " + wcObjectReaderWriter.getClassName() + " rw.id = " + wcObjectReaderWriter.getClassID());
            throw iOException;
        }
        return object;
    }

    public boolean readBoolean() throws IOException {
        return this.inputStream.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.inputStream.readByte();
    }

    public byte[] readByteArray() throws IOException {
        int n = this.inputStream.readInt();
        byte[] byArray = new byte[n];
        this.inputStream.read(byArray);
        return byArray;
    }

    public char readChar() throws IOException {
        return this.inputStream.readChar();
    }

    public double readDouble() throws IOException {
        return this.inputStream.readDouble();
    }

    public float readFloat() throws IOException {
        return this.inputStream.readFloat();
    }

    public Object readFrame() throws IOException {
        short s = this.readByte();
        short s2 = s == -1 ? this.readShort() : s;
        DataInputStream dataInputStream = this.inputStream;
        this.createStreamForCurrentFrame(s2);
        WcClassID wcClassID = new WcClassID(this.inputStream);
        Object object = null;
        if (wcClassID.isNullObjectID()) {
            object = null;
        } else {
            WcObjectReaderWriter wcObjectReaderWriter = (WcObjectReaderWriter)this.readers.get((Object)wcClassID);
            try {
                object = wcObjectReaderWriter.deserialize(this);
            }
            catch (IOException iOException) {
                System.out.println("Exception: " + iOException.toString() + " in deserialise, id = " + wcClassID.toString());
                System.out.println(" and rw = " + wcObjectReaderWriter.getClassName() + " rw.id = " + wcObjectReaderWriter.getClassID());
                throw iOException;
            }
        }
        this.thePerformanceMonitor.receivedBytes(s2);
        this.setDataInputStream(dataInputStream);
        return object;
    }

    public int readInt() throws IOException {
        return this.inputStream.readInt();
    }

    public long readLong() throws IOException {
        return this.inputStream.readLong();
    }

    public short readShort() throws IOException {
        return this.inputStream.readShort();
    }

    public String readString() throws IOException {
        Object object = this.read();
        if (object instanceof String) {
            return (String)object;
        }
        throw new IOException("incorrect data type");
    }

    public void registerReaderWriter(WcObjectReaderWriter wcObjectReaderWriter) {
        WcClassID wcClassID = wcObjectReaderWriter.getClassID();
        String string = wcObjectReaderWriter.getClassName();
        this.readers.put((Object)wcClassID, (Object)wcObjectReaderWriter);
        this.writers.put((Object)string, (Object)wcObjectReaderWriter);
    }

    public synchronized void send(Object object) throws IOException {
        this.writeLengthBefore(object);
        this.outputStream.flush();
    }

    public synchronized void sendQueue(List list) throws IOException {
        while (!list.isEmpty()) {
            Object object = list.remove(0);
            this.writeLengthBefore(object);
        }
        this.outputStream.flush();
    }

    void setDataInputStream(DataInputStream dataInputStream) {
        this.inputStream = dataInputStream;
    }

    void setDataOutputStream(DataOutputStream dataOutputStream) {
        this.outputStream = dataOutputStream;
    }

    public void write(byte[] byArray) throws IOException {
        this.outputStream.writeInt(byArray.length);
        this.outputStream.write(byArray, 0, byArray.length);
    }

    public void write(byte by) throws IOException {
        this.outputStream.writeByte(by);
    }

    public void write(char c) throws IOException {
        this.outputStream.writeChar(c);
    }

    public void write(double d) throws IOException {
        this.outputStream.writeDouble(d);
    }

    public void write(float f) throws IOException {
        this.outputStream.writeFloat(f);
    }

    public void write(int n) throws IOException {
        this.outputStream.writeInt(n);
    }

    public void write(long l) throws IOException {
        this.outputStream.writeLong(l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(Object object) throws IOException {
        if (object != null) {
            String string = object.getClass().getName();
            WcObjectReaderWriter wcObjectReaderWriter = (WcObjectReaderWriter)this.writers.get((Object)string);
            if (wcObjectReaderWriter == null) throw new IOException("No reader writer registered for " + string);
            wcObjectReaderWriter.getClassID().write(this.outputStream);
            wcObjectReaderWriter.serialize(object, this);
            return;
        } else {
            WcClassID.NULL_ID.write(this.outputStream);
        }
    }

    public void write(short s) throws IOException {
        this.outputStream.writeShort(s);
    }

    public void write(boolean bl) throws IOException {
        this.outputStream.writeBoolean(bl);
    }

    private void writeLengthBefore(Object object) throws IOException {
        DataOutputStream dataOutputStream = this.outputStream;
        this.setDataOutputStream(this.thePrimitiveJavaDataTypeOutputStream);
        try {
            this.write(object);
            int n = this.theOutputByteArrayStream.size();
            if (n > 127) {
                dataOutputStream.writeByte(-1);
                dataOutputStream.writeShort(n);
            } else {
                dataOutputStream.writeByte(n);
            }
            this.theOutputByteArrayStream.writeTo(dataOutputStream);
            this.theOutputByteArrayStream.reset();
            this.setDataOutputStream(dataOutputStream);
            this.thePerformanceMonitor.sentBytes(n);
        }
        catch (IOException iOException) {
            this.theOutputByteArrayStream.reset();
            this.setDataOutputStream(dataOutputStream);
            throw iOException;
        }
    }
}

