/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.common.util.SingletonRegistry;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseThreadGroup;
import com.agilent.tntd.eclipse.viewlayer.architecture.ExitErrorDialog;
import com.agilent.tntd.eclipse.viewlayer.architecture.HeapDiagnosticsThread;
import com.agilent.tntd.eclipse.viewlayer.architecture.PerformanceMonitor;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseWorkspace;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.awt.Toolkit;
import java.io.File;
import java.util.Properties;

public class EclipseSystem
implements ApplicationObjectObserver {
    private static EclipseSystem theInstance = null;
    private EclipseWorkspace theWorkspace = null;
    private final String ON_INSTRUMENT_PROPERTY = "instrument";
    private boolean isOnInstrument = false;
    private boolean isOnPersonnalJava = false;
    private final String DIRECTORY_PROPERTY = "eclipse.guicore.directory";
    private File fileDirectory = null;
    private final String COREDUMP_DIRECTORY_PROPERTY = "eclipse.guicore.longtermstoragedirectory";
    private File coredumpDirectory = null;
    private EclipseThreadGroup threadGroup = null;
    private final String MONITOR_HEAP_PROPERTY = "eclipse.guicore.heapdiagnostics.enabled";
    private final String HEAP_DIAGNOSTIC_FILENAME_PROPERTY = "eclipse.guicore.heapdiagnostics.filename";
    private final String HEAP_DIAGNOSTIC_PERIOD_PROPERTY = "eclipse.guicore.heapdiagnostics.period";
    private final String defaultHeapDiagnosticsFilename = "javaheap.dat";
    private PerformanceMonitor thePerformanceMonitor;
    private final String MONITOR_PERFORMANCE_PROPERTY = "eclipse.guicore.performance.monitor";
    private final Map theMap = Collections.synchronizedMap((Map)new HashMap());
    private ApplicationObject theApplicationObject = null;

    private EclipseSystem() {
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            this.theApplicationObject = null;
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
        } else if (errorReporter.getErrorStatus() == 3) {
            this.theApplicationObject = null;
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
        } else {
            this.theApplicationObject = applicationObject;
        }
    }

    public void beep() {
        if (!this.isOnInstrument()) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void checkEclipseSystemInitialisation() {
        if (this.theWorkspace == null) {
            throw new NullPointerException("The Eclipse System was not initialised by the workspace.");
        }
    }

    public void exit() {
        if (this.theWorkspace != null) {
            this.theWorkspace.disconnect();
        }
        if (this.threadGroup != null) {
            this.threadGroup.exit();
        }
        if (EventLog.instance().getSize() != 0) {
            System.out.println("Start output of the event log:");
            int n = 0;
            while (n < EventLog.instance().getSize()) {
                System.out.println(EventLog.instance().getEvent(n));
                ++n;
            }
            System.exit(-1);
        }
        System.exit(0);
    }

    public void exitWithError(String string) {
        if (this.theWorkspace != null) {
            ExitErrorDialog exitErrorDialog = new ExitErrorDialog();
            exitErrorDialog.setSize(300, 200);
            if (string.charAt(string.length() - 1) == '.') {
                exitErrorDialog.displayMessageWindow(false, true, false, String.valueOf(string) + " To exit this application, press Close.", "Close this application", exitErrorDialog, null);
            } else {
                exitErrorDialog.displayMessageWindow(false, true, false, String.valueOf(string) + ". To exit this application, press Close.", "Close this application", exitErrorDialog, null);
            }
        } else {
            EventLog.instance().log(string);
            this.exit();
        }
    }

    public ThreadGroup getEclipseThreadGroup() {
        if (this.threadGroup == null) {
            this.threadGroup = new EclipseThreadGroup();
        }
        return this.threadGroup;
    }

    public File getFileEclipseDirectory() {
        return this.fileDirectory;
    }

    public File getLongTermStorageDirectory() {
        return this.coredumpDirectory;
    }

    public PerformanceMonitor getPerformanceMonitor() {
        return this.thePerformanceMonitor;
    }

    public Map getPlatformMap() {
        return this.theMap;
    }

    public void initialise(EclipseWorkspace eclipseWorkspace) {
        this.theWorkspace = eclipseWorkspace;
        this.checkEclipseSystemInitialisation();
        Properties properties = System.getProperties();
        String string = properties.getProperty("instrument");
        if ("1".equalsIgnoreCase(string)) {
            this.isOnInstrument = true;
        } else {
            string = properties.getProperty("java.version");
            if ("3.1".equalsIgnoreCase(string)) {
                this.isOnPersonnalJava = true;
            }
        }
        string = properties.getProperty("eclipse.guicore.directory");
        if (string == null) {
            EventLog.instance().log("eclipse.guicore.directory property was not set");
        } else {
            this.fileDirectory = new File(string);
        }
        string = properties.getProperty("eclipse.guicore.longtermstoragedirectory");
        if (string == null) {
            EventLog.instance().log("eclipse.guicore.longtermstoragedirectory property was not set");
        } else {
            this.coredumpDirectory = new File(string);
        }
        string = properties.getProperty("eclipse.guicore.heapdiagnostics.enabled");
        if ("true".equalsIgnoreCase(string)) {
            this.initialiseHeapThread(properties);
        }
        this.thePerformanceMonitor = "true".equalsIgnoreCase(string = properties.getProperty("eclipse.guicore.performance.monitor")) ? new PerformanceMonitor(true) : new PerformanceMonitor(false);
    }

    public void initialiseControlVariable() {
        ApplicationManager.instance().request("ISS", 0, "IS_GUI_IN_CONTROL_OF", (ApplicationObjectObserver)this);
    }

    private void initialiseHeapThread(Properties properties) {
        String string = properties.getProperty("eclipse.guicore.heapdiagnostics.filename", "javaheap.dat");
        long l = Long.parseLong(properties.getProperty("eclipse.guicore.heapdiagnostics.period", "60"));
        new HeapDiagnosticsThread(string, l);
    }

    public static synchronized EclipseSystem instance() {
        if (theInstance == null) {
            theInstance = new EclipseSystem();
            SingletonRegistry.instance().add(theInstance);
        }
        return theInstance;
    }

    public boolean isControllingClient() {
        if (this.theApplicationObject != null) {
            return this.theApplicationObject.change(new KnownLengthStringValue("Default"));
        }
        return true;
    }

    public boolean isOnInstrument() {
        return this.isOnInstrument;
    }

    public boolean isPersonnalJavaPlatform() {
        return this.isOnPersonnalJava;
    }

    public void printStackBackTrace() {
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
    }
}

