/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture;

import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseThread;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.WindowManager;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class EclipseThreadGroup
extends ThreadGroup {
    private final String LOG_FILE_NAME = "EPA_GC.LOG";

    public EclipseThreadGroup() {
        super("Eclipse Thread Group");
    }

    public void exit() {
        Thread[] threadArray = new Thread[this.activeCount()];
        this.enumerate(threadArray);
        int n = 0;
        while (n < threadArray.length) {
            if (threadArray[n] instanceof EclipseThread) {
                ((EclipseThread)((Object)threadArray[n])).stopEclipseThread();
            }
            ++n;
        }
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        try {
            if (!(throwable instanceof ThreadDeath)) {
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                throwable.printStackTrace(new PrintWriter(charArrayWriter));
                String string = new String("This exception occured in Thread:\n");
                charArrayWriter.write(string, 0, string.length());
                string = new String(String.valueOf(thread.toString()) + "\n");
                charArrayWriter.write(string, 0, string.length());
                File file = EclipseSystem.instance().getLongTermStorageDirectory();
                if (file == null) {
                    System.out.println("Do not know the directory to store the error log file");
                    throwable.printStackTrace(System.out);
                } else {
                    File file2 = new File(file, "EPA_GC.LOG");
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    PrintWriter printWriter = new PrintWriter(fileOutputStream);
                    charArrayWriter.writeTo(printWriter);
                    printWriter.flush();
                    fileOutputStream.close();
                }
                WindowManager.instance().createModalErrorWindow(new CharArrayReader(charArrayWriter.toCharArray()));
            }
        }
        catch (Throwable throwable2) {
            throwable2.printStackTrace(System.out);
            throwable.printStackTrace(System.out);
        }
    }
}

