/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture;

import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseThread;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class HeapDiagnosticsThread
extends Thread
implements EclipseThread {
    private File heapDiagnosticsFile = null;
    private FileWriter heapDiagnosticsWriter = null;
    private long heapDiagnosticsStartTime = 0L;
    private long heapDiagnosticsPeriod = 0L;
    private boolean stopped = false;

    public HeapDiagnosticsThread(String string, long l) {
        super(EclipseSystem.instance().getEclipseThreadGroup(), "Heap Diagnostics");
        this.heapDiagnosticsPeriod = l * 1000L;
        this.initHeapDiagnostics(string);
    }

    private void dumpHeapDiagnostics() {
        if (this.heapDiagnosticsFile == null || this.heapDiagnosticsWriter == null) {
            return;
        }
        try {
            long l = (System.currentTimeMillis() - this.heapDiagnosticsStartTime) / 1000L;
            String string = "" + l + ", " + Runtime.getRuntime().freeMemory();
            this.heapDiagnosticsWriter = new FileWriter(this.heapDiagnosticsFile);
            this.heapDiagnosticsWriter.write(string);
            this.heapDiagnosticsWriter.close();
        }
        catch (IOException iOException) {}
    }

    private void initHeapDiagnostics(String string) {
        try {
            File file = EclipseSystem.instance().getFileEclipseDirectory();
            this.heapDiagnosticsFile = file != null ? new File(EclipseSystem.instance().getFileEclipseDirectory(), string) : new File(string);
            if (this.heapDiagnosticsFile.exists()) {
                this.heapDiagnosticsFile.delete();
            }
            this.heapDiagnosticsWriter = new FileWriter(this.heapDiagnosticsFile);
        }
        catch (IOException iOException) {}
        this.heapDiagnosticsStartTime = System.currentTimeMillis();
        this.dumpHeapDiagnostics();
        this.start();
    }

    private synchronized boolean isActive() {
        return !this.stopped;
    }

    public void run() {
        while (this.isActive()) {
            try {
                Thread.sleep(this.heapDiagnosticsPeriod);
            }
            catch (InterruptedException interruptedException) {}
            this.dumpHeapDiagnostics();
        }
    }

    public synchronized void stopEclipseThread() {
        this.stopped = true;
        if (this.heapDiagnosticsWriter != null) {
            try {
                this.heapDiagnosticsWriter.close();
            }
            catch (IOException iOException) {}
            this.heapDiagnosticsWriter = null;
        }
        this.heapDiagnosticsFile = null;
    }
}

