/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseThread;

public class SchedulerThread
extends Thread
implements EclipseThread {
    private boolean stopped;
    private Runnable theTaskToRun;
    private int thePeriod;

    public SchedulerThread(Runnable runnable, int n) {
        super(EclipseSystem.instance().getEclipseThreadGroup(), "Eclipse Scheduler");
        this.setPriority(10);
        this.theTaskToRun = runnable;
        this.thePeriod = n;
        this.stopped = false;
    }

    private synchronized boolean isActive() {
        return !this.stopped;
    }

    public void run() {
        while (this.isActive()) {
            this.theTaskToRun.run();
            try {
                Thread.sleep(this.thePeriod);
            }
            catch (InterruptedException interruptedException) {
                EventLog.instance().log(String.valueOf(this.toString()) + " was interrupted by " + interruptedException.toString());
                this.stopEclipseThread();
            }
        }
    }

    public synchronized void stopEclipseThread() {
        this.stopped = true;
    }
}

