/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture.components;

import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.contexthelp.ContextHelpController;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.beans.Beans;

public abstract class EclipseComponent
extends Component {
    private transient Rectangle myBounds = new Rectangle(0, 0, 0, 0);
    private transient Font myFont = null;
    private transient Color myForegroundColor = null;
    private transient Color myBackgroundColor = null;
    private transient String domainName = "ISS";
    private transient String helpId = null;
    private transient ContextHelpController theContextHelpController = null;
    private transient boolean hasFocus = false;

    public Color getBackground() {
        return this.myBackgroundColor;
    }

    public Rectangle getBounds() {
        return this.myBounds;
    }

    /*
     * Unable to fully structure code
     */
    private ContextHelpController getContextHelpController() {
        block2: {
            if (this.theContextHelpController != null) break block2;
            var1_1 = this.getParent();
            if (var1_1 != null) ** GOTO lbl6
            throw new NullPointerException("Cannot find the parent of " + this.toString());
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.getParent();
lbl6:
                // 2 sources

                ** while (var1_1.getParent() != null)
            }
lbl7:
            // 1 sources

            if (!(var1_1 instanceof ContextHelpController)) {
                throw new NullPointerException("The root parent " + var1_1.toString() + " doesn't implement ContextHelpController");
            }
            this.theContextHelpController = (ContextHelpController)var1_1;
        }
        return this.theContextHelpController;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public final EclipseComponent getEclipseComponent() {
        return this;
    }

    protected abstract EclipseView getEclipseView();

    public Font getFont() {
        return this.myFont;
    }

    public Color getForeground() {
        return this.myForegroundColor;
    }

    protected String getHelpId() {
        return this.helpId != null ? this.helpId : "";
    }

    public Color getVisibleBackground() {
        if (this.myBackgroundColor != null) {
            return this.myBackgroundColor;
        }
        Component component = this;
        while (component != null) {
            if (((Component)component).getBackground() != null) {
                return ((Component)component).getBackground();
            }
            component = component.getParent();
        }
        return Color.lightGray;
    }

    protected abstract void initialiseModel();

    public boolean isFocusTraversable() {
        return false;
    }

    public void paint(Graphics graphics) {
        if (this.getEclipseView() == null) {
            if (!Beans.isDesignTime()) {
                System.out.println("paint method called on eclipse component called " + this.getName() + " without an initialised model");
            } else {
                this.initialiseModel();
                this.getEclipseView().paint(graphics);
            }
        } else if (this.isVisible()) {
            this.getEclipseView().paint(graphics);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1004) {
            this.hasFocus = true;
            this.getContextHelpController().displayContextHelp(this.helpId);
        } else if (focusEvent.getID() == 1005) {
            this.hasFocus = false;
            this.getContextHelpController().removeContextHelp(this.helpId);
        }
    }

    public final void removeNotify() {
        super.removeNotify();
        if (this.hasFocus) {
            this.processFocusEvent(new FocusEvent(this, 1005));
        }
    }

    public void requestFocus() {
        if (this.isFocusTraversable() && EclipseFocusManager.getInstance().canRequestFocus(this)) {
            super.requestFocus();
        }
    }

    public void setBackground(Color color) {
        this.myBackgroundColor = color;
        super.setBackground(color);
        if (this.getEclipseView() != null) {
            this.getEclipseView().notifyEclipseComponentChanged();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.myBounds.x = n;
        this.myBounds.y = n2;
        this.myBounds.width = n3;
        this.myBounds.height = n4;
        super.setBounds(n, n2, n3, n4);
        if (this.getEclipseView() != null) {
            this.getEclipseView().notifyEclipseComponentChanged();
        }
        if (Beans.isDesignTime() && this.getParent() != null) {
            this.getParent().repaint();
        }
    }

    public void setDomainName(String string) {
        this.domainName = string;
    }

    public void setFont(Font font) {
        this.myFont = font;
        super.setFont(font);
        if (this.getEclipseView() != null) {
            this.getEclipseView().notifyEclipseComponentChanged();
        }
    }

    public void setForeground(Color color) {
        this.myForegroundColor = color;
        super.setForeground(color);
        if (this.getEclipseView() != null) {
            this.getEclipseView().notifyEclipseComponentChanged();
        }
    }

    public void setHelpId(String string) {
        this.helpId = string == null ? null : string.trim();
    }

    public final void update(Graphics graphics) {
        this.paint(graphics);
    }
}

