/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice;

import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseGraphicsHelper;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.GreyableString;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SingleSelectableChoiceController;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SingleSelectableChoicePopup;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SingleSelectableChoiceView;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclComboBoxDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseActionnedComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.beans.Beans;

public class SingleSelectableChoiceButtonListView
implements SingleSelectableChoiceView,
MouseActionnedComponent {
    private SingleSelectableChoiceController theSingleChoiceController;
    private static SingleSelectableChoicePopup popup = new SingleSelectableChoicePopup();
    private int width;
    private int height;
    private int left;
    private int top;
    private int right;
    private int bottom;
    private int iconTop;
    private int iconLeft;
    private int textX = 0;
    private int textY = 0;
    private boolean isButtonPressed = false;
    private GreyableString[] myChoices = null;
    protected int selectedIndex = -1;
    private boolean isBorderPainted = true;
    int bottomOfPopupOnScreen;
    int bottomOfRootPaneOnScreen;
    private static UnconsumedKeyHandler theMainKeyController = null;
    private int iconWidth = 7;
    private int iconHeight = (this.iconWidth + 1) / 2;
    private int[] iconXPoints = new int[]{0, 0, 0};
    private int[] iconYPoints = new int[]{0, 0, 0};
    protected GreyableString selectedString = null;
    private boolean isPopupVisible = false;

    public SingleSelectableChoiceButtonListView(SingleSelectableChoiceController singleSelectableChoiceController) {
        this.theSingleChoiceController = singleSelectableChoiceController;
        if (this.theSingleChoiceController != null) {
            this.notifyEclipseComponentChanged();
        }
    }

    private void activatePopupMenu() {
        if (this.shouldActivatePopup()) {
            popup.initialise(this, this.myChoices, this.getEclipseComponent().getBounds(), this.getEclipseComponent().getFont(), this.getEclipseComponent().getForeground(), this.getEclipseComponent().getVisibleBackground());
            this.showPopup();
            popup.requestFocus();
        }
    }

    public void doLeftClickAction() {
        this.activatePopupMenu();
    }

    public void doRightClickAction() {
        this.getMainKeyController().processUnconsumedKeyEvents(InstrumentKeyMappings.getMenuKeyEvent(this.getEclipseComponent()), this.getEclipseComponent());
    }

    EclipseComponent getEclipseComponent() {
        return this.theSingleChoiceController.getEclipseComponent();
    }

    /*
     * Unable to fully structure code
     */
    private UnconsumedKeyHandler getMainKeyController() {
        block2: {
            if (SingleSelectableChoiceButtonListView.theMainKeyController != null) break block2;
            var1_1 = this.getEclipseComponent().getParent();
            if (var1_1 != null) ** GOTO lbl6
            throw new NullPointerException("Cannot find the parent of " + this.getEclipseComponent().toString());
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.getParent();
lbl6:
                // 2 sources

                ** while (var1_1.getParent() != null)
            }
lbl7:
            // 1 sources

            if (!(var1_1 instanceof UnconsumedKeyHandler)) {
                throw new NullPointerException("The root parent " + var1_1.toString() + " doesn't implement UnconsumedKeyHandler");
            }
            SingleSelectableChoiceButtonListView.theMainKeyController = (UnconsumedKeyHandler)var1_1;
        }
        return SingleSelectableChoiceButtonListView.theMainKeyController;
    }

    public MouseActionnedComponent getMouseActionnedComponent() {
        return this;
    }

    int getSelectedIndex() {
        return this.myChoices == null ? -1 : this.selectedIndex;
    }

    public GreyableString getSelectedString() {
        return this.myChoices == null ? null : this.selectedString;
    }

    public boolean hasFocus() {
        return this.isPopupVisible;
    }

    public void initialiseDesignTimeView(GreyableString[] greyableStringArray) {
        this.myChoices = greyableStringArray;
        this.setBorderPainted(false);
        this.setSelectedIndex(0, false);
    }

    public void initialiseView(GreyableString[] greyableStringArray) {
        this.myChoices = greyableStringArray;
        this.setBorderPainted(false);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isUserSelectable() {
        return true;
    }

    public void notifyEclipseComponentChanged() {
        this.updateSizeProperties(new Insets(0, 1, 1, 3));
    }

    public void notifyPopupVisibilityChange(boolean bl) {
        this.isPopupVisible = bl;
    }

    public void paint(Graphics graphics) {
        int n = this.getEclipseComponent().getBounds().width;
        int n2 = this.getEclipseComponent().getBounds().height;
        if (this.getEclipseComponent().getBackground() != null) {
            graphics.setColor(this.getEclipseComponent().getBackground());
            graphics.fillRect(1, 1, n - 2, n2 - 2);
        }
        graphics.setFont(this.getEclipseComponent().getFont());
        graphics.setColor(this.getEclipseComponent().isEnabled() ? this.getEclipseComponent().getForeground() : this.getEclipseComponent().getVisibleBackground().darker());
        if (this.getSelectedIndex() != -1) {
            graphics.drawString(this.myChoices[this.getSelectedIndex()].getValue(), this.textX, this.textY);
        } else if (Beans.isDesignTime()) {
            graphics.drawString(this.getEclipseComponent().getName(), this.textX, this.textY);
        }
        this.paintIcon(graphics);
        EclipseGraphicsHelper.paintRaisedBox(graphics, 1, 1, n - 2, n2 - 2);
        if (Beans.isDesignTime()) {
            graphics.setColor(this.getEclipseComponent().getVisibleBackground().darker());
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        }
        if (this.theSingleChoiceController.hasFocus()) {
            graphics.setColor(EclComboBoxDefaults.focusColour);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        }
    }

    protected void paint3DHighlights(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, Color color2, boolean bl) {
        int n6 = n + n3 - 1;
        int n7 = n2 + n4 - 1;
        int n8 = 0;
        while (n8 < n5) {
            graphics.setColor(bl ? color : color2);
            graphics.drawLine(n + n8, n2 + n8, n6 - n8, n2 + n8);
            graphics.drawLine(n + n8, n2 + n8, n + n8, n7 - n8);
            graphics.setColor(bl ? color2 : color);
            graphics.drawLine(n6 - n8, n2 + n8, n6 - n8, n7 - n8);
            graphics.drawLine(n + n8, n7 - n8, n6 - n8, n7 - n8);
            ++n8;
        }
    }

    protected void paintIcon(Graphics graphics) {
        if (this.getEclipseComponent().isEnabled() && this.shouldActivatePopup()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.gray);
        }
        int n = 0;
        while (n < this.iconHeight) {
            graphics.drawLine(this.iconLeft + n, this.iconTop + n, this.iconLeft + this.iconWidth - n - 1, this.iconTop + n);
            ++n;
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                case 10: {
                    this.activatePopupMenu();
                    keyEvent.consume();
                    break;
                }
                case 38: 
                case 40: {
                    if (!popup.isVisible()) break;
                    keyEvent.consume();
                    break;
                }
                case 0: {
                    keyEvent.consume();
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            this.getMainKeyController().processUnconsumedKeyEvents(keyEvent, this.getEclipseComponent());
        }
    }

    public void repaint() {
        if (this.getEclipseComponent() != null) {
            this.getEclipseComponent().repaint();
        }
    }

    public void requestFocus() {
        if (this.getEclipseComponent() != null) {
            this.getEclipseComponent().requestFocus();
        }
    }

    private void setBorderPainted(boolean bl) {
        this.isBorderPainted = bl;
    }

    public boolean setSelectedIndex(int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.myChoices != null && this.myChoices.length > n && n > -1;
        if (bl2) {
            if (this.selectedIndex != n) {
                this.selectedIndex = n;
                this.selectedString = this.myChoices[n];
                if (bl) {
                    this.theSingleChoiceController.setSelectedIndex(n);
                }
                this.theSingleChoiceController.setSelectedString(this.selectedString);
            }
        } else {
            this.selectedIndex = -1;
            this.selectedString = null;
        }
        return bl2;
    }

    private boolean shouldActivatePopup() {
        boolean bl = true;
        if (!Beans.isDesignTime()) {
            if (this.myChoices != null) {
                int n = 0;
                int n2 = 0;
                while (n != 2 && bl) {
                    if (this.myChoices[n2].getState()) {
                        ++n;
                    }
                    if (this.myChoices.length - 1 >= ++n2 || n == 2) continue;
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    void showPopup() {
        popup.setComponentFocusableOnClose(this.getEclipseComponent());
        popup.showRelativeToComponent(this.getEclipseComponent(), 0, this.getEclipseComponent().getBounds().height + 1);
    }

    private void updateSizeProperties(Insets insets) {
        EclipseComponent eclipseComponent = this.getEclipseComponent();
        this.width = ((Component)eclipseComponent).getBounds().width - (insets.left + insets.right);
        this.height = ((Component)eclipseComponent).getBounds().height - (insets.top + insets.bottom);
        this.left = insets.left;
        this.top = insets.top;
        this.right = this.left + (this.width - 1);
        this.bottom = this.top + (this.height - 1);
        FontMetrics fontMetrics = eclipseComponent.getFontMetrics(((Component)eclipseComponent).getFont());
        int n = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
        this.textX = 5;
        this.textY = (((Component)eclipseComponent).getBounds().height - n) / 2;
        this.textY += fontMetrics.getMaxAscent();
        this.iconLeft = this.right - this.iconWidth - 2;
        this.iconTop = (this.height - this.iconHeight) / 2 + this.top;
    }
}

