/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.GreyableString;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SingleSelectableChoiceController;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SingleSelectableChoiceView;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseActionnedComponent;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;

public class SingleSelectableChoiceLabelView
implements SingleSelectableChoiceView {
    private transient SingleSelectableChoiceController theSingleChoiceController;
    private transient GreyableString[] textItemList;
    private transient int theSelectedIndex;
    private Point textOrigin = new Point(0, 0);
    private int textHeight = 0;

    public SingleSelectableChoiceLabelView(SingleSelectableChoiceController singleSelectableChoiceController) {
        this.theSingleChoiceController = singleSelectableChoiceController;
        this.notifyEclipseComponentChanged();
    }

    private EclipseComponent getEclipseComponent() {
        return this.theSingleChoiceController.getEclipseComponent();
    }

    public MouseActionnedComponent getMouseActionnedComponent() {
        return null;
    }

    private int getSelectedIndex() {
        return this.textItemList == null ? -1 : this.theSelectedIndex;
    }

    public boolean hasFocus() {
        return false;
    }

    public void initialiseDesignTimeView(GreyableString[] greyableStringArray) {
        this.textItemList = greyableStringArray;
        this.setSelectedIndex(0, false);
    }

    public void initialiseView(GreyableString[] greyableStringArray) {
        this.textItemList = greyableStringArray;
    }

    public void initialiseView(boolean bl, GreyableString[] greyableStringArray) {
        if (bl) {
            this.textItemList = greyableStringArray;
        } else {
            this.getEclipseComponent().setEnabled(false);
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isUserSelectable() {
        return false;
    }

    public void notifyEclipseComponentChanged() {
        EclipseComponent eclipseComponent = this.theSingleChoiceController.getEclipseComponent();
        Rectangle rectangle = ((Component)eclipseComponent).getBounds();
        FontMetrics fontMetrics = null;
        if (((Component)eclipseComponent).getFont() != null) {
            fontMetrics = eclipseComponent.getFontMetrics(((Component)eclipseComponent).getFont());
        }
        if (fontMetrics != null) {
            this.textHeight = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            this.textOrigin.x = 3;
            this.textOrigin.y = (rectangle.height - this.textHeight) / 2 + fontMetrics.getMaxAscent();
        }
        if (this.textItemList != null) {
            this.getEclipseComponent().repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (this.getEclipseComponent().getBackground() != null) {
            graphics.setColor(this.getEclipseComponent().getBackground());
            graphics.fillRect(0, 0, this.getEclipseComponent().getBounds().width, this.getEclipseComponent().getBounds().height);
        }
        if (this.getEclipseComponent().isEnabled()) {
            graphics.setColor(this.getEclipseComponent().getForeground());
        } else {
            graphics.setColor(this.getEclipseComponent().getVisibleBackground().darker());
        }
        graphics.setFont(this.getEclipseComponent().getFont());
        String string = this.getSelectedIndex() != -1 && this.textItemList != null && this.textItemList.length > this.theSelectedIndex && this.textItemList[this.theSelectedIndex].getValue() != null ? this.textItemList[this.theSelectedIndex].getValue() : this.getEclipseComponent().getName();
        graphics.drawString(string, this.textOrigin.x, this.textOrigin.y);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public boolean setSelectedIndex(int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.textItemList != null && this.textItemList.length > n && n > -1;
        if (bl2) {
            this.theSelectedIndex = n;
            if (bl) {
                EventLog.instance().log(String.valueOf(this.getEclipseComponent().toString()) + " The SingleSelectionLabelView cannot make changes: error in the code");
            }
        } else {
            this.theSelectedIndex = -1;
        }
        return bl2;
    }
}

