/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.GreyableString;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.MaskCellRenderer;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SingleSelectableChoiceButtonListView;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SingleSelectableChoicePopupListModel;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclComboBoxDefaults;
import com.agilent.tntd.eclipse.viewlayer.menus.EclPopupMenu;
import com.sun.java.swing.JList;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.ListCellRenderer;
import com.sun.java.swing.ListModel;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;

class SingleSelectableChoicePopup
extends EclPopupMenu {
    private SingleSelectableChoicePopupListModel listModel = new SingleSelectableChoicePopupListModel();
    private JList list = new JList((ListModel)this.listModel);
    private JScrollPane scroller;
    private SingleSelectableChoiceButtonListView theView;
    private ListSelectionListener listSelectionListener;
    private MaskCellRenderer cellRenderer;
    private boolean valueIsAdjusting = false;
    private Dimension minimumSize;

    public SingleSelectableChoicePopup() {
        super(false);
        this.configureList();
        this.scroller = new JScrollPane((Component)this.list, 20, 31);
        this.configureScroller();
        this.configurePopup();
    }

    private void configureList() {
        this.list.setSelectionForeground(EclComboBoxDefaults.selectedListForeground);
        this.list.setSelectionBackground(EclComboBoxDefaults.selectedListBackground);
        this.list.setBackground(EclComboBoxDefaults.listBackground);
        this.list.setForeground(EclComboBoxDefaults.listForeground);
        this.list.setBorder(null);
        this.cellRenderer = new MaskCellRenderer();
        this.list.setCellRenderer((ListCellRenderer)this.cellRenderer);
        this.list.setRequestFocusEnabled(false);
        this.listSelectionListener = new ListSelListener(this);
        this.list.addListSelectionListener(this.listSelectionListener);
        this.list.setRequestFocusEnabled(false);
    }

    private void configurePopup() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroller, "Center");
    }

    private void configureScroller() {
        this.scroller.setRequestFocusEnabled(false);
        this.scroller.getVerticalScrollBar().setRequestFocusEnabled(false);
        this.scroller.getVerticalScrollBar().setBackground(EclComboBoxDefaults.scrollbarBackground);
        this.scroller.getVerticalScrollBar().setForeground(Color.red);
        this.scroller.setBorder(null);
    }

    protected Dimension getDefiniteSize() {
        return this.minimumSize;
    }

    public Dimension getMaximumSize() {
        return this.minimumSize;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize;
    }

    public Dimension getPreferredSize() {
        return this.minimumSize;
    }

    private void highlightNextItem() {
        if (this.isVisible()) {
            this.valueIsAdjusting = true;
            int n = this.list.getSelectedIndex();
            if (n != this.list.getModel().getSize() - 1) {
                this.list.setSelectedIndex(n + 1);
                this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
            }
            this.valueIsAdjusting = false;
        }
    }

    private void highlightPreviousItem() {
        if (this.isVisible()) {
            this.valueIsAdjusting = true;
            int n = this.list.getSelectedIndex();
            if (n != 0) {
                this.list.setSelectedIndex(n - 1);
                this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
            }
            this.valueIsAdjusting = false;
        }
    }

    public void initialise(SingleSelectableChoiceButtonListView singleSelectableChoiceButtonListView, GreyableString[] greyableStringArray, Rectangle rectangle, Font font, Color color, Color color2) {
        this.theView = singleSelectableChoiceButtonListView;
        this.listModel.setList(greyableStringArray);
        this.cellRenderer.setFont(font);
        this.list.setForeground(color);
        this.list.setBackground(color2);
        this.list.setVisibleRowCount(Math.min(greyableStringArray.length, 14));
        this.list.setSelectedIndex(this.theView.getSelectedIndex());
        this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        this.invalidate();
        this.minimumSize = this.getLayout().preferredLayoutSize(this);
        this.minimumSize.width = Math.max(this.theView.getEclipseComponent().getBounds().width, this.minimumSize.width);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        switch (focusEvent.getID()) {
            case 1005: {
                if (!focusEvent.isTemporary()) break;
                this.theView.requestFocus();
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                case 27: {
                    this.setVisible(false);
                    this.theView.requestFocus();
                    this.theView.repaint();
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    this.highlightPreviousItem();
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    this.highlightNextItem();
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    this.selectCurrentItem();
                    keyEvent.consume();
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    public void requestFocus() {
        if (!this.isVisible()) {
            this.theView.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    private void selectCurrentItem() {
        if (!this.isVisible()) {
            this.theView.showPopup();
        } else {
            int n = this.list.getSelectedIndex();
            if (this.listModel.getElementAt(n) instanceof GreyableString) {
                if (((GreyableString)this.listModel.getElementAt(n)).getState()) {
                    this.setVisible(false);
                    this.theView.requestFocus();
                    this.theView.setSelectedIndex(this.list.getSelectedIndex(), true);
                }
            } else {
                EventLog.instance().log(String.valueOf(this.theView.getEclipseComponent().toString()) + " is in error, attempt to select a non Greyable String");
                this.setVisible(false);
                this.theView.requestFocus();
                this.theView.setSelectedIndex(this.list.getSelectedIndex(), true);
            }
        }
    }

    public void setVisible(boolean bl) {
        if (this.isVisible() != bl) {
            super.setVisible(bl);
            if (this.theView != null) {
                this.theView.notifyPopupVisibilityChange(bl);
            }
        }
    }

    public void unregister() {
        this.theView = null;
    }

    static JList access$list(SingleSelectableChoicePopup singleSelectableChoicePopup) {
        return singleSelectableChoicePopup.list;
    }

    static boolean access$valueIsAdjusting(SingleSelectableChoicePopup singleSelectableChoicePopup) {
        return singleSelectableChoicePopup.valueIsAdjusting;
    }

    static SingleSelectableChoiceButtonListView access$theView(SingleSelectableChoicePopup singleSelectableChoicePopup) {
        return singleSelectableChoicePopup.theView;
    }

    private class ListSelListener
    implements ListSelectionListener {
        /* synthetic */ SingleSelectableChoicePopup this$0;

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.this$0.isVisible() && !SingleSelectableChoicePopup.access$valueIsAdjusting(this.this$0) && !listSelectionEvent.getValueIsAdjusting()) {
                SingleSelectableChoicePopup.access$theView(this.this$0).requestFocus();
                SingleSelectableChoicePopup.access$theView(this.this$0).setSelectedIndex(SingleSelectableChoicePopup.access$list(this.this$0).getSelectedIndex(), true);
            }
        }

        ListSelListener(SingleSelectableChoicePopup singleSelectableChoicePopup) {
            this.this$0 = singleSelectableChoicePopup;
        }
    }
}

