/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture.containers;

import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseContainerView;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.Beans;

public abstract class EclipseContainer
extends Container {
    private transient Rectangle myBounds = new Rectangle(0, 0, 0, 0);
    private transient Color myBackgroundColor = null;

    public Color getBackground() {
        return this.myBackgroundColor;
    }

    public Rectangle getBounds() {
        return this.myBounds;
    }

    protected abstract EclipseContainerView getEclipseContainerView();

    public Insets getInsets() {
        if (this.getEclipseContainerView() != null) {
            return this.getEclipseContainerView().getInsets();
        }
        return super.getInsets();
    }

    public Color getVisibleBackground() {
        if (this.myBackgroundColor != null) {
            return this.myBackgroundColor;
        }
        Container container = this.getParent();
        while (container != null) {
            if (container.getBackground() != null) {
                return container.getBackground();
            }
            container = container.getParent();
        }
        return Color.lightGray;
    }

    protected boolean hasView() {
        return true;
    }

    protected abstract void initialiseModel();

    public boolean isFocusTraversable() {
        return false;
    }

    public void paint(Graphics graphics) {
        if (this.hasView()) {
            if (this.getEclipseContainerView() == null) {
                if (!Beans.isDesignTime()) {
                    System.out.println("paint method called on eclipse container called " + this.getName() + " without an initialised model");
                } else {
                    this.initialiseModel();
                    this.getEclipseContainerView().paintBeforeChildren(graphics);
                    super.paint(graphics);
                    this.getEclipseContainerView().paintAfterChildren(graphics);
                }
            } else {
                this.getEclipseContainerView().paintBeforeChildren(graphics);
            }
            super.paint(graphics);
            this.getEclipseContainerView().paintAfterChildren(graphics);
        } else {
            super.paint(graphics);
        }
    }

    public void setBackground(Color color) {
        this.myBackgroundColor = color;
        super.setBackground(color);
        if (this.getEclipseContainerView() != null) {
            this.getEclipseContainerView().notifyEclipseContainerChanged();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.myBounds.x = n;
        this.myBounds.y = n2;
        this.myBounds.width = n3;
        this.myBounds.height = n4;
        super.setBounds(n, n2, n3, n4);
        if (EclipseSystem.instance().isOnInstrument()) {
            this.doLayout();
        }
        if (this.getEclipseContainerView() != null) {
            this.getEclipseContainerView().notifyEclipseContainerChanged();
        }
    }

    public final void update(Graphics graphics) {
        if (this.isShowing()) {
            this.paint(graphics);
        }
    }
}

