/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture.containers;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.common.util.SingletonRegistry;
import com.agilent.tntd.eclipse.issdb.client.ThreadScheduler;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseWorkspace;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.FatalErrorDialog;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.MenuPathSelector;
import com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindow;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.awt.Component;
import java.awt.Point;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;

public class WindowManager
implements CcConnectedComponent {
    private static WindowManager singletonInstance = null;
    private Map mapWindowNameToClass = new HashMap();
    private EclipseWorkspace theWorkspace = null;
    private transient ApplicationObject theApplicationObject;
    private final String databaseVariableName = "LOCAL_GUI_FATAL_ERROR";
    private boolean isRecording = false;
    private Map theClassToMenuItemMap = new HashMap(150);

    private WindowManager() {
    }

    public synchronized void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else {
            this.theApplicationObject = applicationObject;
        }
    }

    public synchronized void clearContextSensitiveMenuItems() {
        this.isRecording = true;
        this.theClassToMenuItemMap.clear();
    }

    public synchronized void connectWindow(InternalWindow internalWindow) {
        if (this.theWorkspace == null) {
            EventLog.instance().log("ERROR: WindowManager: connectWindow: Unable to connect window " + internalWindow.toString() + " because the Window Manager has NOT BEEN INITIALIZED!");
        } else {
            internalWindow.connectWithWorkspace(this.theWorkspace);
            this.theWorkspace.selectWindow(internalWindow);
        }
    }

    public synchronized void createModalErrorWindow(Reader reader) {
        Object object;
        Object object2;
        if (this.theWorkspace == null) {
            EventLog.instance().log("ERROR: WindowManager: createModalErrorWindow: The Window Manager has NOT BEEN INITIALIZED!");
        }
        String string = "";
        try {
            object2 = new char[4000];
            reader.read((char[])object2);
            string = new String((char[])object2);
            object = new StringTokenizer(string, "\n");
            string = ((StringTokenizer)object).nextToken();
            reader.reset();
        }
        catch (IOException iOException) {
            EventLog.instance().log("ERROR: WindowManager: createModalErrorWindow: IO exception thrown");
        }
        object2 = new FatalErrorDialog();
        ((FatalErrorDialog)object2).displayExceptionStackTrace(reader);
        ((EclWindow)object2).connectWithWorkspace(this.theWorkspace);
        object = ((Component)object2).getLocation();
        ((Point)object).y = 480 - ((Component)object2).getSize().height;
        ((Component)object2).setLocation((Point)object);
        this.theWorkspace.selectWindow((InternalWindow)object2);
        if (this.theApplicationObject != null) {
            this.theApplicationObject.change(new KnownLengthStringValue(string));
        }
    }

    public synchronized InternalWindow createWindow(String string) {
        InternalWindow internalWindow;
        Class clazz;
        if (this.theWorkspace == null) {
            EventLog.instance().log("ERROR: WindowManager: createWindow: The Window Manager has NOT BEEN INITIALIZED!");
        }
        if ((clazz = (Class)this.mapWindowNameToClass.get((Object)string)) == null) {
            clazz = this.createWindowClassFromName(string);
            this.mapWindowNameToClass.put((Object)string, (Object)clazz);
        }
        if ((internalWindow = this.createWindowFromClass(clazz)) != null) {
            internalWindow.connectWithWorkspace(this.theWorkspace);
            ThreadScheduler.instance().createInitialisationBarrier();
            ApplicationManager.instance().request("ISS", 0, "BEGIN", null);
            internalWindow.finishInitialise();
            ApplicationManager.instance().request("ISS", 0, "END", null);
            ThreadScheduler.instance().goToBarrier();
            this.theWorkspace.selectWindow(internalWindow);
        }
        return internalWindow;
    }

    private Class createWindowClassFromName(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.failToCreateWindow(classNotFoundException);
        }
        return clazz;
    }

    private InternalWindow createWindowFromClass(Class clazz) {
        InternalWindow internalWindow = null;
        try {
            internalWindow = (InternalWindow)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.failToCreateWindow(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.failToCreateWindow(illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            this.failToCreateWindow(classCastException);
        }
        return internalWindow;
    }

    private void failToCreateWindow(Exception exception) {
        System.out.println("Impossible to instanciate this EclWindow because: " + exception.toString());
    }

    public synchronized void finishInitialise() {
        if (EclipseSystem.instance().isOnInstrument()) {
            ApplicationManager.instance().request("ISS", 0, "LOCAL_GUI_FATAL_ERROR", (ApplicationObjectObserver)this);
        }
    }

    public synchronized MenuPathSelector getMenuElement(String string) {
        return (MenuPathSelector)this.theClassToMenuItemMap.get((Object)string);
    }

    public synchronized void initialise(EclipseWorkspace eclipseWorkspace, InternalWindow internalWindow, InternalWindow internalWindow2, InternalWindow internalWindow3) {
        this.theWorkspace = eclipseWorkspace;
        this.mapWindowNameToClass.put((Object)internalWindow.getClass().getName(), internalWindow.getClass());
        this.mapWindowNameToClass.put((Object)internalWindow2.getClass().getName(), internalWindow2.getClass());
        if (internalWindow3 != null) {
            this.mapWindowNameToClass.put((Object)internalWindow3.getClass().getName(), internalWindow3.getClass());
        }
    }

    public static synchronized WindowManager instance() {
        if (singletonInstance == null) {
            singletonInstance = new WindowManager();
            SingletonRegistry.instance().add(singletonInstance);
        }
        return singletonInstance;
    }

    public synchronized void notifyCompletedRecordingContextSensitiveMenuItems() {
        this.isRecording = false;
    }

    private void permanentError() {
    }

    public synchronized void recordMenuItem(String string, MenuPathSelector menuPathSelector) {
        if (this.isRecording && !this.theClassToMenuItemMap.containsKey((Object)string)) {
            this.theClassToMenuItemMap.put((Object)string, (Object)menuPathSelector);
        }
    }

    public synchronized void trapTransientError(boolean bl) {
    }

    public synchronized void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this);
            this.theApplicationObject = null;
        }
    }

    public synchronized void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
        this.permanentError();
    }
}

