/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture.contexthelp;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.contexthelp.ContextHelpIdMap;
import com.agilent.tntd.eclipse.viewlayer.architecture.contexthelp.Encodings;
import com.agilent.tntd.eclipse.viewlayer.architecture.language.LanguageObserver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class ContextHelpLanguageWrapper
implements LanguageObserver {
    private ContextHelpIdMap map = new ContextHelpIdMap();
    private static final String FILENAME_PROPERTY = "eclipse.context_help_filename";
    private static final String[][] suffixes = new String[][]{{"English", "en"}, {"Korean", "ko"}};

    private String getEncoding(String string) {
        int n = 0;
        while (n < Encodings.encodings.length) {
            if (Encodings.encodings[n][0].equalsIgnoreCase(string)) {
                return Encodings.encodings[n][1];
            }
            ++n;
        }
        return null;
    }

    private String getSuffix(String string) {
        int n = 0;
        while (n < suffixes.length) {
            if (suffixes[n][0].equalsIgnoreCase(string)) {
                return suffixes[n][1];
            }
            ++n;
        }
        return null;
    }

    public String mapIdToString(String string) {
        return this.map.mapIdToString(string);
    }

    public void notifyLanguageSelection(String string) {
        if (string == null) {
            this.map.cleanup();
            return;
        }
        File file = EclipseSystem.instance().getFileEclipseDirectory();
        String string2 = System.getProperty(FILENAME_PROPERTY);
        if (file == null || string2 == null) {
            return;
        }
        string2 = String.valueOf(string2) + "." + this.getSuffix(string);
        String string3 = this.getEncoding(string);
        try {
            this.map.initialise(new File(file, string2), string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            EventLog.instance().log("Could not find context-sensitive help definitions file \"" + string2 + "\" in \"" + file.getAbsolutePath() + "\"");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            EventLog.instance().log("The encoding \"" + string3 + "\" is unsupported");
        }
        catch (IOException iOException) {
            EventLog.instance().log("Error reading from context-sensitive help definitions file \"" + string2 + "\" in \"" + file.getAbsolutePath() + "\"");
        }
    }
}

