/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture.event;

import com.agilent.tntd.eclipse.common.util.SingletonRegistry;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.DirectionnalFocusPolicy;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.RootForFocusCycle;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.SelectedWindowHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipseMenu;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipseMenuComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipseMenuElement;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipsePopupMenu;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.awt.Component;
import java.awt.event.FocusEvent;

public class EclipseFocusManager {
    private static EclipseFocusManager theSingletonInstance = null;
    private DirectionnalFocusPolicy theFocusPolicy;
    private SelectedWindowHandler theSelectedWindowHandler;
    private Component focusedComponent;
    private Component windowFocusedComponent;
    private boolean lockFocus;
    private Component focusLockedComponent;

    public boolean attemptFocusAutorisationFor(Component component) {
        boolean bl = false;
        if (this.isFocusLocked()) {
            this.changeLockState(false, null);
        }
        Component component2 = component;
        while (component2 != null && !(component2 instanceof InternalWindow)) {
            component2 = component2.getParent();
        }
        if (component2 != null && this.attemptSelectWindow((InternalWindow)((Object)component2))) {
            bl = true;
        }
        return bl;
    }

    public boolean attemptSelectWindow(InternalWindow internalWindow) {
        boolean bl = false;
        if (!this.isFocusLocked()) {
            bl = this.theSelectedWindowHandler.attemptSelectWindow(internalWindow);
        }
        return bl;
    }

    private synchronized boolean canComponentReceiveFocus(Component component) {
        boolean bl = true;
        if (this.lockFocus && this.focusLockedComponent != component) {
            bl = false;
        } else {
            this.windowFocusedComponent = component;
            this.focusedComponent = component;
        }
        return bl;
    }

    public boolean canRequestFocus(InternalWindow internalWindow) {
        boolean bl = false;
        if (!this.isFocusLocked()) {
            bl = true;
        }
        if (bl) {
            this.setFocusOwner(internalWindow.getContainer(), true);
        }
        return bl;
    }

    public boolean canRequestFocus(EclipseMenuComponent eclipseMenuComponent) {
        if (eclipseMenuComponent instanceof EclipsePopupMenu) {
            this.updatePopupHierarchy((EclipsePopupMenu)eclipseMenuComponent);
        } else if (eclipseMenuComponent instanceof EclipseMenuElement) {
            this.updatePopupHierarchy(((EclipseMenuElement)eclipseMenuComponent).getPopupParent());
        }
        if (EclipseSystem.instance().isOnInstrument() && this.focusedComponent instanceof EclipseMenu) {
            this.focusedComponent.dispatchEvent(new FocusEvent(this.focusedComponent, 1005));
        }
        this.setFocusOwner(eclipseMenuComponent.getEclipseMenuComponent(), false);
        return true;
    }

    public boolean canRequestFocus(Component component) {
        boolean bl = false;
        if (this.isFocusLocked()) {
            bl = this.canComponentReceiveFocus(component);
        } else if (this.theSelectedWindowHandler.getSelectedWindow() != null && (bl = this.theSelectedWindowHandler.getSelectedWindow().getContainer().isAncestorOf(component))) {
            this.setFocusOwner(component, true);
        }
        return bl;
    }

    public synchronized void changeLockState(boolean bl, Component component) {
        this.focusLockedComponent = component;
        this.lockFocus = bl;
    }

    private List createListFrom(EclipsePopupMenu eclipsePopupMenu, List list) {
        if (eclipsePopupMenu != null) {
            if (eclipsePopupMenu.getCreator() != null) {
                list = this.createListFrom(eclipsePopupMenu.getCreator().getPopupParent(), list);
                list.add((Object)eclipsePopupMenu);
            } else {
                if (list == null) {
                    list = new LinkedList();
                }
                list.add((Object)eclipsePopupMenu);
            }
        }
        return list;
    }

    public Component focusAboveComponent(Component component) {
        return this.theFocusPolicy.focusAboveComponent(component);
    }

    public Component focusBelowComponent(Component component) {
        return this.theFocusPolicy.focusBelowComponent(component);
    }

    public Component focusFirstComponent(RootForFocusCycle rootForFocusCycle) {
        return this.theFocusPolicy.focusFirstComponent(rootForFocusCycle);
    }

    public Component focusNextComponent(Component component) {
        return this.theFocusPolicy.focusNextComponent(component);
    }

    public Component focusPreviousComponent(Component component) {
        return this.theFocusPolicy.focusPreviousComponent(component);
    }

    public void focusWhenComponentBecomeUnvisible(Component component) {
        this.theFocusPolicy.focusWhenComponentBecomeUnvisible(component);
    }

    public synchronized Component getFocusedComponent() {
        return this.focusedComponent;
    }

    public static synchronized EclipseFocusManager getInstance() {
        if (theSingletonInstance == null) {
            theSingletonInstance = new EclipseFocusManager();
            SingletonRegistry.instance().add(theSingletonInstance);
            EclipseFocusManager.theSingletonInstance.theFocusPolicy = new DirectionnalFocusPolicy();
        }
        return theSingletonInstance;
    }

    public synchronized Component getWindowFocusedComponent() {
        return this.windowFocusedComponent;
    }

    public void initialise(SelectedWindowHandler selectedWindowHandler) {
        this.theSelectedWindowHandler = selectedWindowHandler;
    }

    private synchronized boolean isFocusLocked() {
        return this.lockFocus;
    }

    public synchronized boolean isFocusLocked(Component component) {
        return this.focusLockedComponent == component && this.lockFocus;
    }

    private synchronized void setFocusOwner(Component component, boolean bl) {
        List list;
        this.changeLockState(false, null);
        if (bl) {
            this.windowFocusedComponent = component;
        }
        if (this.focusedComponent instanceof EclipseMenuComponent && !(component instanceof EclipseMenuComponent) && !(list = this.validatePopupCreation()).isEmpty()) {
            Object[] objectArray = new EclipsePopupMenu[list.size()];
            list.toArray(objectArray);
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n].getEclipseMenuComponent().setVisible(false);
                ++n;
            }
        }
        this.focusedComponent = component;
    }

    private void updatePopupHierarchy(EclipsePopupMenu eclipsePopupMenu) {
        List list = this.validatePopupCreation();
        if (list != null) {
            List list2 = this.createListFrom(eclipsePopupMenu, null);
            list.removeAll((Collection)list2);
            if (!list.isEmpty()) {
                Object[] objectArray = new EclipsePopupMenu[list.size()];
                list.toArray(objectArray);
                int n = 0;
                while (n < objectArray.length) {
                    objectArray[n].getEclipseMenuComponent().setVisible(false);
                    ++n;
                }
            }
        }
    }

    private List validatePopupCreation() {
        List list = null;
        Component component = this.getFocusedComponent();
        if (component instanceof EclipseMenuComponent) {
            if (component instanceof EclipsePopupMenu) {
                list = this.createListFrom((EclipsePopupMenu)((Object)component), null);
            } else {
                EclipsePopupMenu eclipsePopupMenu = component instanceof EclipseMenu ? ((EclipseMenu)((Object)component)).getChildPopupMenu() : ((EclipseMenuElement)((Object)component)).getPopupParent();
                list = this.createListFrom(eclipsePopupMenu, null);
            }
        }
        return list;
    }
}

