/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture.language;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.language.LanguageObserver;
import java.util.Enumeration;
import java.util.Vector;

public class LanguageManager
implements CcConnectedComponent,
MaskedIntegerDataReceiver {
    private String currentLanguage = null;
    private int currentIndex = -1;
    private Vector observers = new Vector();
    private ApplicationObject ao = null;
    private static final String languageVariable = "LANGUAGE";
    private static final String[] languages = new String[]{"English", "Korean"};

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        switch (errorReporter.getErrorStatus()) {
            case 1: {
                EventLog.instance().log("LANGUAGE failed to initialise.");
                break;
            }
            case 3: {
                EventLog.instance().log("LANGUAGE requested from unknown domain.");
                break;
            }
            default: {
                this.ao = applicationObject;
            }
        }
    }

    public void addObserver(LanguageObserver languageObserver) {
        if (this.currentLanguage != null) {
            languageObserver.notifyLanguageSelection(this.currentLanguage);
        }
        this.observers.addElement(languageObserver);
    }

    public void finishInitialise() {
        ApplicationManager.instance().request("LOCAL", 0, languageVariable, (ApplicationObjectObserver)this);
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        int n = maskedIntegerValue.getValue();
        if (n != this.currentIndex && n >= 0 && n < languages.length) {
            this.currentIndex = n;
            this.currentLanguage = languages[n];
            EventLog.instance().log("Switching to " + this.currentLanguage + " language support");
            this.updateAllObservers();
        }
    }

    public void removeObserver(LanguageObserver languageObserver) {
        this.observers.removeElement(languageObserver);
    }

    public void trapTransientError(boolean bl) {
    }

    public void unregister() {
        if (this.ao != null) {
            this.ao.unregister(this);
        }
        this.ao = null;
        this.currentIndex = -1;
        this.currentLanguage = null;
        this.updateAllObservers();
        this.observers.removeAllElements();
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        if (applicationData == null) {
            return;
        }
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log("Received incorrect type from LANGUAGE");
        }
    }

    private void updateAllObservers() {
        Enumeration enumeration = this.observers.elements();
        while (enumeration.hasMoreElements()) {
            ((LanguageObserver)enumeration.nextElement()).notifyLanguageSelection(this.currentLanguage);
        }
    }
}

