/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture.layoutmanagers;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public class ColumnLayout
implements LayoutManager2 {
    private int gap;
    private boolean squishable = true;

    public ColumnLayout() {
        this(3);
    }

    public ColumnLayout(int n) {
        this.setGap(n);
    }

    public void addLayoutComponent(Component component, Object object) {
        this.addLayoutComponent("", component);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public int getGap() {
        return this.gap;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public boolean isSquishable() {
        return this.squishable;
    }

    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = insets.top;
            int n2 = insets.left;
            int n3 = container.getSize().width - (insets.left + insets.right);
            Component[] componentArray = container.getComponents();
            if (componentArray != null && componentArray.length > 0) {
                int n4 = 0;
                while (n4 < componentArray.length) {
                    componentArray[n4].setBounds(n2, n += this.gap, n3, componentArray[n4].getPreferredSize().height);
                    n += componentArray[n4].getSize().height;
                    ++n4;
                }
            }
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component[] componentArray;
            Dimension dimension = new Dimension(0, 0);
            if (!this.isSquishable() && (componentArray = container.getComponents()) != null && componentArray.length > 0) {
                int n = 0;
                while (n < componentArray.length) {
                    if (dimension.width < componentArray[n].getMinimumSize().width) {
                        dimension.width = componentArray[n].getMinimumSize().width;
                    }
                    dimension.height += componentArray[n].getMinimumSize().height;
                    ++n;
                }
                Insets insets = container.getInsets();
                dimension.width += insets.left + insets.right;
                dimension.height += insets.top + insets.bottom;
            }
            return dimension;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            Component[] componentArray = container.getComponents();
            if (componentArray != null && componentArray.length > 0) {
                int n = 0;
                while (n < componentArray.length) {
                    if (dimension.width < componentArray[n].getPreferredSize().width) {
                        dimension.width = componentArray[n].getPreferredSize().width;
                    }
                    dimension.height += componentArray[n].getPreferredSize().height;
                    ++n;
                }
                Insets insets = container.getInsets();
                dimension.width += insets.left + insets.right;
                dimension.height += insets.top + insets.bottom;
            }
            return dimension;
        }
    }

    public void removeLayoutComponent(Component component) {
    }

    public void setGap(int n) {
        this.gap = n;
    }

    public void setSquishable(boolean bl) {
        this.squishable = bl;
    }
}

