/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture.menus;

import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipseMenuComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipsePopupMenu;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipsePopupMenuParent;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.GenericMouseHelper;
import com.sun.java.util.collections.HashSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseEvent;

class PopupContainer
extends Container
implements EclipsePopupMenuParent {
    private HashSet thePopups = new HashSet();

    public PopupContainer(Container container) {
        if (container == null) {
            throw new NullPointerException("PopupContainer initialisation failed because cannot be created twice or without a parent");
        }
        Dimension dimension = container.getSize();
        this.setBounds(0, 0, 600, Math.min(480, dimension.height));
        this.enableEvents(16L);
        this.setVisible(false);
        container.add(this);
    }

    public EclipsePopupMenuParent addEclipsePopupMenu(EclipsePopupMenu eclipsePopupMenu) {
        this.add((Component)eclipsePopupMenu.getContainer(), 0);
        if (eclipsePopupMenu.getEclipseMenuComponent().isVisible()) {
            this.thePopups.add((Object)eclipsePopupMenu);
        }
        return this;
    }

    public void notifyPopupVisibilityChanged(boolean bl, EclipsePopupMenu eclipsePopupMenu) {
        if (bl) {
            this.thePopups.add((Object)eclipsePopupMenu);
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            this.getParent().add((Component)this, 0);
        } else {
            this.remove(eclipsePopupMenu.getContainer());
            this.thePopups.remove((Object)eclipsePopupMenu);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.thePopups.isEmpty()) {
            if (this.isVisible()) {
                this.setVisible(false);
            }
        } else {
            switch (mouseEvent.getID()) {
                case 504: {
                    if (!EclipseSystem.instance().isPersonnalJavaPlatform() || !GenericMouseHelper.isLeftMouseButton(mouseEvent) || mouseEvent.getClickCount() == 0) break;
                    this.removeAllPopups();
                    break;
                }
                case 500: {
                    if (!GenericMouseHelper.isLeftMouseButton(mouseEvent)) break;
                    this.removeAllPopups();
                }
            }
        }
    }

    private void removeAllPopups() {
        Component component = null;
        Object[] objectArray = this.thePopups.toArray();
        int n = 0;
        while (n < objectArray.length) {
            EclipsePopupMenu eclipsePopupMenu = (EclipsePopupMenu)objectArray[n];
            if (!(eclipsePopupMenu.getComponentFocusableOnClose() instanceof EclipseMenuComponent)) {
                component = eclipsePopupMenu.getComponentFocusableOnClose();
            }
            eclipsePopupMenu.getEclipseMenuComponent().setVisible(false);
            ++n;
        }
        if (component != null) {
            component.requestFocus();
            this.setVisible(false);
        } else if (objectArray.length != 0) {
            StringBuffer stringBuffer = new StringBuffer("Array[ ");
            int n2 = 0;
            while (n2 < objectArray.length) {
                stringBuffer.append(objectArray[n2].toString());
                if (n2 < objectArray.length) {
                    stringBuffer.append(", ");
                }
                ++n2;
            }
            stringBuffer.append("]");
            EclipseSystem.instance().exitWithError("Cannot remove popup(s) = " + stringBuffer.toString() + " without a component focusable on close.");
        }
    }
}

