/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture.mouse;

import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.BooleanState;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.GenericMouseHelper;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseButton;
import java.awt.event.MouseEvent;

public class MouseButtonHandler {
    private void doPressedAction(MouseEvent mouseEvent, BooleanState booleanState, MouseButton mouseButton) {
        if (GenericMouseHelper.isLeftMouseButton(mouseEvent)) {
            if (mouseButton.isLocked()) {
                EclipseSystem.instance().beep();
            } else {
                booleanState.setValue(true);
                mouseButton.setSunken(!mouseButton.isSunken());
            }
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent, MouseButton mouseButton, BooleanState booleanState, boolean bl, boolean bl2) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        mouseEvent.consume();
        if (bl) {
            switch (mouseEvent.getID()) {
                case 501: {
                    this.doPressedAction(mouseEvent, booleanState, mouseButton);
                    break;
                }
                case 502: {
                    if (!GenericMouseHelper.isLeftMouseButton(mouseEvent) || !booleanState.isTrue() || !GenericMouseHelper.isLeftMouseButton(mouseEvent)) break;
                    mouseButton.doLeftClickAction();
                    booleanState.setValue(false);
                    break;
                }
                case 505: {
                    if (booleanState.isTrue()) {
                        mouseButton.setSunken(!mouseButton.isSunken());
                    }
                    booleanState.setValue(false);
                    break;
                }
                case 500: {
                    if (!GenericMouseHelper.isRightMouseButton(mouseEvent)) break;
                    mouseButton.doRightClickAction();
                }
            }
            mouseButton.repaint();
        } else if (bl2) {
            switch (mouseEvent.getID()) {
                case 501: {
                    if (!GenericMouseHelper.isLeftMouseButton(mouseEvent)) break;
                    if (EclipseFocusManager.getInstance().canRequestFocus(mouseEvent.getComponent())) {
                        mouseButton.requestFocus();
                        this.doPressedAction(mouseEvent, booleanState, mouseButton);
                        mouseButton.repaint();
                        break;
                    }
                    if (!EclipseFocusManager.getInstance().attemptFocusAutorisationFor(mouseEvent.getComponent())) break;
                    mouseButton.requestFocus();
                    break;
                }
                case 504: {
                    mouseButton.requestFocus();
                }
            }
        }
    }
}

