/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture.statusline;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.common.util.SingletonRegistry;
import com.agilent.tntd.eclipse.issdb.client.GenericIssDataAccessor;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.SimpleTypesWriter;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseWorkspace;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.StatusLineDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.statusline.IconLabel;
import com.agilent.tntd.eclipse.viewlayer.architecture.statusline.StatusLineIcon;
import com.agilent.tntd.eclipse.viewlayer.architecture.statusline.StatusMessageWindow;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabel;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabelModel;
import com.agilent.tntd.eclipse.viewlayer.components.line.EclLine;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage;
import java.awt.Container;
import java.io.IOException;

public class StatusLineApplication
implements CcConnectedComponent,
ApplicationGenericDataReceiver,
MaskedIntegerDataReceiver {
    private static StatusLineApplication theSingletonInstance = null;
    private final String statusLineVariableName = "STATUS_LINE";
    private ApplicationObject theApplicationObject = null;
    private transient boolean hasTrappedTransientError = false;
    private Container myDisplay = null;
    private EclLabel labelForMessage = new EclLabel();
    private EclPanePage panePageForIcons = new EclPanePage();
    private final int SEVERITY_NO_MESSAGE = 0;
    private final int SEVERITY_BENIGN = 1;
    private final int SEVERITY_SERIOUS = 2;
    private final int SEVERITY_MAJOR = 3;
    private StatusLineIcon[] theIcons = new StatusLineIcon[0];
    private EclLabel theDataEntryIcon;
    private EclipseWorkspace theWorkspace;
    private String theMultiInstrumentVariableName;
    private ApplicationObject theMultiInstrumentAO;
    private MaskedIntegerValue theSelectedInstrumentValue;

    private StatusLineApplication() {
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else if (applicationObject.getName().equals(this.theMultiInstrumentVariableName)) {
            this.theMultiInstrumentAO = applicationObject;
        } else {
            this.theApplicationObject = applicationObject;
            if (this.theMultiInstrumentAO != null && this.theMultiInstrumentAO.getInitialisationState() == 2) {
                this.theApplicationObject.asyncQuery(null, this);
            }
        }
    }

    public void displayMessage(String string) {
        this.updateStatusLineMessage((byte)1, string);
    }

    public void finishInitialise() {
        if (this.myDisplay != null) {
            this.trapTransientError(true);
            ApplicationManager.instance().request("ISS", 0, "STATUS_LINE", (ApplicationObjectObserver)this);
            if (this.theMultiInstrumentVariableName != null) {
                ApplicationManager.instance().request("LOCAL", 0, this.theMultiInstrumentVariableName, (ApplicationObjectObserver)this);
            } else {
                this.theSelectedInstrumentValue = new MaskedIntegerValue(-1);
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't have a display area registered.");
        }
    }

    public static synchronized StatusLineApplication getInstance() {
        if (theSingletonInstance == null) {
            theSingletonInstance = new StatusLineApplication();
            SingletonRegistry.instance().add(theSingletonInstance);
        }
        return theSingletonInstance;
    }

    public void initialiseMultiInstrument(String string) {
        this.theMultiInstrumentVariableName = string;
    }

    public void notifyEvent(int n, StatusMessageWindow statusMessageWindow) {
        if (this.theWorkspace.removeWindow(statusMessageWindow, true) && (2 == n || 1 == n)) {
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesWriter.initialiseByteArrayToWrite();
            try {
                simpleTypesWriter.write(statusMessageWindow.getDialogID());
                if (2 == n) {
                    simpleTypesWriter.write((byte)1);
                } else if (1 == n) {
                    simpleTypesWriter.write((byte)0);
                }
                this.theApplicationObject.change(new ApplicationGenericData(simpleTypesWriter.getWrittenBytes()));
            }
            catch (IOException iOException) {
                EventLog.instance().log("Could not write the answer for Dialog" + statusMessageWindow.toString());
            }
        }
    }

    private void permanentError() {
        this.myDisplay.setBackground(StatusLineDefaults.permanentErrorColour);
        this.hasTrappedTransientError = false;
        this.myDisplay.removeAll();
        this.unregister();
    }

    private void populateStatusLine(byte by, String string, byte[] byArray) {
        this.updateStatusLineMessage(by, string);
        int n = 0;
        while (n < byArray.length) {
            this.theIcons[byArray[n]].setActivated(true);
            ++n;
        }
        this.panePageForIcons.repaint();
    }

    private void readMessage(PrimitiveTypesReader primitiveTypesReader) throws IOException {
        byte by;
        byte by2 = primitiveTypesReader.readByte();
        byte by3 = primitiveTypesReader.readByte();
        boolean bl = false;
        if ((by2 == 0 || by2 == GenericIssDataAccessor.getClientID()) && (by3 == -1 || this.theSelectedInstrumentValue != null && by3 == this.theSelectedInstrumentValue.getValue())) {
            bl = true;
        }
        if ((by = primitiveTypesReader.readByte()) < 16) {
            String string = by != 0 ? primitiveTypesReader.readString() : null;
            byte[] byArray = new byte[primitiveTypesReader.readByte()];
            int n = 0;
            while (n < byArray.length) {
                byArray[n] = primitiveTypesReader.readByte();
                ++n;
            }
            if (bl) {
                this.populateStatusLine(by, string, byArray);
            }
        } else {
            byte by4 = primitiveTypesReader.readByte();
            String string = primitiveTypesReader.readString();
            String string2 = primitiveTypesReader.readString();
            if (bl) {
                StatusMessageWindow statusMessageWindow = new StatusMessageWindow();
                statusMessageWindow.setDialogID(by4);
                statusMessageWindow.setSize(300, 200);
                if (by == 16 && bl) {
                    statusMessageWindow.displayMessageWindow(false, true, false, string2, string, statusMessageWindow, null);
                } else if (by == 17 && bl) {
                    statusMessageWindow.displayMessageWindow(true, false, true, string2, string, statusMessageWindow, null);
                }
            }
        }
    }

    public void receiveApplicationGenericData(ApplicationGenericData applicationGenericData, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theApplicationObject) {
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            try {
                int n = primitiveTypesReader.readByte();
                int n2 = 0;
                while (n2 < n) {
                    this.readMessage(primitiveTypesReader);
                    ++n2;
                }
                this.trapTransientError(false);
            }
            catch (IOException iOException) {
                this.trapTransientError(true);
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        if (this.theMultiInstrumentAO == applicationDataSender) {
            if (this.theSelectedInstrumentValue == null || maskedIntegerValue.getValue() != this.theSelectedInstrumentValue.getValue()) {
                this.theSelectedInstrumentValue = maskedIntegerValue;
                this.updateStatusLineMessage((byte)0, null);
                if (this.theApplicationObject != null && this.theApplicationObject.getInitialisationState() == 2) {
                    this.theApplicationObject.asyncQuery(null, this);
                }
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void registerDisplayArea(Container container, EclipseWorkspace eclipseWorkspace) {
        this.theWorkspace = eclipseWorkspace;
        this.myDisplay = container;
        int n = container.getSize().height;
        int n2 = container.getSize().width - 100;
        this.labelForMessage.setBounds(1, 1, n2 - 3, n);
        this.labelForMessage.setFont(StatusLineDefaults.font);
        this.myDisplay.add(this.labelForMessage);
        EclLine eclLine = new EclLine();
        eclLine.setOrientation(1);
        eclLine.setStyle(2);
        eclLine.setThickness(2);
        eclLine.setBounds(n2 - 2, 1, 2, n);
        this.myDisplay.add(eclLine);
        this.panePageForIcons.setBounds(n2, 1, 100, n);
        this.panePageForIcons.setLayout(null);
        this.myDisplay.add(this.panePageForIcons);
        this.theIcons = new StatusLineIcon[1];
        IconLabel iconLabel = new IconLabel("Laser-ON", "Laser-OFF");
        iconLabel.setBounds(3, 0, 65, n);
        this.panePageForIcons.add(iconLabel);
        this.theIcons[0] = iconLabel;
        this.theDataEntryIcon = new EclLabel();
        this.setDataEntryMode("");
        this.theDataEntryIcon.setBounds(68, 0, 31, n);
        this.panePageForIcons.add(this.theDataEntryIcon);
    }

    public void setDataEntryMode(String string) {
        if (string == null || string.length() == 0) {
            this.theDataEntryIcon.setVisible(false);
        } else {
            this.theDataEntryIcon.setVisible(true);
            this.theDataEntryIcon.setEclModel(new EclLabelModel(null, null, new String[][]{{string}}));
            this.theDataEntryIcon.repaint();
        }
    }

    public String toString() {
        return "Status Line[STATUS_LINE]";
    }

    public void trapTransientError(boolean bl) {
        if (this.hasTrappedTransientError != bl) {
            this.hasTrappedTransientError = bl;
            if (bl) {
                this.labelForMessage.setEclModel(new EclLabelModel(null, null, new String[][]{{" Instrument failed to communicate properly to GUI."}}));
                this.labelForMessage.setBackground(StatusLineDefaults.background);
                this.labelForMessage.setForeground(StatusLineDefaults.transientErrorColour);
                this.panePageForIcons.setBackground(StatusLineDefaults.transientErrorColour);
                this.panePageForIcons.setVisible(false);
                this.labelForMessage.repaint();
                this.panePageForIcons.repaint();
            }
        }
    }

    public void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this);
            this.theApplicationObject = null;
        }
        if (this.theMultiInstrumentAO != null) {
            this.theMultiInstrumentAO.unregister(this);
            this.theMultiInstrumentAO = null;
        }
        this.theSelectedInstrumentValue = null;
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
            this.permanentError();
        }
    }

    private void updateStatusLineMessage(byte by, String string) {
        int n = 0;
        while (n < this.theIcons.length) {
            this.theIcons[n].setActivated(false);
            ++n;
        }
        if (!this.panePageForIcons.isVisible()) {
            this.panePageForIcons.setBackground(StatusLineDefaults.background);
            this.panePageForIcons.setVisible(true);
        }
        this.labelForMessage.setForeground(StatusLineDefaults.foreground);
        switch (by) {
            case 0: {
                this.labelForMessage.setEclModel(new EclLabelModel(null, null, new String[][]{{" Status: "}}));
                this.labelForMessage.setBackground(StatusLineDefaults.background);
                break;
            }
            case 1: {
                this.labelForMessage.setEclModel(new EclLabelModel(null, null, new String[][]{{" Status: " + string}}));
                this.labelForMessage.setBackground(StatusLineDefaults.benignErrorColor);
                break;
            }
            case 2: {
                this.labelForMessage.setEclModel(new EclLabelModel(null, null, new String[][]{{" Status: " + string}}));
                this.labelForMessage.setBackground(StatusLineDefaults.seriousErrorColor);
                break;
            }
            case 3: {
                this.labelForMessage.setEclModel(new EclLabelModel(null, null, new String[][]{{" Status: " + string}}));
                this.labelForMessage.setBackground(StatusLineDefaults.majorErrorColor);
                break;
            }
            default: {
                this.labelForMessage.setEclModel(new EclLabelModel(null, null, new String[][]{{" Instrument sent an unknown severity value."}}));
                this.labelForMessage.setBackground(StatusLineDefaults.background);
                this.labelForMessage.setForeground(StatusLineDefaults.transientErrorColour);
                this.panePageForIcons.setBackground(StatusLineDefaults.transientErrorColour);
            }
        }
        this.labelForMessage.repaint();
    }
}

