/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.architecture.text;

import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclLabelDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabelModel;
import com.agilent.tntd.eclipse.viewlayer.components.table.TableColumnLabel;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;

public class TextHelper {
    private static int getNextLineOffset(char[] cArray, int n, int n2, int n3, FontMetrics fontMetrics) {
        while (true) {
            if (n2 != cArray.length && !Character.isSpace(cArray[n2])) {
                ++n2;
                continue;
            }
            if (n2 == cArray.length || fontMetrics.charsWidth(cArray, n, n2 - n) > n3 - 100) break;
            if (cArray[n2] == '\n') {
                return n2;
            }
            ++n2;
        }
        if (n2 != cArray.length) {
            int n4 = n2 + 1;
            while (true) {
                if (n4 != cArray.length && !Character.isSpace(cArray[n4])) {
                    ++n4;
                    continue;
                }
                if (n4 == cArray.length) {
                    if (fontMetrics.charsWidth(cArray, n, n4 - n) >= n3) break;
                    n2 = n4;
                    break;
                }
                if (fontMetrics.charsWidth(cArray, n, n4 - n) > n3 - 100) break;
                if (cArray[n4] == '\n') {
                    return n4;
                }
                n2 = ++n4;
            }
        }
        return n2;
    }

    private static boolean hasNewLine(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            if (cArray[n3] == '\n') {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private static EclPanePage initialiseOuterPane(EclPanePage eclPanePage) {
        eclPanePage.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        EclPanePage eclPanePage2 = new EclPanePage();
        eclPanePage2.setLayout(new GridLayout(0, 1, 0, 5));
        eclPanePage.add((Component)eclPanePage2, gridBagConstraints);
        return eclPanePage2;
    }

    public static void populateWithText(EclPanePage eclPanePage, String string, int n, Font font) {
        if (eclPanePage.getParent() == null || eclPanePage.isVisible()) {
            throw new RuntimeException("TextHelper.populateWithText(...) require a non visible container with a parent.");
        }
        EclPanePage eclPanePage2 = TextHelper.initialiseOuterPane(eclPanePage);
        TableColumnLabel tableColumnLabel = null;
        if (font == null) {
            font = EclLabelDefaults.font;
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(EclLabelDefaults.font);
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = cArray.length;
        while (fontMetrics.charsWidth(cArray, n2, n3) > n - 20 || TextHelper.hasNewLine(cArray, n2, n3)) {
            int n4 = n2 + 1;
            n4 = TextHelper.getNextLineOffset(cArray, n2, n4, n - 40, fontMetrics);
            tableColumnLabel = new TableColumnLabel();
            String string2 = new String(cArray, n2, n4 - n2);
            tableColumnLabel.setFont(font);
            tableColumnLabel.setEclModel(new EclLabelModel(null, null, new String[][]{{string2}}, -1));
            eclPanePage2.add(tableColumnLabel);
            if (n4 == cArray.length) break;
            if (cArray[n4] == '\n') {
                // empty if block
            }
            n2 = ++n4;
            n3 = cArray.length - n2;
        }
        if (n2 != cArray.length) {
            tableColumnLabel = new TableColumnLabel();
            tableColumnLabel.setFont(font);
            tableColumnLabel.setEclModel(new EclLabelModel(null, null, new String[][]{{new String(cArray, n2, cArray.length - n2)}}, -1));
            eclPanePage2.add(tableColumnLabel);
        }
        eclPanePage.validate();
    }
}

