/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.basiccomponents;

import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.GenericMouseHelper;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.BasicLabel;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class BasicCheckbox
extends BasicLabel {
    private boolean checked = false;
    private int textLocation = -1;
    private int textGap = 5;
    private int edgeGap = 4;
    private transient Point iconLocation = new Point();
    private transient boolean hasFocus = false;
    private transient boolean armed = false;
    public static final int TEXT_TO_RIGHT = 0;
    public static final int TEXT_TO_LEFT = 1;
    private static final int ICON_WIDTH = 13;
    private static final int EDGE_GAP = 4;
    private static final int TEXT_GAP = 5;
    private UnconsumedKeyHandler mainKeyController = null;
    private ActionListener actionListener = null;

    public BasicCheckbox() {
        this("");
    }

    public BasicCheckbox(String string) {
        super(string);
        this.setHorizontalAlignment(0);
        this.setTextLocation(0);
        this.enableEvents(28L);
        this.positionIcon();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    private void fireActionPerformedEvent() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, "action"));
        }
    }

    public int getEdgeGap() {
        return this.edgeGap;
    }

    private UnconsumedKeyHandler getMainKeyController() {
        Container container;
        if (this.mainKeyController == null && (container = this.getParent()) != null) {
            while (container.getParent() != null) {
                container = container.getParent();
            }
            if (container instanceof UnconsumedKeyHandler) {
                this.mainKeyController = (UnconsumedKeyHandler)((Object)container);
            }
        }
        return this.mainKeyController;
    }

    public int getTextGap() {
        return this.textGap;
    }

    public int getTextLocation() {
        return this.textLocation;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public boolean isFocusTraversable() {
        return this.isEnabled();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintIcon(graphics);
        if (this.hasFocus) {
            graphics.setColor(Color.red);
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }
    }

    private void paint3DHighlights(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        graphics.setColor(bl ? Color.white : Color.gray);
        graphics.drawLine(n, n2, n5, n2);
        graphics.drawLine(n, n2, n, n6);
        graphics.setColor(bl ? Color.lightGray : Color.black);
        graphics.drawLine(n + 1, n2 + 1, n5 - 1, n2 + 1);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n6 - 1);
        graphics.setColor(bl ? Color.gray : Color.white);
        graphics.drawLine(n, n6, n5, n6);
        graphics.drawLine(n5, n2, n5, n6);
        graphics.setColor(bl ? Color.black : Color.lightGray);
        graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, n2 + 1);
        graphics.drawLine(n + 1, n6 - 1, n5 - 1, n6 - 1);
    }

    protected void paintIcon(Graphics graphics) {
        graphics.setColor(this.isEnabled() && !this.armed ? Color.white : Color.lightGray);
        graphics.fillRect(this.iconLocation.x, this.iconLocation.y, 13, 13);
        this.paint3DHighlights(graphics, this.iconLocation.x, this.iconLocation.y, 13, 13, false);
        if (this.isChecked()) {
            graphics.translate(this.iconLocation.x, this.iconLocation.y);
            graphics.setColor(this.isEnabled() ? this.getForeground() : Color.gray);
            graphics.drawLine(3, 5, 5, 7);
            graphics.drawLine(3, 6, 5, 8);
            graphics.drawLine(3, 7, 5, 9);
            graphics.drawLine(5, 7, 9, 3);
            graphics.drawLine(5, 8, 9, 4);
            graphics.drawLine(5, 9, 9, 5);
            graphics.translate(-this.iconLocation.x, -this.iconLocation.y);
        }
    }

    private void positionIcon() {
        Rectangle rectangle = this.getTextExtents();
        if (rectangle != null && this.iconLocation != null) {
            this.iconLocation.y = (rectangle.height - 13) / 2 + rectangle.y;
            this.iconLocation.x = this.textLocation == 0 ? this.edgeGap : this.getSize().width - 13 - this.edgeGap - 1;
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        this.hasFocus = focusEvent.getID() == 1004;
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                case 10: {
                    this.checked = !this.checked;
                    this.fireActionPerformedEvent();
                    this.repaint();
                    keyEvent.consume();
                    break;
                }
                case 0: {
                    keyEvent.consume();
                    break;
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            this.getMainKeyController().processUnconsumedKeyEvents(keyEvent, this);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            switch (mouseEvent.getID()) {
                case 504: {
                    this.requestFocus();
                    mouseEvent.consume();
                    break;
                }
                case 505: {
                    if (this.armed) {
                        this.armed = false;
                        this.repaint();
                    }
                    mouseEvent.consume();
                    break;
                }
                case 501: {
                    if (GenericMouseHelper.isRightMouseButton(mouseEvent)) {
                        this.getMainKeyController().processUnconsumedKeyEvents(InstrumentKeyMappings.getMenuKeyEvent(this), this);
                    } else {
                        this.armed = true;
                        this.repaint();
                    }
                    mouseEvent.consume();
                    break;
                }
                case 502: {
                    if (this.armed) {
                        this.checked = !this.checked;
                        this.fireActionPerformedEvent();
                        this.repaint();
                        this.armed = false;
                    }
                    mouseEvent.consume();
                    break;
                }
            }
            super.processMouseEvent(mouseEvent);
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.positionIcon();
    }

    public void setChecked(boolean bl) {
        this.checked = bl;
        this.repaint();
    }

    public void setEdgeGap(int n) {
        this.edgeGap = n;
        this.setTextLocation(this.textLocation);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.positionIcon();
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.positionIcon();
    }

    public void setTextGap(int n) {
        this.textGap = n;
        this.setTextLocation(this.textLocation);
    }

    public void setTextLocation(int n) {
        switch (n) {
            case 0: {
                this.setTextInsets(new Insets(0, 13 + this.textGap + this.edgeGap, 0, this.edgeGap));
                break;
            }
            case 1: {
                this.setTextInsets(new Insets(0, this.edgeGap, 0, 13 + this.textGap + this.edgeGap));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown textLocation passed to BasicCheckbox");
            }
        }
        this.textLocation = n;
        this.positionIcon();
    }

    public void setVerticalAlignment(int n) {
        super.setVerticalAlignment(n);
        this.positionIcon();
    }
}

