/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.basiccomponents;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class BasicLabel
extends Component {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_MIDDLE = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_BOTTOM = 2;
    private String text = "";
    private boolean underlined = false;
    private Insets textInsets = new Insets(0, 0, 0, 0);
    private int hAlignment = 1;
    private int vAlignment = 1;
    private boolean textWidthRestricted = true;
    private transient String displayedText = "";
    private transient Point textOrigin = new Point();
    private transient Rectangle textExtents = new Rectangle();
    private transient Rectangle preferredTextExtents = new Rectangle();
    static final long serialVersionUID = 7107323374189099205L;

    public BasicLabel() {
        this("");
    }

    public BasicLabel(String string) {
        this.setFont(new Font("dialog", 0, 12));
        this.setBackground(null);
        this.setForeground(Color.black);
        this.setSize(40, 20);
        this.setText(string);
    }

    public int getHorizontalAlignment() {
        return this.hAlignment;
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.preferredTextExtents.width + this.textInsets.left + this.textInsets.right, this.preferredTextExtents.height + this.textInsets.top + this.textInsets.bottom);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public String getText() {
        return this.text;
    }

    protected Color getTextColor() {
        return this.isEnabled() ? this.getForeground() : Color.gray;
    }

    protected Rectangle getTextExtents() {
        return this.textExtents;
    }

    public Insets getTextInsets() {
        return this.textInsets;
    }

    public int getVerticalAlignment() {
        return this.vAlignment;
    }

    public boolean isTextWidthRestricted() {
        return this.textWidthRestricted;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        this.paintText(graphics);
    }

    protected void paintBackground(Graphics graphics) {
        if (this.getBackground() != null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
    }

    protected void paintText(Graphics graphics) {
        graphics.setFont(this.getFont());
        graphics.setColor(this.getTextColor());
        graphics.drawString(this.displayedText, this.textOrigin.x, this.textOrigin.y);
        if (this.underlined && this.textExtents.width > 0) {
            graphics.drawLine(this.textOrigin.x, this.textOrigin.y + 1, this.textOrigin.x + this.textExtents.width - 1, this.textOrigin.y + 1);
        }
    }

    protected void positionText() {
        if (this.getFont() == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = n - this.textInsets.left - this.textInsets.right;
        int n4 = n2 - this.textInsets.top - this.textInsets.bottom;
        this.displayedText = this.textWidthRestricted ? this.truncateToWidth(this.text, n3) : this.text;
        this.textExtents.height = fontMetrics.getAscent() + fontMetrics.getDescent();
        this.textExtents.width = fontMetrics.stringWidth(this.displayedText);
        this.preferredTextExtents.height = fontMetrics.getAscent() + fontMetrics.getDescent();
        this.preferredTextExtents.width = fontMetrics.stringWidth(this.text);
        switch (this.hAlignment) {
            case 0: {
                this.textExtents.x = this.textInsets.left;
                break;
            }
            case 1: {
                this.textExtents.x = (n3 - this.textExtents.width) / 2 + this.textInsets.left;
                break;
            }
            case 2: {
                this.textExtents.x = n - this.textExtents.width - this.textInsets.right;
                break;
            }
        }
        switch (this.vAlignment) {
            case 0: {
                this.textExtents.y = this.textInsets.top;
                break;
            }
            case 1: {
                this.textExtents.y = (n4 - this.textExtents.height) / 2 + this.textInsets.top;
                break;
            }
            case 2: {
                this.textExtents.y = n2 - this.textExtents.height - this.textInsets.bottom;
                break;
            }
        }
        this.textOrigin.x = this.textExtents.x;
        this.textOrigin.y = this.textExtents.y + fontMetrics.getAscent();
    }

    public void restrictTextWidth(boolean bl) {
        this.textWidthRestricted = bl;
        this.positionText();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.positionText();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.positionText();
    }

    public void setHorizontalAlignment(int n) {
        this.hAlignment = n;
        this.positionText();
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.positionText();
    }

    public void setText(String string) {
        this.text = string;
        this.positionText();
        this.repaint();
    }

    public void setTextInsets(Insets insets) {
        this.textInsets = insets;
        this.positionText();
    }

    public void setUnderlined(boolean bl) {
        this.underlined = bl;
        this.repaint();
    }

    public void setVerticalAlignment(int n) {
        this.vAlignment = n;
        this.positionText();
    }

    protected String truncateToWidth(String string, int n) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics.stringWidth(string) > n) {
            String string2 = string;
            n -= fontMetrics.stringWidth("...");
            while (fontMetrics.stringWidth(string2) > n && string2.length() > 1) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            if (fontMetrics.stringWidth(string2) > n) {
                string2 = "";
            }
            return String.valueOf(string2) + "...";
        }
        return string;
    }
}

