/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.basiccomponents;

import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.GenericMouseHelper;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.BasicLabel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class Tile
extends BasicLabel {
    private transient boolean hasFocus = false;
    private transient UnconsumedKeyHandler unconsumedKeyHandler = null;
    static final long serialVersionUID = 558243922132430098L;

    public Tile() {
        this("", false);
    }

    public Tile(String string) {
        this(string, false);
    }

    public Tile(String string, boolean bl) {
        super(string);
        this.setSize(70, 20);
        this.setBackground(Color.lightGray);
        this.setForeground(Color.black);
        this.setTextInsets(new Insets(4, 4, 4, 4));
        this.setUnderlined(bl);
        this.enableEvents(28L);
    }

    private UnconsumedKeyHandler getUnconsumedKeyHandler() {
        if (this.unconsumedKeyHandler == null) {
            Container container = this.getParent();
            while (container != null) {
                if (container instanceof UnconsumedKeyHandler) {
                    this.unconsumedKeyHandler = (UnconsumedKeyHandler)((Object)container);
                    break;
                }
                container = container.getParent();
            }
        }
        return this.unconsumedKeyHandler;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public boolean isFocusTraversable() {
        return this.isEnabled();
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        this.paintText(graphics);
        this.paintBorder(graphics);
    }

    protected void paintBorder(Graphics graphics) {
        Color color = Color.gray;
        Color color2 = Color.white;
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.setColor(color);
        graphics.drawLine(0, 0, n - 2, 0);
        graphics.drawLine(0, 0, 0, n2 - 2);
        graphics.setColor(this.hasFocus() ? color : color2);
        graphics.drawLine(1, 1, n - 2, 1);
        graphics.drawLine(1, 1, 1, n2 - 2);
        graphics.setColor(color2);
        graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
        graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
        graphics.setColor(this.hasFocus() ? color2 : color);
        graphics.drawLine(n - 2, 1, n - 2, n2 - 2);
        graphics.drawLine(1, n2 - 2, n - 2, n2 - 2);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        this.hasFocus = focusEvent.getID() == 1004;
        this.repaint();
        super.processFocusEvent(focusEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed() && this.getUnconsumedKeyHandler() != null) {
            this.getUnconsumedKeyHandler().processUnconsumedKeyEvents(keyEvent, this);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 500) {
            if (this.isEnabled()) {
                this.requestFocus();
            }
            if (GenericMouseHelper.isRightMouseButton(mouseEvent)) {
                this.processKeyEvent(InstrumentKeyMappings.getMenuKeyEvent(this));
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.hasFocus) {
            this.processFocusEvent(new FocusEvent(this, 1005));
        }
    }

    public void requestFocus() {
        if (!this.hasFocus() && EclipseFocusManager.getInstance().canRequestFocus(this)) {
            super.processFocusEvent(new FocusEvent(this, 1004));
            super.requestFocus();
        }
    }
}

