/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.basiccomponents;

import com.sun.java.util.collections.Vector;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Beans;

public class Tiler
extends Container
implements ItemSelectable {
    private int selectedIndex = -1;
    private int numColumns = 0;
    private int rowHeight = 19;
    private int rowGap = 4;
    private int columnGap = 1;
    private boolean compressible = true;
    private boolean strictSizing = false;
    private boolean cursorVisible = true;
    private Color cursorColor = Color.blue;
    private transient int columnWidth = 0;
    private transient Vector spans = new Vector();
    private transient int totalSpan = 0;
    private transient int verticalShift = 0;
    private transient boolean compressAbove = false;
    private transient boolean compressBelow = false;
    private transient boolean paused = false;
    private transient boolean removingAll = false;
    private transient ItemListener itemListener = null;
    private static final int initialWidth = 200;
    private static final int initialHeight = 100;
    private static final Color initialBackground = null;
    private static final int initialColumns = 16;
    private transient FocusListener focusListener = new FocusListener(this){
        /* synthetic */ Tiler this$0;

        public void focusGained(FocusEvent focusEvent) {
            this.this$0.setSelectedIndex(Tiler.access$getComponentIndex(this.this$0, (Component)focusEvent.getSource()));
        }

        public void focusLost(FocusEvent focusEvent) {
        }
        {
            this.this$0 = tiler;
        }
    };
    static final long serialVersionUID = -5465678144070867394L;

    public Tiler() {
        this(16);
    }

    public Tiler(int n) {
        this.numColumns = n;
        this.setBackground(initialBackground);
        this.setSize(200, 100);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (!(object instanceof Integer)) {
            object = null;
        }
        Integer n2 = object != null ? (Integer)object : new Integer(1);
        component.setSize(0, 0);
        component.addFocusListener(this.focusListener);
        component.setEnabled(this.isEnabled());
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            if (n == -1) {
                n = this.getComponentCount();
            }
            this.totalSpan += n2.intValue();
            this.spans.add(n, (Object)n2);
            super.addImpl(component, null, n);
        }
        if (n <= this.selectedIndex) {
            this.setSelectedIndex(this.selectedIndex + 1);
        }
        this.layoutChildren();
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public void compress() {
        Component component;
        int n;
        if (!this.isCompressible() || this.isCompressed() || this.selectedIndex == -1) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = n = this.getComponent((int)this.selectedIndex).getLocation().y;
        int n5 = this.selectedIndex;
        while (n5 >= 0) {
            if (this.getComponent((int)n5).getLocation().y < n4) {
                n4 = this.getComponent((int)n5).getLocation().y;
                ++n2;
            }
            --n5;
        }
        n4 = this.getComponent((int)this.selectedIndex).getLocation().y;
        n5 = this.selectedIndex;
        while (n5 < this.getComponentCount()) {
            if (this.getComponent((int)n5).getLocation().y > n4) {
                n4 = this.getComponent((int)n5).getLocation().y;
                ++n3;
            }
            ++n5;
        }
        if (n2 > 1) {
            n5 = 0;
            while (n5 < this.getComponentCount()) {
                component = this.getComponent(n5);
                if (component.getLocation().y < n) {
                    component.setVisible(false);
                } else {
                    if (component.getLocation().y != n) break;
                    this.verticalShift = component.getLocation().y - 15;
                    component.setLocation(component.getLocation().x, 15);
                }
                ++n5;
            }
            this.compressAbove = true;
        }
        if (n3 > 1) {
            n5 = this.selectedIndex;
            while (n5 < this.getComponentCount()) {
                component = this.getComponent(n5);
                if (component.getLocation().y > n) {
                    component.setVisible(false);
                }
                ++n5;
            }
            this.compressBelow = true;
        } else {
            n5 = this.selectedIndex;
            while (n5 < this.getComponentCount()) {
                component = this.getComponent(n5);
                if (component.getLocation().y > n) {
                    component.setLocation(component.getLocation().x, component.getLocation().y - this.verticalShift);
                }
                ++n5;
            }
        }
        this.repaint();
    }

    private void deselectSelectedComponent() {
        if (this.selectedIndex > -1 && this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.getComponent(this.selectedIndex), 2));
        }
    }

    public int getColumnGap() {
        return this.columnGap;
    }

    private int getComponentIndex(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = 0;
            while (n < this.getComponentCount()) {
                if (this.getComponent(n) == component) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
    }

    public Color getCursorColor() {
        return this.cursorColor;
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Dimension getMinimumSize() {
        int n = 0;
        int n2 = 0;
        Object object = this.getTreeLock();
        synchronized (object) {
            int n3 = 0;
            while (n3 < this.getComponentCount()) {
                Component component = this.getComponent(n3);
                if (component.isVisible()) {
                    int n4 = (Integer)this.spans.get(n3);
                    n = Math.max(n, component.getMinimumSize().width * n4 + this.columnGap * (n4 - 1));
                    n2 = Math.max(n2, component.getLocation().y + component.getSize().height);
                }
                ++n3;
            }
        }
        if (this.compressBelow) {
            n2 += 15;
        }
        return new Dimension(n, n2);
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        Object object = this.getTreeLock();
        synchronized (object) {
            int n3 = 0;
            while (n3 < this.getComponentCount()) {
                Component component = this.getComponent(n3);
                if (component.isVisible()) {
                    int n4 = (Integer)this.spans.get(n3);
                    n = Math.max(n, component.getPreferredSize().width * this.numColumns / n4 + this.columnGap * (this.numColumns - 1));
                    n2 = Math.max(n2, component.getLocation().y + component.getSize().height);
                }
                ++n3;
            }
        }
        if (this.compressBelow) {
            n2 += 15;
        }
        return new Dimension(n, n2);
    }

    public int getRowGap() {
        return this.rowGap;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Object[] getSelectedObjects() {
        if (this.selectedIndex > -1) {
            return new Object[]{this.getComponent(this.selectedIndex)};
        }
        return null;
    }

    public int getTotalSpan() {
        return this.totalSpan;
    }

    public boolean isCompressed() {
        return this.compressAbove || this.compressBelow;
    }

    public boolean isCompressible() {
        return this.compressible;
    }

    public boolean isCursorVisible() {
        return this.cursorVisible;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isStrictSizing() {
        return this.strictSizing;
    }

    private void layoutChildren() {
        if (this.paused) {
            return;
        }
        int n = 0;
        int n2 = 0;
        Object object = this.getTreeLock();
        synchronized (object) {
            int n3 = 0;
            while (n3 < this.getComponentCount()) {
                Component component = this.getComponent(n3);
                int n4 = (Integer)this.spans.get(n3);
                int n5 = 1;
                int n6 = n4;
                int cfr_ignored_0 = this.numColumns - n;
                if (n + n4 > this.numColumns && n > 0) {
                    if (this.strictSizing) {
                        n4 -= this.numColumns - n;
                    }
                    n = 0;
                    ++n2;
                }
                if (n4 > this.numColumns) {
                    n5 = n4 / this.numColumns;
                    n6 = this.numColumns;
                } else {
                    n5 = 1;
                    n6 = n4;
                }
                component.setBounds(n * (this.columnWidth + this.columnGap), n2 * (this.rowHeight + this.rowGap), n6 * this.columnWidth + (n6 - 1) * this.columnGap, n5 * this.rowHeight + (n5 - 1) * this.rowGap);
                if (n4 > this.numColumns) {
                    n = this.strictSizing ? n4 % this.numColumns : 0;
                    n2 += n5;
                } else {
                    n += n6;
                }
                ++n3;
            }
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.getBackground() != null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
        super.paint(graphics);
        if (this.cursorVisible) {
            this.paintCursor(graphics);
        }
        if (Beans.isDesignTime()) {
            graphics.setColor(Color.gray);
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }
        if (this.compressAbove) {
            this.paintElipsis(graphics, (this.getSize().width - 21) / 2, 6);
        }
        if (this.compressBelow) {
            Component component = this.getComponent(this.selectedIndex);
            this.paintElipsis(graphics, (this.getSize().width - 21) / 2, component.getLocation().y + component.getSize().height + 8);
        }
    }

    private void paintCursor(Graphics graphics) {
        if (this.selectedIndex > -1) {
            Component component = this.getComponent(this.selectedIndex);
            int n = component.getLocation().x;
            int n2 = component.getLocation().y;
            int n3 = component.getSize().width;
            int n4 = component.getSize().height;
            graphics.setColor(this.cursorColor);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.drawRect(n + 1, n2 + 1, n3 - 3, n4 - 3);
        }
    }

    private void paintElipsis(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.black);
        graphics.fillRect(n + 0, n2, 3, 3);
        graphics.fillRect(n + 9, n2, 3, 3);
        graphics.fillRect(n + 18, n2, 3, 3);
    }

    public void pause() {
        this.paused = true;
    }

    private void redoGeometry() {
        this.columnWidth = (this.getSize().width - (this.numColumns - 1) * this.columnGap) / this.numColumns;
        this.layoutChildren();
    }

    public void remove(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = this.selectedIndex;
            if (this.selectedIndex >= n) {
                this.deselectSelectedComponent();
                this.selectedIndex = -2;
            }
            Component component = this.getComponent(n);
            component.removeFocusListener(this.focusListener);
            this.totalSpan -= ((Integer)this.spans.elementAt(n)).intValue();
            this.spans.remove(n);
            super.remove(n);
            if (n2 >= n) {
                this.setSelectedIndex(n2 == n ? -1 : n2 - 1);
            }
        }
        this.layoutChildren();
    }

    public void remove(Component component) {
        this.remove(this.getComponentIndex(component));
    }

    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.setSelectedIndex(-1);
            boolean bl = this.paused;
            this.pause();
            while (this.getComponentCount() > 0) {
                this.remove(0);
            }
            if (!bl) {
                this.unpause();
            }
        }
        this.layoutChildren();
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public void repaint() {
        if (!this.paused) {
            super.repaint();
        }
    }

    public void requestFocus() {
        if (this.selectedIndex != -1) {
            this.getComponent(this.selectedIndex).requestFocus();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.redoGeometry();
    }

    public void setColumnGap(int n) {
        this.columnGap = n;
        this.redoGeometry();
    }

    public void setCompressible(boolean bl) {
        this.compressible = bl;
        if (!this.compressible && this.isCompressed()) {
            this.uncompress();
        }
    }

    public void setCursorColor(Color color) {
        this.cursorColor = color;
        if (this.cursorVisible) {
            this.repaint();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        int n = 0;
        while (n < this.getComponentCount()) {
            this.getComponent(n).setEnabled(bl);
            ++n;
        }
        this.repaint();
    }

    public void setNumColumns(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Cannot specify 'numColumns' of 0 or less");
        }
        this.numColumns = n;
        this.redoGeometry();
    }

    public void setRowGap(int n) {
        this.rowGap = n;
        this.layoutChildren();
    }

    public void setRowHeight(int n) {
        this.rowHeight = n;
        this.layoutChildren();
    }

    public void setSelectedIndex(int n) {
        if (this.selectedIndex != n) {
            this.deselectSelectedComponent();
            this.selectedIndex = n;
            if (this.itemListener != null) {
                this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.selectedIndex > -1 ? this.getComponent(this.selectedIndex) : null, 1));
            }
            this.repaint();
        }
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.redoGeometry();
    }

    public void setStrictSizing(boolean bl) {
        this.strictSizing = bl;
        this.layoutChildren();
    }

    public void showCursor(boolean bl) {
        if (this.cursorVisible != bl) {
            this.cursorVisible = bl;
            this.repaint();
        }
    }

    public void uncompress() {
        if (this.isCompressed()) {
            int n = 0;
            while (n < this.getComponentCount()) {
                Component component = this.getComponent(n);
                if (component.isVisible() && this.verticalShift > 0) {
                    component.setLocation(component.getLocation().x, component.getLocation().y + this.verticalShift);
                } else {
                    component.setVisible(true);
                }
                ++n;
            }
            this.compressAbove = false;
            this.compressBelow = false;
            this.verticalShift = 0;
            this.repaint();
        }
    }

    public void unpause() {
        this.paused = false;
        this.redoGeometry();
    }

    static int access$getComponentIndex(Tiler tiler, Component component) {
        return tiler.getComponentIndex(component);
    }
}

