/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.button;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.CompositeData;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.CompositeDataReceiver;
import com.agilent.tntd.eclipse.bottomlayer.datatype.LockableBoolean;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcGreyableComponent;
import com.agilent.tntd.eclipse.common.data.GenericApplicationData;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclButtonDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.BooleanState;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseButtonHandler;
import com.agilent.tntd.eclipse.viewlayer.components.button.EclButtonModel;
import com.agilent.tntd.eclipse.viewlayer.components.button.EclButtonView;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.io.IOException;

public class EclButton
extends EclipseComponent
implements CompositeDataReceiver,
CcGreyableComponent {
    private EclButtonModel eclModel;
    private transient EclButtonView eclView;
    private transient boolean hasFocus = false;
    private transient ActionListener actionListener = null;
    private transient boolean hasTrappedTransientError = false;
    private transient ApplicationObject theApplicationObject = null;
    private transient boolean isInitialChange;
    private transient ApplicationGenericMetaData metaData = null;
    protected static transient MouseButtonHandler theMouseButtonHandler = null;
    private transient BooleanState isActionning = null;
    private transient ApplicationObject theGreyApplicationObject = null;
    private transient MaskedIntegerValue thePreviousIndexValue = null;
    private transient MaskedIntegerValue thePreviousGreyValue = null;

    public EclButton() {
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
        this.initialiseHandledEvents();
        this.setSize(70, 20);
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else {
            switch (this.eclModel.getPropertyIDForName(applicationObject.getName())) {
                case 10: {
                    this.isInitialChange = true;
                    this.theApplicationObject = applicationObject;
                    break;
                }
                default: {
                    this.theGreyApplicationObject = applicationObject;
                }
            }
        }
    }

    protected void action(boolean bl) {
        GenericApplicationData genericApplicationData = null;
        if (this.getEclModel().getCompositeDataID() != -1) {
            genericApplicationData = new LockableBoolean(bl);
            genericApplicationData.describe(this.getMetaData());
        } else if (this.thePreviousIndexValue != null) {
            genericApplicationData = this.thePreviousIndexValue;
        }
        if (genericApplicationData != null) {
            if (!this.theApplicationObject.change(genericApplicationData)) {
                EclipseSystem.instance().beep();
                EventLog.instance().log("ERROR: " + this.toString() + ": action: Requested change failed.");
                this.getEclButtonView().setLockableBooleanProperty(new LockableBoolean(!bl));
                this.repaint();
            } else {
                this.fireActionPerformed(new ActionEvent(this, 1001, "actionned"));
            }
        } else {
            this.fireActionPerformed(new ActionEvent(this, 1001, "actionned"));
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    protected void createMouseButtonHandler() {
        if (theMouseButtonHandler == null) {
            theMouseButtonHandler = new MouseButtonHandler();
        }
        this.enableEvents(16L);
    }

    public void finishInitialise() {
        this.isInitialChange = true;
        this.trapTransientError(true);
        this.getEclModel().finishInitialise();
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    protected BooleanState getActionningState() {
        if (this.isActionning == null) {
            this.isActionning = new BooleanState(false);
        }
        return this.isActionning;
    }

    public Color getBackground() {
        return this.hasTrappedTransientError ? EclButtonDefaults.transientErrorColour : super.getBackground();
    }

    protected EclButtonView getEclButtonView() {
        return this.eclView;
    }

    protected EclipseView getEclipseView() {
        return this.getEclButtonView();
    }

    public EclButtonModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new EclButtonModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
        return this.eclModel;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private ApplicationMetaData getMetaData() {
        if (this.metaData == null) {
            this.metaData = new ApplicationGenericMetaData();
            try {
                PrimitiveTypesWriter primitiveTypesWriter = this.metaData.getPrimitiveTypesWriter();
                primitiveTypesWriter.write(this.getEclModel().getCompositeDataID());
                this.metaData.completedMetaDataInitialisation();
            }
            catch (IOException iOException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": getMetaData: Creation of meta data failed!");
                this.metaData = null;
            }
        }
        return this.metaData;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getEclButtonView() == null ? new Dimension(10, 10) : this.getEclButtonView().getPreferredSize();
        return dimension;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    protected void initialiseHandledEvents() {
        this.enableEvents(12L);
        this.createMouseButtonHandler();
    }

    protected void initialiseModel() {
        if (this.eclModel == null) {
            this.getEclModel();
        } else if (this.eclView == null) {
            this.getEclModel().createView();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    void permanentError() {
        this.setBackground(EclButtonDefaults.permanentErrorColour);
        this.hasTrappedTransientError = false;
        this.setEnabled(false);
        this.initialiseModel();
        this.setVisible(true);
        this.unregister();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        switch (focusEvent.getID()) {
            case 1004: {
                if (!this.isEnabled()) {
                    EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
                    this.hasFocus = false;
                    return;
                }
                this.hasFocus = true;
                break;
            }
            case 1005: {
                this.hasFocus = false;
            }
        }
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        this.getEclButtonView().processKeyEvent(keyEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        theMouseButtonHandler.processMouseEvent(mouseEvent, this.eclView, this.getActionningState(), this.hasFocus, this.isEnabled());
    }

    public void receiveCompositeData(CompositeData compositeData, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theApplicationObject) {
            this.hasTrappedTransientError = !compositeData.update(this.getEclModel().getCompositeDataID(), this.getEclButtonView(), this.isInitialChange);
            this.isInitialChange = false;
            this.trapTransientError(this.hasTrappedTransientError);
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theGreyApplicationObject) {
            if (!maskedIntegerValue.equals(this.thePreviousGreyValue)) {
                this.thePreviousGreyValue = maskedIntegerValue;
                if (this.hasTrappedTransientError) {
                    this.testForValidity();
                } else {
                    this.trapTransientError(!this.getEclModel().updatedGreyValue(this.thePreviousGreyValue));
                    this.repaint();
                }
            }
        } else if (applicationDataSender == this.theApplicationObject) {
            if (!maskedIntegerValue.equals(this.thePreviousIndexValue)) {
                this.thePreviousIndexValue = maskedIntegerValue;
                if (this.hasTrappedTransientError) {
                    this.testForValidity();
                } else {
                    this.trapTransientError(!this.getEclModel().updatedViewWithIndex(this.thePreviousIndexValue));
                    this.repaint();
                }
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void setEclButtonView(EclButtonView eclButtonView) {
        this.eclView = eclButtonView;
    }

    public void setEclModel(EclButtonModel eclButtonModel) {
        this.eclModel = eclButtonModel;
        if (this.eclModel != null) {
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
    }

    public void setGreying(boolean bl, boolean bl2) {
        if (bl2 && this.isEnabled() == bl) {
            this.setEnabled(!bl);
            this.repaint();
        } else {
            this.setEnabled(!bl);
        }
        if (bl && this.hasFocus()) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    private void testForValidity() {
        if (this.getEclModel().updatedViewWithIndex(this.thePreviousIndexValue) && this.getEclModel().updatedGreyValue(this.thePreviousGreyValue)) {
            this.trapTransientError(false);
            this.repaint();
        }
    }

    public String toString() {
        String string = this.getName();
        String string2 = string == null || string.length() == 0 ? "EclButton" : string;
        return String.valueOf(string2) + this.getEclModel().toString();
    }

    public void trapTransientError(boolean bl) {
        if (this.hasTrappedTransientError != bl) {
            this.hasTrappedTransientError = bl;
            if (bl) {
                this.setEnabled(false);
            } else if (this.thePreviousGreyValue == null) {
                this.setGreying(false, false);
            }
        }
    }

    public void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this);
            this.theApplicationObject = null;
            this.thePreviousIndexValue = null;
            this.metaData = null;
        }
        if (this.theGreyApplicationObject != null) {
            this.theGreyApplicationObject.unregister(this);
            this.theGreyApplicationObject = null;
            this.thePreviousGreyValue = null;
        }
        if (this.hasFocus) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
            this.permanentError();
        }
    }
}

