/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.button;

import com.agilent.tntd.eclipse.bottomlayer.datatype.LockableBoolean;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseModel;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclButtonDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.button.AccessibleEclButtonModel;
import com.agilent.tntd.eclipse.viewlayer.components.button.ActionView;
import com.agilent.tntd.eclipse.viewlayer.components.button.EclButton;
import com.agilent.tntd.eclipse.viewlayer.components.button.LatchingView;
import java.beans.Beans;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclButtonModel
implements EclipseModel,
Serializable {
    static final long serialVersionUID = -3408664364086140635L;
    private String databaseEventVariable;
    private String databaseLockableBooleanVariable;
    private String databaseCompositeDataVariable;
    private String databaseGreyVariable;
    private int compositeDataId;
    private int maxNumberOfCharacters;
    private String text = null;
    private String[] customTexts;
    private String helpId = null;
    private transient EclButton controller;

    public EclButtonModel() {
        this.databaseEventVariable = null;
        this.databaseLockableBooleanVariable = null;
        this.databaseCompositeDataVariable = null;
        this.databaseGreyVariable = null;
        this.compositeDataId = 0;
        this.maxNumberOfCharacters = 4;
        this.text = null;
        this.customTexts = null;
        this.helpId = null;
    }

    public EclButtonModel(String string, String string2, String string3, String string4, int n, int n2, String string5, String[] stringArray, String string6) {
        this.databaseEventVariable = string;
        this.databaseLockableBooleanVariable = string2;
        this.databaseCompositeDataVariable = string3;
        this.databaseGreyVariable = string4;
        this.compositeDataId = n;
        this.maxNumberOfCharacters = n2;
        this.text = string5;
        this.customTexts = stringArray;
        this.helpId = string6;
    }

    public EclButtonModel(String string, String string2, String string3, String string4, int n, int n2, String string5, String string6) {
        this(string, string2, string3, string4, n, n2, string5, null, string6);
    }

    protected AccessibleEclButtonModel createAccessibleModel() {
        return new AccessibleEclButtonModel(this.databaseEventVariable, this.databaseLockableBooleanVariable, this.databaseCompositeDataVariable, this.databaseGreyVariable, this.compositeDataId, this.maxNumberOfCharacters, this.text, this.customTexts, this.helpId, this.getController());
    }

    public void createView() {
        this.getController().setHelpId(this.helpId);
        if (this.getController().getBackground() == null) {
            this.getController().setBackground(EclButtonDefaults.background);
        }
        if (this.getController().getFont() == null) {
            this.getController().setFont(EclButtonDefaults.font);
        }
        if (this.getController().getForeground() == null) {
            this.getController().setForeground(EclButtonDefaults.foreground);
        }
        if (this.compositeDataId != -1) {
            if (!(this.getController().getEclButtonView() instanceof LatchingView)) {
                this.getController().setEclButtonView(new LatchingView(this.getController()));
            }
            this.getController().getEclButtonView().setMaximumNumberOfCharacters(this.maxNumberOfCharacters);
        } else {
            if (!(this.getController().getEclButtonView() instanceof ActionView)) {
                this.getController().setEclButtonView(new ActionView(this.getController()));
            }
            this.getController().getEclButtonView().setMaximumNumberOfCharacters(-1);
            this.getController().getEclButtonView().setLockableBooleanProperty(new LockableBoolean(false));
            this.getController().getEclButtonView().setTextProperty(this.text);
            if (this.customTexts != null && Beans.isDesignTime()) {
                this.getController().getEclButtonView().setMaximumNumberOfCharacters(this.maxNumberOfCharacters);
            }
        }
    }

    public void finishInitialise() {
        if (this.databaseCompositeDataVariable != null) {
            ApplicationManager.instance().request(this.getController().getDomainName(), 0, this.databaseCompositeDataVariable, (ApplicationObjectObserver)this.getController());
        } else if (this.databaseEventVariable != null) {
            ApplicationManager.instance().request(this.getController().getDomainName(), 0, this.databaseEventVariable, (ApplicationObjectObserver)this.getController());
        }
        if (this.databaseGreyVariable != null) {
            ApplicationManager.instance().request(this.getController().getDomainName(), 0, this.databaseGreyVariable, (ApplicationObjectObserver)this.getController());
        }
        this.controller.trapTransientError(false);
    }

    int getCompositeDataID() {
        return this.compositeDataId;
    }

    private EclButton getController() {
        return this.controller;
    }

    public int getPropertyIDForName(String string) {
        int n = 0;
        if (string.equals(this.databaseCompositeDataVariable) || string.equals(this.databaseEventVariable)) {
            n = 10;
        } else if (string.equals(this.databaseGreyVariable)) {
            n = 12;
        }
        return n;
    }

    public void initialiseDefaults() {
        this.getController().setFont(EclButtonDefaults.font);
        this.getController().setForeground(EclButtonDefaults.foreground);
        this.getController().setBackground(EclButtonDefaults.background);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.databaseEventVariable = (String)objectInputStream.readObject();
                this.databaseLockableBooleanVariable = (String)objectInputStream.readObject();
                this.databaseCompositeDataVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.compositeDataId = objectInputStream.readInt();
                this.maxNumberOfCharacters = objectInputStream.readInt();
                this.text = (String)objectInputStream.readObject();
                this.helpId = (String)objectInputStream.readObject();
                break;
            }
            case 1: {
                this.databaseEventVariable = (String)objectInputStream.readObject();
                this.databaseLockableBooleanVariable = (String)objectInputStream.readObject();
                this.databaseCompositeDataVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.compositeDataId = objectInputStream.readInt();
                this.maxNumberOfCharacters = objectInputStream.readInt();
                this.text = (String)objectInputStream.readObject();
                this.customTexts = (String[])objectInputStream.readObject();
                this.helpId = (String)objectInputStream.readObject();
                break;
            }
            default: {
                String string = "Cannot deserialize unknown version " + n + " of EclButtonModel";
                throw new IOException(string);
            }
        }
    }

    public void setController(EclButton eclButton) {
        this.controller = eclButton;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("[");
        stringBuffer.append(this.databaseEventVariable == null ? "null" : this.databaseEventVariable);
        stringBuffer.append(", ");
        stringBuffer.append(this.databaseLockableBooleanVariable == null ? "null" : this.databaseLockableBooleanVariable);
        stringBuffer.append(", ");
        stringBuffer.append(this.databaseCompositeDataVariable == null ? "null" : this.databaseCompositeDataVariable);
        stringBuffer.append(", ");
        stringBuffer.append(this.databaseGreyVariable == null ? "null" : this.databaseGreyVariable);
        stringBuffer.append(", ");
        stringBuffer.append(this.compositeDataId);
        stringBuffer.append(", ");
        stringBuffer.append(this.maxNumberOfCharacters);
        stringBuffer.append(", ");
        stringBuffer.append(this.text == null ? "null" : this.text);
        stringBuffer.append(", ");
        stringBuffer.append(this.helpId == null ? "null" : this.helpId);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean updatedGreyValue(MaskedIntegerValue maskedIntegerValue) {
        boolean bl = true;
        if (this.databaseGreyVariable != null) {
            if (maskedIntegerValue == null || maskedIntegerValue.getValue() != 0 && maskedIntegerValue.getValue() != 1) {
                bl = false;
            } else {
                this.getController().setGreying(maskedIntegerValue.getValue() == 0, false);
            }
        } else {
            this.getController().setGreying(false, false);
        }
        return bl;
    }

    public boolean updatedViewWithIndex(MaskedIntegerValue maskedIntegerValue) {
        boolean bl = true;
        if (this.databaseEventVariable != null && this.customTexts != null) {
            if (maskedIntegerValue == null || maskedIntegerValue.getValue() < 0 || maskedIntegerValue.getValue() >= this.customTexts.length) {
                bl = false;
            } else {
                this.getController().getEclButtonView().setTextProperty(this.customTexts[maskedIntegerValue.getValue()]);
            }
        } else {
            this.getController().setGreying(false, false);
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(1);
        objectOutputStream.writeObject(this.databaseEventVariable);
        objectOutputStream.writeObject(this.databaseLockableBooleanVariable);
        objectOutputStream.writeObject(this.databaseCompositeDataVariable);
        objectOutputStream.writeObject(this.databaseGreyVariable);
        objectOutputStream.writeInt(this.compositeDataId);
        objectOutputStream.writeInt(this.maxNumberOfCharacters);
        objectOutputStream.writeObject(this.text);
        objectOutputStream.writeObject(this.customTexts);
        objectOutputStream.writeObject(this.helpId);
    }
}

