/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.button;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GreyPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.LockableBooleanPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.datatype.LockableBoolean;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseGraphicsHelper;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclButtonDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseButton;
import com.agilent.tntd.eclipse.viewlayer.components.button.EclButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.beans.Beans;

public abstract class EclButtonView
implements EclipseView,
LockableBooleanPropertyAccessor,
TextPropertyAccessor,
GreyPropertyAccessor,
MouseButton {
    private EclButton controller;
    private String text = null;
    private Point textOrigin = new Point(0, 0);
    private Color shadow = null;
    private LockableBoolean theLockableBoolean = null;
    private static UnconsumedKeyHandler theMainKeyController = null;
    private Dimension preferredSize;
    private int maxNumberOfCharacters = -1;
    private FontMetrics theFontMetrics = null;
    private boolean sunken;

    public EclButtonView(EclButton eclButton) {
        this.controller = eclButton;
    }

    private void calculateXLocation(String string) {
        if (this.theFontMetrics == null) {
            this.notifyEclipseComponentChanged();
        }
        this.textOrigin.x = (this.controller.getBounds().width - this.theFontMetrics.stringWidth(string)) / 2;
    }

    public void doLeftClickAction() {
        this.setSunken(!this.isSunken());
        this.theLockableBoolean = new LockableBoolean(!this.theLockableBoolean.isTrue());
        this.controller.action(this.theLockableBoolean.isTrue());
    }

    protected abstract void doProcessKeyEvent(KeyEvent var1, UnconsumedKeyHandler var2, LockableBoolean var3, EclButton var4);

    public void doRightClickAction() {
        this.getMainKeyController().processUnconsumedKeyEvents(InstrumentKeyMappings.getMenuKeyEvent(this.controller), this.controller);
    }

    private String fillWithHashes() {
        if (this.maxNumberOfCharacters <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(this.maxNumberOfCharacters);
        int n = 0;
        while (n < this.maxNumberOfCharacters) {
            stringBuffer.append("#");
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private UnconsumedKeyHandler getMainKeyController() {
        block2: {
            if (EclButtonView.theMainKeyController != null) break block2;
            var1_1 = this.controller.getParent();
            if (var1_1 != null) ** GOTO lbl6
            throw new NullPointerException("Cannot find the parent of " + this.controller.toString());
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.getParent();
lbl6:
                // 2 sources

                ** while (var1_1.getParent() != null)
            }
lbl7:
            // 1 sources

            if (!(var1_1 instanceof UnconsumedKeyHandler)) {
                throw new NullPointerException("The root parent " + var1_1.toString() + " doesn't implement UnconsumedKeyHandler");
            }
            EclButtonView.theMainKeyController = (UnconsumedKeyHandler)var1_1;
        }
        return EclButtonView.theMainKeyController;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    private boolean isInError() {
        boolean bl = false;
        if (this.text == null || this.textOrigin.x < 4) {
            bl = true;
        } else if (this.maxNumberOfCharacters != -1 && this.theLockableBoolean == null) {
            bl = true;
        }
        return bl;
    }

    public boolean isLocked() {
        return this.theLockableBoolean.isLocked();
    }

    public boolean isSunken() {
        return this.sunken;
    }

    public void notifyEclipseComponentChanged() {
        this.theFontMetrics = this.controller.getFontMetrics(this.controller.getFont());
        int n = this.theFontMetrics.getMaxAscent() + this.theFontMetrics.getMaxDescent();
        String string = this.maxNumberOfCharacters == -1 && this.text != null ? this.text : this.fillWithHashes();
        this.calculateXLocation(string);
        this.textOrigin.y = (this.controller.getBounds().height - n) / 2 + this.theFontMetrics.getMaxAscent();
        this.preferredSize = new Dimension(10 + Math.max(70, this.theFontMetrics.stringWidth(string)), 4 + Math.max(20, this.theFontMetrics.getHeight()));
        this.shadow = this.controller.getVisibleBackground().darker();
    }

    public void paint(Graphics graphics) {
        int n = this.controller.getBounds().width;
        int n2 = this.controller.getBounds().height;
        if (this.isInError()) {
            graphics.setColor(Color.orange);
            graphics.fillRect(1, 1, n - 2, n2 - 2);
            graphics.setFont(this.controller.getFont());
            graphics.setColor(this.controller.isEnabled() ? this.controller.getForeground() : this.shadow);
            graphics.drawString(this.fillWithHashes(), this.textOrigin.x, this.textOrigin.y);
            EclipseGraphicsHelper.paintRaisedBox(graphics, 1, 1, n - 2, n2 - 2);
        } else {
            if (this.controller.getBackground() != null) {
                graphics.setColor(this.controller.getBackground());
                graphics.fillRect(1, 1, n - 2, n2 - 2);
            }
            graphics.setFont(this.controller.getFont());
            graphics.setColor(this.controller.isEnabled() ? this.controller.getForeground() : this.shadow);
            if (this.theLockableBoolean.isLocked()) {
                graphics.setColor(this.shadow);
            }
            graphics.drawString(this.text, this.textOrigin.x, this.textOrigin.y);
            if (this.isSunken()) {
                EclipseGraphicsHelper.paintSunkenBox(graphics, 1, 1, n - 2, n2 - 2);
            } else {
                EclipseGraphicsHelper.paintRaisedBox(graphics, 1, 1, n - 2, n2 - 2);
            }
        }
        if (Beans.isDesignTime()) {
            graphics.setColor(this.shadow);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        }
        if (this.controller.hasFocus()) {
            graphics.setColor(EclButtonDefaults.focusColour);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        this.doProcessKeyEvent(keyEvent, this.getMainKeyController(), this.theLockableBoolean, this.controller);
    }

    public void repaint() {
        this.controller.repaint();
    }

    public void requestFocus() {
        this.controller.requestFocus();
    }

    public void setCompositeProperty(int n) {
        this.maxNumberOfCharacters = n;
        if (Beans.isDesignTime() && n != -1) {
            this.text = this.fillWithHashes();
            this.theLockableBoolean = new LockableBoolean(true);
            this.notifyEclipseComponentChanged();
        }
    }

    public boolean setGreyProperty(boolean bl) {
        this.controller.setGreying(bl, false);
        return true;
    }

    public boolean setLockableBooleanProperty(LockableBoolean lockableBoolean) {
        if (lockableBoolean != null) {
            this.theLockableBoolean = lockableBoolean;
            this.sunken = lockableBoolean.isTrue();
            return true;
        }
        return false;
    }

    public void setMaximumNumberOfCharacters(int n) {
        this.maxNumberOfCharacters = n;
        if (Beans.isDesignTime() && n != -1) {
            this.text = this.fillWithHashes();
            this.theLockableBoolean = new LockableBoolean(true);
            this.notifyEclipseComponentChanged();
        }
    }

    public void setSunken(boolean bl) {
        this.sunken = bl;
    }

    public boolean setTextProperty(String string) {
        boolean bl = true;
        if (string == null || this.maxNumberOfCharacters != -1 && string.length() > this.maxNumberOfCharacters) {
            this.calculateXLocation(this.fillWithHashes());
            bl = false;
        } else {
            this.text = string;
            this.calculateXLocation(this.text);
        }
        return bl;
    }
}

