/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.checkbox;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.CompositeData;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.CompositeDataReceiver;
import com.agilent.tntd.eclipse.bottomlayer.datatype.LockableBoolean;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcGreyableComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclCheckBoxDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseActionnedComponentHandler;
import com.agilent.tntd.eclipse.viewlayer.components.checkbox.EclCheckBoxModel;
import com.agilent.tntd.eclipse.viewlayer.components.checkbox.EclCheckBoxView;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.io.IOException;

public class EclCheckBox
extends EclipseComponent
implements CcGreyableComponent,
CompositeDataReceiver {
    private transient ApplicationObject theApplicationObject;
    private transient ApplicationObject theGreyApplicationObject;
    private transient EclCheckBoxView eclView = null;
    private EclCheckBoxModel eclModel = null;
    private transient boolean hasFocus = false;
    private transient boolean hasTrappedTransientError = false;
    private transient MaskedIntegerValue thePreviousIndexValue = null;
    private transient MaskedIntegerValue thePreviousGreyValue = null;
    private static transient MouseActionnedComponentHandler theMouseHandler = null;
    private transient boolean canRepaint = true;
    private transient ApplicationGenericMetaData metaData = null;
    private transient boolean isInitialChange;

    public EclCheckBox() {
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
        this.setSize(70, 20);
        this.enableEvents(12L);
        this.createMouseHandler();
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else {
            String string = applicationObject.getName();
            if (this.eclModel.getPropertyIDForName(string) == 10) {
                this.theApplicationObject = applicationObject;
            } else {
                this.theGreyApplicationObject = applicationObject;
            }
        }
    }

    protected void createMouseHandler() {
        if (theMouseHandler == null) {
            theMouseHandler = new MouseActionnedComponentHandler();
        }
        this.enableEvents(16L);
    }

    public void finishInitialise() {
        this.trapTransientError(true);
        this.getEclModel().finishInitialise();
    }

    public Color getBackground() {
        return this.hasTrappedTransientError ? EclCheckBoxDefaults.transientErrorColour : super.getBackground();
    }

    EclCheckBoxView getEclCheckBoxView() {
        return this.eclView;
    }

    protected EclipseView getEclipseView() {
        return this.getEclCheckBoxView();
    }

    public EclCheckBoxModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new EclCheckBoxModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
        return this.eclModel;
    }

    private ApplicationMetaData getMetaData() {
        if (this.metaData == null) {
            this.metaData = new ApplicationGenericMetaData();
            try {
                PrimitiveTypesWriter primitiveTypesWriter = this.metaData.getPrimitiveTypesWriter();
                primitiveTypesWriter.write(this.getEclModel().getCompositeDataID());
                this.metaData.completedMetaDataInitialisation();
            }
            catch (IOException iOException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": getMetaData: Creation of meta data failed!");
                this.metaData = null;
            }
        }
        return this.metaData;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    protected void initialiseModel() {
        EclCheckBoxModel eclCheckBoxModel = this.getEclModel();
        if (this.eclView == null) {
            eclCheckBoxModel.createView();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    void permanentError() {
        this.setBackground(EclCheckBoxDefaults.permanentErrorColour);
        this.hasTrappedTransientError = false;
        this.setGreying(true, false);
        this.getEclModel().createView();
        this.setVisible(true);
        this.unregister();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        switch (focusEvent.getID()) {
            case 1004: {
                if (!this.isEnabled()) {
                    EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
                    this.hasFocus = false;
                    return;
                }
                this.hasFocus = true;
                break;
            }
            case 1005: {
                this.hasFocus = false;
            }
        }
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        this.getEclCheckBoxView().processKeyEvent(keyEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        theMouseHandler.processMouseEvent(mouseEvent, this.getEclCheckBoxView(), this.hasFocus, this.isEnabled());
    }

    public void receiveCompositeData(CompositeData compositeData, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theApplicationObject) {
            if (this.hasTrappedTransientError) {
                compositeData.update(this.getEclModel().getCompositeDataID(), this.getEclCheckBoxView(), this.isInitialChange);
                this.testForValidity();
                this.isInitialChange = false;
            } else {
                this.trapTransientError(!compositeData.update(this.getEclModel().getCompositeDataID(), this.getEclCheckBoxView(), this.isInitialChange));
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theApplicationObject) {
            if (!maskedIntegerValue.equals(this.thePreviousIndexValue)) {
                this.thePreviousIndexValue = maskedIntegerValue;
                if (this.hasTrappedTransientError) {
                    this.testForValidity();
                } else {
                    this.trapTransientError(!this.getEclModel().updatedValue(this.thePreviousIndexValue));
                    this.repaint();
                }
            }
        } else if (applicationDataSender == this.theGreyApplicationObject) {
            if (!maskedIntegerValue.equals(this.thePreviousGreyValue)) {
                this.thePreviousGreyValue = maskedIntegerValue;
                if (this.hasTrappedTransientError) {
                    this.testForValidity();
                } else {
                    this.trapTransientError(!this.getEclModel().updatedGreyValue(this.thePreviousGreyValue));
                    this.repaint();
                }
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void setEclCheckBoxView(EclCheckBoxView eclCheckBoxView) {
        this.eclView = eclCheckBoxView;
    }

    public void setEclModel(EclCheckBoxModel eclCheckBoxModel) {
        this.eclModel = eclCheckBoxModel;
        if (this.eclModel != null) {
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
    }

    public void setGreying(boolean bl, boolean bl2) {
        if (bl2 && this.isEnabled() == bl) {
            this.setEnabled(!bl);
            this.repaint();
        } else {
            this.setEnabled(!bl);
        }
        if (bl && this.hasFocus()) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    public void setValue(boolean bl) {
        MaskedIntegerValue maskedIntegerValue = new MaskedIntegerValue(bl ? 1 : 0);
        if (this.getEclModel().getCompositeDataID() != -1) {
            maskedIntegerValue.describe(this.getMetaData());
        }
        if (!this.theApplicationObject.change(maskedIntegerValue)) {
            EclipseSystem.instance().beep();
            EventLog.instance().log(String.valueOf(this.toString()) + " requested change failed.");
            this.getEclCheckBoxView().setLockableBooleanProperty(new LockableBoolean(!bl));
        }
    }

    private void testForValidity() {
        if (this.getEclModel().updatedGreyValue(this.thePreviousGreyValue) && this.getEclModel().updatedValue(this.thePreviousIndexValue)) {
            this.trapTransientError(false);
            this.repaint();
        }
    }

    public String toString() {
        String string = this.getName();
        String string2 = string == null || string.length() == 0 ? "EclCheckBox" : string;
        return String.valueOf(string2) + this.getEclModel().toString();
    }

    public void trapTransientError(boolean bl) {
        this.hasTrappedTransientError = bl;
        if (bl) {
            this.setGreying(true, false);
        }
    }

    public void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this);
            this.theApplicationObject = null;
            this.thePreviousIndexValue = null;
        }
        if (this.theGreyApplicationObject != null) {
            this.theGreyApplicationObject.unregister(this);
            this.theGreyApplicationObject = null;
            this.thePreviousGreyValue = null;
        }
        if (this.hasFocus) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
            this.permanentError();
        }
    }
}

