/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.checkbox;

import com.agilent.tntd.eclipse.bottomlayer.datatype.LockableBoolean;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseModel;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclCheckBoxDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.checkbox.AccessibleEclCheckBoxModel;
import com.agilent.tntd.eclipse.viewlayer.components.checkbox.EclCheckBox;
import com.agilent.tntd.eclipse.viewlayer.components.checkbox.EclCheckBoxView;
import java.beans.Beans;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclCheckBoxModel
implements EclipseModel,
Serializable {
    static final long serialVersionUID = 2536069975286988011L;
    private String databaseVariable;
    private String databaseGreyVariable;
    private String text;
    private int bevelThickness;
    private int boxHeight;
    private String helpId;
    private int compositeDataId;
    private transient EclCheckBox controller;

    public EclCheckBoxModel() {
        this("EclCheckBox", null, null);
    }

    public EclCheckBoxModel(String string, String string2, String string3) {
        this(string, string2, string3, 2, 11);
    }

    public EclCheckBoxModel(String string, String string2, String string3, int n, int n2) {
        this(string, string2, string3, n, n2, null);
    }

    public EclCheckBoxModel(String string, String string2, String string3, int n, int n2, String string4) {
        this(string, string2, string3, n, n2, string4, -1);
    }

    public EclCheckBoxModel(String string, String string2, String string3, int n, int n2, String string4, int n3) {
        this.text = string;
        this.databaseVariable = string2;
        this.databaseGreyVariable = string3;
        this.bevelThickness = n;
        this.boxHeight = n2;
        this.helpId = string4;
        this.compositeDataId = n3;
    }

    AccessibleEclCheckBoxModel createAccessibleModel() {
        return new AccessibleEclCheckBoxModel(this.databaseVariable, this.databaseGreyVariable, this.text, this.bevelThickness, this.boxHeight, this.helpId, this.compositeDataId, this.controller);
    }

    public void createView() {
        this.controller.setHelpId(this.helpId);
        if (this.controller.getBackground() == null) {
            this.controller.setBackground(EclCheckBoxDefaults.background);
        }
        if (this.controller.getFont() == null) {
            this.controller.setFont(EclCheckBoxDefaults.font);
        }
        if (this.controller.getForeground() == null) {
            this.controller.setForeground(EclCheckBoxDefaults.foreground);
        }
        if (this.controller.getEclCheckBoxView() == null) {
            this.controller.setEclCheckBoxView(new EclCheckBoxView(this.controller));
        }
        this.controller.getEclCheckBoxView().setText(this.text);
        this.controller.getEclCheckBoxView().setBoxHeight(this.boxHeight);
        this.controller.getEclCheckBoxView().setBevelThickness(this.bevelThickness);
        if (Beans.isDesignTime()) {
            this.controller.getEclCheckBoxView().setLockableBooleanProperty(new LockableBoolean(true));
        }
    }

    public void finishInitialise() {
        if (this.databaseVariable != null) {
            ApplicationManager.instance().request(this.controller.getDomainName(), 0, this.databaseVariable, (ApplicationObjectObserver)this.controller);
            if (this.databaseGreyVariable != null) {
                ApplicationManager.instance().request(this.controller.getDomainName(), 0, this.databaseGreyVariable, (ApplicationObjectObserver)this.controller);
            }
        } else {
            EventLog.instance().log(String.valueOf(this.controller.toString()) + " requires a variable name");
            this.controller.permanentError();
        }
    }

    public int getCompositeDataID() {
        return this.compositeDataId;
    }

    public int getPropertyIDForName(String string) {
        int n = 0;
        if (string.equals(this.databaseVariable)) {
            n = 10;
        } else if (string.equals(this.databaseGreyVariable)) {
            n = 12;
        }
        return n;
    }

    public void initialiseDefaults() {
        this.controller.setFont(EclCheckBoxDefaults.font);
        this.controller.setForeground(EclCheckBoxDefaults.foreground);
        this.controller.setBackground(EclCheckBoxDefaults.background);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.text = (String)objectInputStream.readObject();
                this.databaseVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.bevelThickness = 2;
                this.boxHeight = 11;
                this.compositeDataId = -1;
                break;
            }
            case 1: {
                this.text = (String)objectInputStream.readObject();
                this.databaseVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.bevelThickness = objectInputStream.readInt();
                this.boxHeight = objectInputStream.readInt();
                this.compositeDataId = -1;
                break;
            }
            case 2: {
                this.text = (String)objectInputStream.readObject();
                this.databaseVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.bevelThickness = objectInputStream.readInt();
                this.boxHeight = objectInputStream.readInt();
                this.helpId = (String)objectInputStream.readObject();
                this.compositeDataId = -1;
                break;
            }
            case 3: {
                this.text = (String)objectInputStream.readObject();
                this.databaseVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.bevelThickness = objectInputStream.readInt();
                this.boxHeight = objectInputStream.readInt();
                this.helpId = (String)objectInputStream.readObject();
                this.compositeDataId = objectInputStream.readInt();
                break;
            }
            default: {
                String string = "Cannot deserialize version " + n + " EclCheckBoxModel";
                throw new IOException(string);
            }
        }
    }

    public void setController(EclCheckBox eclCheckBox) {
        this.controller = eclCheckBox;
    }

    public String toString() {
        return "[" + (this.databaseVariable == null ? "null" : this.databaseVariable) + ", " + (this.databaseGreyVariable == null ? "null" : this.databaseGreyVariable) + "]";
    }

    public boolean updatedGreyValue(MaskedIntegerValue maskedIntegerValue) {
        boolean bl = true;
        if (this.databaseGreyVariable != null) {
            if (maskedIntegerValue == null || maskedIntegerValue.getValue() != 0 && maskedIntegerValue.getValue() != 1) {
                bl = false;
            } else {
                this.controller.setGreying(maskedIntegerValue.getValue() == 0, true);
            }
        } else {
            this.controller.setGreying(false, false);
        }
        return bl;
    }

    public boolean updatedValue(MaskedIntegerValue maskedIntegerValue) {
        boolean bl = true;
        if (maskedIntegerValue == null || maskedIntegerValue.getValue() != 0 && maskedIntegerValue.getValue() != 1) {
            bl = false;
        } else {
            this.controller.getEclCheckBoxView().setLockableBooleanProperty(new LockableBoolean(maskedIntegerValue.getValue() == 1));
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(3);
        objectOutputStream.writeObject(this.text);
        objectOutputStream.writeObject(this.databaseVariable);
        objectOutputStream.writeObject(this.databaseGreyVariable);
        objectOutputStream.writeInt(this.bevelThickness);
        objectOutputStream.writeInt(this.boxHeight);
        objectOutputStream.writeObject(this.helpId);
        objectOutputStream.writeInt(this.compositeDataId);
    }
}

