/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.checkbox;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GreyPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.LockableBooleanPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.datatype.LockableBoolean;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclCheckBoxDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseActionnedComponent;
import com.agilent.tntd.eclipse.viewlayer.components.checkbox.EclCheckBox;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.beans.Beans;

public class EclCheckBoxView
implements EclipseView,
MouseActionnedComponent,
LockableBooleanPropertyAccessor,
GreyPropertyAccessor {
    private Color highlight = null;
    private Color shadow = null;
    private int bevelThickness = 2;
    private EclCheckBox controller = null;
    private String text = "";
    private LockableBoolean theLockableBoolean = null;
    private Point textOrigin = new Point(0, 0);
    private Point boxOrigin = new Point(0, 0);
    private int textHeight = 0;
    private int boxHeight = 13;
    private Point[] lineStartPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    private Point[] lineEndPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    private static UnconsumedKeyHandler theMainKeyController = null;

    public EclCheckBoxView(EclCheckBox eclCheckBox) {
        this.controller = eclCheckBox;
        if (eclCheckBox != null) {
            this.calculateGeometry();
        } else {
            System.out.println("null controller in constructor!");
        }
    }

    protected void calculateGeometry() {
        Rectangle rectangle = this.controller.getBounds();
        FontMetrics fontMetrics = null;
        if (this.controller.getFont() != null) {
            fontMetrics = this.controller.getFontMetrics(this.controller.getFont());
        }
        if (fontMetrics != null) {
            this.textHeight = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            this.textOrigin.x = this.boxHeight + 9;
            this.textOrigin.y = (rectangle.height - this.textHeight) / 2 + fontMetrics.getMaxAscent();
        }
        this.boxOrigin.x = 3;
        this.boxOrigin.y = (rectangle.height - this.boxHeight) / 2;
        this.lineStartPoints[0].x = this.boxOrigin.x + this.bevelThickness + 1;
        this.lineStartPoints[0].y = this.boxOrigin.y + this.bevelThickness + 1;
        this.lineEndPoints[0].x = this.boxOrigin.x + this.boxHeight - this.bevelThickness - 2;
        this.lineEndPoints[0].y = this.boxOrigin.y + this.boxHeight - this.bevelThickness - 2;
        this.lineStartPoints[1].x = this.lineStartPoints[0].x + 1;
        this.lineStartPoints[1].y = this.lineStartPoints[0].y;
        this.lineEndPoints[1].x = this.lineEndPoints[0].x;
        this.lineEndPoints[1].y = this.lineEndPoints[0].y - 1;
        this.lineStartPoints[2].x = this.lineStartPoints[0].x;
        this.lineStartPoints[2].y = this.lineStartPoints[0].y + 1;
        this.lineEndPoints[2].x = this.lineEndPoints[0].x - 1;
        this.lineEndPoints[2].y = this.lineEndPoints[0].y;
        this.lineStartPoints[3].x = this.boxOrigin.x + this.boxHeight - this.bevelThickness - 2;
        this.lineStartPoints[3].y = this.boxOrigin.y + this.bevelThickness + 1;
        this.lineEndPoints[3].x = this.boxOrigin.x + this.bevelThickness + 1;
        this.lineEndPoints[3].y = this.boxOrigin.y + this.boxHeight - this.bevelThickness - 2;
        this.lineStartPoints[4].x = this.lineStartPoints[3].x - 1;
        this.lineStartPoints[4].y = this.lineStartPoints[3].y;
        this.lineEndPoints[4].x = this.lineEndPoints[3].x;
        this.lineEndPoints[4].y = this.lineEndPoints[3].y - 1;
        this.lineStartPoints[5].x = this.lineStartPoints[3].x;
        this.lineStartPoints[5].y = this.lineStartPoints[3].y + 1;
        this.lineEndPoints[5].x = this.lineEndPoints[3].x + 1;
        this.lineEndPoints[5].y = this.lineEndPoints[3].y;
    }

    private void derive3DColours() {
        Color color = this.controller.getVisibleBackground();
        this.highlight = color.brighter();
        this.shadow = color.darker();
    }

    public void doLeftClickAction() {
        if (!this.theLockableBoolean.isLocked()) {
            this.theLockableBoolean = new LockableBoolean(!this.theLockableBoolean.isTrue());
            this.controller.setValue(this.theLockableBoolean.isTrue());
        } else {
            EclipseSystem.instance().beep();
        }
    }

    public void doRightClickAction() {
        this.getMainKeyController().processUnconsumedKeyEvents(InstrumentKeyMappings.getMenuKeyEvent(this.controller), this.controller);
    }

    /*
     * Unable to fully structure code
     */
    private UnconsumedKeyHandler getMainKeyController() {
        block2: {
            if (EclCheckBoxView.theMainKeyController != null) break block2;
            var1_1 = this.controller.getParent();
            if (var1_1 != null) ** GOTO lbl6
            throw new NullPointerException("Cannot find the parent of " + this.controller.toString());
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.getParent();
lbl6:
                // 2 sources

                ** while (var1_1.getParent() != null)
            }
lbl7:
            // 1 sources

            if (!(var1_1 instanceof UnconsumedKeyHandler)) {
                throw new NullPointerException("The root parent " + var1_1.toString() + " doesn't implement UnconsumedKeyHandler");
            }
            EclCheckBoxView.theMainKeyController = (UnconsumedKeyHandler)var1_1;
        }
        return EclCheckBoxView.theMainKeyController;
    }

    public void notifyEclipseComponentChanged() {
        this.calculateGeometry();
        this.controller.repaint();
    }

    public void paint(Graphics graphics) {
        if (Beans.isDesignTime() || this.highlight == null) {
            this.derive3DColours();
        }
        if (this.controller.getBackground() != null) {
            graphics.setColor(this.controller.getBackground());
            graphics.fillRect(0, 0, this.controller.getSize().width, this.controller.getSize().height);
        }
        graphics.setFont(this.controller.getFont());
        graphics.setColor(this.controller.isEnabled() ? this.controller.getForeground() : this.shadow);
        graphics.drawString(this.text, this.textOrigin.x, this.textOrigin.y);
        this.paintBox(graphics);
        if (this.controller.hasFocus()) {
            graphics.setColor(EclCheckBoxDefaults.focusColour);
            graphics.drawRect(0, 0, this.controller.getBounds().width - 1, this.controller.getBounds().height - 1);
        }
    }

    private void paint3DHighlights(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, Color color2, boolean bl) {
        int n6 = n + n3 - 1;
        int n7 = n2 + n4 - 1;
        graphics.setColor(bl ? color : color2);
        graphics.drawLine(n, n2, n6, n2);
        graphics.drawLine(n, n2, n, n7);
        graphics.setColor(bl ? Color.lightGray : Color.black);
        graphics.drawLine(n + 1, n2 + 1, n6 - 1, n2 + 1);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n7 - 1);
        graphics.setColor(bl ? color2 : color);
        graphics.drawLine(n, n7, n6, n7);
        graphics.drawLine(n6, n2, n6, n7);
        graphics.setColor(bl ? Color.black : Color.lightGray);
        graphics.drawLine(n6 - 1, n7 - 1, n6 - 1, n + 1);
        graphics.drawLine(n + 1, n7 - 1, n6 - 1, n7 - 1);
    }

    private void paintBox(Graphics graphics) {
        graphics.setColor(this.controller.isEnabled() ? EclCheckBoxDefaults.boxColour : this.controller.getVisibleBackground());
        graphics.fillRect(this.boxOrigin.x, this.boxOrigin.y, this.boxHeight, this.boxHeight);
        this.paint3DHighlights(graphics, this.boxOrigin.x, this.boxOrigin.y, this.boxHeight, this.boxHeight, this.bevelThickness, this.highlight, this.shadow, false);
        if (this.theLockableBoolean != null && this.theLockableBoolean.isTrue()) {
            graphics.setColor(this.controller.isEnabled() ? EclCheckBoxDefaults.enabledCheckColour : EclCheckBoxDefaults.disabledCheckColour);
            graphics.drawLine(this.boxOrigin.x + 3, this.boxOrigin.y + 5, this.boxOrigin.x + 5, this.boxOrigin.y + 7);
            graphics.drawLine(this.boxOrigin.x + 3, this.boxOrigin.y + 6, this.boxOrigin.x + 5, this.boxOrigin.y + 8);
            graphics.drawLine(this.boxOrigin.x + 3, this.boxOrigin.y + 7, this.boxOrigin.x + 5, this.boxOrigin.y + 9);
            graphics.drawLine(this.boxOrigin.x + 5, this.boxOrigin.y + 7, this.boxOrigin.x + 9, this.boxOrigin.y + 3);
            graphics.drawLine(this.boxOrigin.x + 5, this.boxOrigin.y + 8, this.boxOrigin.x + 9, this.boxOrigin.y + 4);
            graphics.drawLine(this.boxOrigin.x + 5, this.boxOrigin.y + 9, this.boxOrigin.x + 9, this.boxOrigin.y + 5);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                case 10: {
                    this.doLeftClickAction();
                }
                case 0: {
                    keyEvent.consume();
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            this.getMainKeyController().processUnconsumedKeyEvents(keyEvent, this.controller);
        }
    }

    public void repaint() {
        this.controller.repaint();
    }

    public void requestFocus() {
        this.controller.requestFocus();
    }

    public void setBevelThickness(int n) {
        this.bevelThickness = n;
        this.calculateGeometry();
    }

    public void setBoxHeight(int n) {
        this.boxHeight = 13;
        this.calculateGeometry();
    }

    public boolean setGreyProperty(boolean bl) {
        this.controller.setGreying(bl, false);
        return true;
    }

    public boolean setLockableBooleanProperty(LockableBoolean lockableBoolean) {
        if (lockableBoolean != null) {
            this.theLockableBoolean = lockableBoolean;
            return true;
        }
        return false;
    }

    public void setText(String string) {
        this.text = string;
    }
}

