/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.combobox;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.CompositeData;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.CompositeDataReceiver;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.MaskedIntegerPropertyAccessor;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ChangeResponseReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcGreyableComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.issdb.common.MaskAccessor;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.GreyableString;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SingleSelectableChoiceController;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SingleSelectableChoiceView;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclComboBoxDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseActionnedComponentHandler;
import com.agilent.tntd.eclipse.viewlayer.components.combobox.EclComboBoxModel;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.io.IOException;

public class EclComboBox
extends EclipseComponent
implements CcGreyableComponent,
SingleSelectableChoiceController,
CompositeDataReceiver,
MaskedIntegerPropertyAccessor,
ChangeResponseReceiver {
    private EclComboBoxModel eclModel;
    private transient SingleSelectableChoiceView eclView;
    private transient ApplicationObject theApplicationObject;
    private transient ApplicationObject theStandardApplicationObject;
    private transient ApplicationObject theGreyApplicationObject;
    private transient boolean hasTrappedTransientError = false;
    private transient MaskedIntegerValue thePreviousIndexValue = null;
    private transient MaskedIntegerValue thePreviousStandardValue = null;
    private transient MaskedIntegerValue thePreviousGreyValue = null;
    private transient boolean hasFocus;
    private transient boolean canRepaint = true;
    private transient ApplicationGenericMetaData metaData = null;
    private transient boolean isInitialChange;
    private static transient MouseActionnedComponentHandler theMouseHandler = null;

    public EclComboBox() {
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
        this.setSize(70, 20);
        this.enableEvents(12L);
        this.createMouseHandler();
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else {
            switch (this.eclModel.getPropertyIDForName(applicationObject.getName())) {
                case 10: {
                    this.isInitialChange = true;
                    this.theApplicationObject = applicationObject;
                    break;
                }
                case 11: {
                    this.theStandardApplicationObject = applicationObject;
                    break;
                }
                default: {
                    this.theGreyApplicationObject = applicationObject;
                }
            }
        }
    }

    protected void createMouseHandler() {
        if (theMouseHandler == null) {
            theMouseHandler = new MouseActionnedComponentHandler();
        }
        this.enableEvents(16L);
    }

    public void finishInitialise() {
        this.trapTransientError(true);
        this.getEclModel().finishInitialise();
    }

    public Color getBackground() {
        return this.hasTrappedTransientError ? EclComboBoxDefaults.transientErrorColour : super.getBackground();
    }

    SingleSelectableChoiceView getEclComboBoxView() {
        return this.eclView;
    }

    protected EclipseView getEclipseView() {
        return this.getEclComboBoxView();
    }

    public EclComboBoxModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new EclComboBoxModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
        return this.eclModel;
    }

    private ApplicationMetaData getMetaData() {
        if (this.metaData == null) {
            this.metaData = new ApplicationGenericMetaData();
            try {
                PrimitiveTypesWriter primitiveTypesWriter = this.metaData.getPrimitiveTypesWriter();
                primitiveTypesWriter.write(this.getEclModel().getCompositeDataID());
                this.metaData.completedMetaDataInitialisation();
            }
            catch (IOException iOException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": getMetaData: Creation of meta data failed!");
                this.metaData = null;
            }
        }
        return this.metaData;
    }

    public boolean hasFocus() {
        return this.hasFocus || this.getEclComboBoxView() != null && this.getEclComboBoxView().hasFocus();
    }

    protected void initialiseModel() {
        if (this.eclModel == null) {
            this.getEclModel();
        } else if (this.eclView == null) {
            this.getEclModel().createView();
        }
    }

    public boolean isFocusTraversable() {
        if (this.getEclComboBoxView() != null) {
            return this.getEclComboBoxView().isFocusTraversable();
        }
        return false;
    }

    int mapCompleteListIndexToIndex(int n) {
        MaskAccessor maskAccessor = this.thePreviousIndexValue.getOptionMask();
        maskAccessor = maskAccessor.createAND(this.thePreviousIndexValue.getStateMask());
        int n2 = -1;
        if (this.thePreviousIndexValue != null) {
            for (int i = -1; i != n; ++i) {
                try {
                    if (!maskAccessor.query(i)) continue;
                    ++n2;
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    EventLog.instance().log(String.valueOf(this.toString()) + " has an Option Mask incomplete");
                    return -1;
                }
            }
            return n2;
        }
        EventLog.instance().log(String.valueOf(this.toString()) + " has no Option Mask defined.");
        return -1;
    }

    private int mapIndexToCompleteListIndex(int n) {
        MaskAccessor maskAccessor = this.thePreviousIndexValue.getOptionMask();
        maskAccessor = maskAccessor.createAND(this.thePreviousIndexValue.getStateMask());
        int n2 = -1;
        int n3 = -1;
        if (this.thePreviousIndexValue != null) {
            while (n2 != n) {
                ++n3;
                try {
                    if (!maskAccessor.query(n3)) continue;
                    ++n2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    EventLog.instance().log(String.valueOf(this.toString()) + " has an Option Mask incomplete");
                    return -1;
                }
            }
            return n3;
        }
        EventLog.instance().log(String.valueOf(this.toString()) + " has no Option Mask defined");
        return -1;
    }

    void permanentError() {
        this.setBackground(EclComboBoxDefaults.permanentErrorColour);
        this.hasTrappedTransientError = false;
        this.setGreying(true, false);
        this.getEclModel().createView();
        this.setVisible(true);
        this.unregister();
    }

    public void processChangeResponse(boolean bl) {
        if (!bl) {
            EclipseSystem.instance().beep();
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: Requested change failed.");
            this.getEclComboBoxView().setSelectedIndex(this.mapCompleteListIndexToIndex(this.thePreviousIndexValue.getValue()), false);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        int n = focusEvent.getID();
        switch (n) {
            case 1004: {
                if (!this.isEnabled()) {
                    EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
                    this.hasFocus = false;
                    return;
                }
                this.hasFocus = true;
                break;
            }
            case 1005: {
                this.hasFocus = false;
            }
        }
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        this.getEclComboBoxView().processKeyEvent(keyEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.isFocusTraversable()) {
            theMouseHandler.processMouseEvent(mouseEvent, this.getEclComboBoxView().getMouseActionnedComponent(), this.hasFocus, this.isEnabled());
        }
    }

    public void receiveCompositeData(CompositeData compositeData, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theApplicationObject) {
            if (this.hasTrappedTransientError) {
                compositeData.update(this.getEclModel().getCompositeDataID(), this, this.isInitialChange);
                this.testForValidity();
                this.isInitialChange = false;
            } else {
                this.trapTransientError(!compositeData.update(this.getEclModel().getCompositeDataID(), this, this.isInitialChange));
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theApplicationObject) {
            if (!maskedIntegerValue.equals(this.thePreviousIndexValue)) {
                if (this.hasTrappedTransientError) {
                    this.thePreviousIndexValue = maskedIntegerValue;
                    this.testForValidity();
                } else if (maskedIntegerValue.hasDifferentMasks(this.thePreviousIndexValue)) {
                    this.thePreviousIndexValue = maskedIntegerValue;
                    this.trapTransientError(!this.getEclModel().updatedViewWithNewMasks(this.thePreviousIndexValue, this.thePreviousStandardValue));
                    this.repaint();
                } else {
                    this.thePreviousIndexValue = maskedIntegerValue;
                    this.trapTransientError(!this.getEclComboBoxView().setSelectedIndex(this.mapCompleteListIndexToIndex(maskedIntegerValue.getValue()), false));
                    this.repaint();
                }
            }
        } else if (applicationDataSender == this.theStandardApplicationObject) {
            if (!maskedIntegerValue.equals(this.thePreviousStandardValue)) {
                this.thePreviousStandardValue = maskedIntegerValue;
                if (this.hasTrappedTransientError) {
                    this.testForValidity();
                } else {
                    this.trapTransientError(!this.getEclModel().updatedViewWithNewStandard(this.thePreviousIndexValue, this.thePreviousStandardValue));
                    this.repaint();
                }
            }
        } else if (applicationDataSender == this.theGreyApplicationObject) {
            if (!maskedIntegerValue.equals(this.thePreviousGreyValue)) {
                this.thePreviousGreyValue = maskedIntegerValue;
                if (this.hasTrappedTransientError) {
                    this.testForValidity();
                } else {
                    this.trapTransientError(!this.getEclModel().updatedGreyValue(this.thePreviousGreyValue));
                    this.repaint();
                }
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void repaint() {
        if (this.canRepaint) {
            super.repaint();
        }
    }

    public final void setDomainName(String string) {
        if (Beans.isDesignTime()) {
            super.setDomainName(string);
        } else {
            String string2 = "EclComboBox now supports multiple domain, as part of its model. You must edit the model property of " + this.toString();
            System.out.println(string2);
            EclipseSystem.instance().exitWithError(string2);
        }
    }

    public void setEclComboBoxView(SingleSelectableChoiceView singleSelectableChoiceView) {
        this.eclView = singleSelectableChoiceView;
    }

    public void setEclModel(EclComboBoxModel eclComboBoxModel) {
        this.eclModel = eclComboBoxModel;
        if (eclComboBoxModel != null) {
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
    }

    public void setGreying(boolean bl, boolean bl2) {
        if (bl2 && this.isEnabled() == bl) {
            this.setEnabled(!bl);
            this.repaint();
        } else {
            this.setEnabled(!bl);
        }
        if (bl && this.hasFocus()) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    public boolean setMaskedIntegerValue(MaskedIntegerValue maskedIntegerValue) {
        this.canRepaint = false;
        this.receiveMaskedIntegerData(maskedIntegerValue, this.theApplicationObject);
        this.canRepaint = true;
        return !this.hasTrappedTransientError;
    }

    public void setSelectedIndex(int n) {
        int n2 = this.mapIndexToCompleteListIndex(n);
        if (n2 != -1) {
            MaskedIntegerValue maskedIntegerValue = new MaskedIntegerValue(n2, this.thePreviousIndexValue);
            if (this.getEclModel().getCompositeDataID() != -1) {
                maskedIntegerValue.describe(this.getMetaData());
            }
            this.theApplicationObject.asyncChange(maskedIntegerValue, this);
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " could not find the index in the model associated to the selection.");
            this.permanentError();
        }
    }

    public void setSelectedString(GreyableString greyableString) {
    }

    private void testForValidity() {
        if (this.getEclModel().updatedViewWithNewList(this.thePreviousIndexValue, this.thePreviousStandardValue, this.thePreviousGreyValue)) {
            this.trapTransientError(false);
            this.repaint();
        }
    }

    public String toString() {
        String string = this.getName();
        String string2 = string == null || string.length() == 0 ? "EclComboBox" : string;
        return String.valueOf(string2) + this.getEclModel().toString();
    }

    public void trapTransientError(boolean bl) {
        this.hasTrappedTransientError = bl;
        if (bl) {
            this.setGreying(true, false);
        }
    }

    public void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this);
            this.theApplicationObject = null;
            this.thePreviousIndexValue = null;
        }
        if (this.theStandardApplicationObject != null) {
            this.theStandardApplicationObject.unregister(this);
            this.theStandardApplicationObject = null;
            this.thePreviousStandardValue = null;
        }
        if (this.theGreyApplicationObject != null) {
            this.theGreyApplicationObject.unregister(this);
            this.theGreyApplicationObject = null;
            this.thePreviousGreyValue = null;
        }
        if (this.hasFocus()) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
            this.permanentError();
        }
    }
}

