/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.combobox;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskAccessor;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseModel;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.GreyableString;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SingleSelectableChoiceButtonListView;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.singlechoice.SingleSelectableChoiceLabelView;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclComboBoxDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.combobox.AccessibleEclComboBoxModel;
import com.agilent.tntd.eclipse.viewlayer.components.combobox.EclComboBox;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclComboBoxModel
implements Serializable,
EclipseModel {
    static final long serialVersionUID = -6777898572363060169L;
    private String databaseVariableName;
    private int databaseVariableDomain;
    private String databaseStandardVariable;
    private int databaseStandardDomain;
    private String databaseGreyVariable;
    private int databaseGreyDomain;
    private String[][] usedItemList;
    private boolean isUserDriven;
    private String helpId = null;
    private int compositeDataId;
    private transient EclComboBox controller = null;
    private transient int haveToBeInitialised = -1;

    public EclComboBoxModel() {
        this.databaseGreyVariable = null;
        this.databaseGreyDomain = 0;
        this.databaseStandardVariable = null;
        this.databaseStandardDomain = 0;
        this.databaseVariableName = null;
        this.databaseVariableDomain = 0;
        this.usedItemList = null;
        this.isUserDriven = true;
    }

    public EclComboBoxModel(String string, int n, String string2, int n2, String string3, int n3, String[][] stringArray, boolean bl, String string4, int n4) {
        this.databaseVariableName = string;
        this.databaseVariableDomain = n;
        this.databaseStandardVariable = string2;
        this.databaseStandardDomain = n2;
        this.databaseGreyVariable = string3;
        this.databaseGreyDomain = n3;
        this.usedItemList = stringArray;
        this.isUserDriven = bl;
        if (this.databaseVariableName == null || this.usedItemList == null) {
            this.haveToBeInitialised = -1;
        } else {
            this.haveToBeInitialised = 1;
            if (this.databaseStandardVariable != null) {
                this.haveToBeInitialised += 2;
            }
            if (this.databaseGreyVariable != null) {
                this.haveToBeInitialised += 4;
            }
        }
        this.helpId = string4;
        this.compositeDataId = n4;
    }

    public EclComboBoxModel(String string, String string2, String string3, String[][] stringArray) {
        this(string, string2, string3, stringArray, true);
    }

    public EclComboBoxModel(String string, String string2, String string3, String[][] stringArray, boolean bl) {
        this(string, string2, string3, stringArray, bl, null);
    }

    public EclComboBoxModel(String string, String string2, String string3, String[][] stringArray, boolean bl, String string4) {
        this(string, string2, string3, stringArray, bl, string4, -1);
    }

    public EclComboBoxModel(String string, String string2, String string3, String[][] stringArray, boolean bl, String string4, int n) {
        this(string, 0, string2, 0, string3, 0, stringArray, bl, string4, n);
    }

    private boolean areIndexValuesConsistent(MaskedIntegerValue maskedIntegerValue) {
        if (maskedIntegerValue == null) {
            return false;
        }
        try {
            if (!maskedIntegerValue.getOptionMask().query(maskedIntegerValue.getValue())) {
                EventLog.instance().log(String.valueOf(this.getController().toString()) + " Inconsistent data: cannot select miv.getValue " + maskedIntegerValue.getValue() + " ,because option mask is false (correspond to item not available in the list).");
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EventLog.instance().log(String.valueOf(this.getController().toString()) + " Inconsistent data: option mask too short for miv.getValue " + maskedIntegerValue.getValue());
            return false;
        }
        try {
            if (!maskedIntegerValue.getStateMask().query(maskedIntegerValue.getValue())) {
                EventLog.instance().log(String.valueOf(this.getController().toString()) + " Inconsistent data: cannot select miv.getValue " + maskedIntegerValue.getValue() + " ,because state mask is false (correspond to greyed item in the list).");
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EventLog.instance().log(String.valueOf(this.getController().toString()) + " Inconsistent data: state mask too short for miv.getValue " + maskedIntegerValue.getValue());
            return false;
        }
        return true;
    }

    private boolean areStandardValuesConsistent(MaskedIntegerValue maskedIntegerValue) {
        boolean bl = true;
        if (this.databaseStandardVariable != null && (maskedIntegerValue == null || maskedIntegerValue.getValue() < 0 || maskedIntegerValue.getValue() > this.usedItemList.length - 2)) {
            bl = false;
        }
        return bl;
    }

    protected AccessibleEclComboBoxModel createAccessibleModel() {
        return new AccessibleEclComboBoxModel(this.databaseVariableName, this.databaseVariableDomain, this.databaseStandardVariable, this.databaseStandardDomain, this.databaseGreyVariable, this.databaseGreyDomain, this.usedItemList, this.isUserDriven, this.helpId, this.compositeDataId, this.getController());
    }

    private GreyableString[] createListView(MaskedIntegerValue maskedIntegerValue, MaskedIntegerValue maskedIntegerValue2) {
        int n = this.databaseStandardVariable == null ? 0 : maskedIntegerValue2.getValue();
        int n2 = 0;
        MaskAccessor maskAccessor = maskedIntegerValue.getOptionMask();
        maskAccessor = maskAccessor.createAND(maskedIntegerValue.getStateMask());
        int n3 = maskAccessor.countSetBits();
        GreyableString[] greyableStringArray = new GreyableString[n3];
        int n4 = 0;
        while (n4 < this.usedItemList[0].length) {
            try {
                if (maskAccessor.query(n4)) {
                    greyableStringArray[n2++] = new GreyableString(this.usedItemList[n + 1][n4 + 1], maskedIntegerValue.getStateMask().query(n4));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                EventLog.instance().log(String.valueOf(this.getController().toString()) + " has an Option Mask or State mask incomplete: impossible to create the list of items");
                return null;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                EventLog.instance().log(String.valueOf(this.getController().toString()) + " has an Option Mask or State mask too big: impossible to create the list of items");
                return null;
            }
            ++n4;
        }
        if (n2 != greyableStringArray.length) {
            EventLog.instance().log(String.valueOf(this.getController().toString()) + " Incompatible mask length for this list of elements in Combo");
            return null;
        }
        return greyableStringArray;
    }

    public void createView() {
        this.controller.setHelpId(this.helpId);
        if (this.getController().getBackground() == null) {
            this.getController().setBackground(EclComboBoxDefaults.background);
        }
        if (this.getController().getFont() == null) {
            this.getController().setFont(EclComboBoxDefaults.font);
        }
        if (this.getController().getForeground() == null) {
            this.getController().setForeground(EclComboBoxDefaults.foreground);
        }
        if (this.isUserDriven && (this.getController().getEclComboBoxView() == null || !this.getController().getEclComboBoxView().isUserSelectable())) {
            this.getController().setEclComboBoxView(new SingleSelectableChoiceButtonListView(this.getController()));
        } else if (!this.isUserDriven && (this.getController().getEclComboBoxView() == null || this.getController().getEclComboBoxView().isUserSelectable())) {
            this.getController().setEclComboBoxView(new SingleSelectableChoiceLabelView(this.getController()));
        }
    }

    public void finishInitialise() {
        if (this.databaseVariableName == null) {
            EventLog.instance().log(String.valueOf(this.getController().toString()) + " requires a variable name");
            this.getController().permanentError();
        } else {
            ApplicationManager.instance().request(this.databaseVariableDomain, 0, this.databaseVariableName, (ApplicationObjectObserver)this.getController());
            switch (this.haveToBeInitialised) {
                case 3: {
                    ApplicationManager.instance().request(this.databaseStandardDomain, 0, this.databaseStandardVariable, (ApplicationObjectObserver)this.getController());
                    break;
                }
                case 7: {
                    ApplicationManager.instance().request(this.databaseStandardDomain, 0, this.databaseStandardVariable, (ApplicationObjectObserver)this.getController());
                }
                case 5: {
                    ApplicationManager.instance().request(this.databaseGreyDomain, 0, this.databaseGreyVariable, (ApplicationObjectObserver)this.getController());
                }
            }
        }
    }

    int getCompositeDataID() {
        return this.compositeDataId;
    }

    protected EclComboBox getController() {
        return this.controller;
    }

    public int getPropertyIDForName(String string) {
        int n = 0;
        if (string.equals(this.databaseVariableName)) {
            n = 10;
        } else if (string.equals(this.databaseStandardVariable)) {
            n = 11;
        } else if (string.equals(this.databaseGreyVariable)) {
            n = 12;
        }
        return n;
    }

    public boolean hasInitialisedViewWithNewList(MaskedIntegerValue maskedIntegerValue, MaskedIntegerValue maskedIntegerValue2, MaskedIntegerValue maskedIntegerValue3) {
        if (this.getController().getEclComboBoxView() == null) {
            this.createView();
        }
        GreyableString[] greyableStringArray = null;
        if (this.updatedGreyValue(maskedIntegerValue3) && this.areStandardValuesConsistent(maskedIntegerValue2) && this.areIndexValuesConsistent(maskedIntegerValue)) {
            greyableStringArray = this.createListView(maskedIntegerValue, maskedIntegerValue2);
        }
        this.getController().getEclComboBoxView().initialiseView(greyableStringArray);
        return greyableStringArray != null;
    }

    public void initialiseDefaults() {
        this.getController().setFont(EclComboBoxDefaults.font);
        this.getController().setBackground(EclComboBoxDefaults.background);
        this.getController().setForeground(EclComboBoxDefaults.foreground);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.databaseVariableName = (String)objectInputStream.readObject();
                this.databaseStandardVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.usedItemList = (String[][])objectInputStream.readObject();
                this.isUserDriven = true;
                this.compositeDataId = -1;
                this.databaseVariableDomain = 0;
                this.databaseStandardDomain = 0;
                this.databaseGreyDomain = 0;
                break;
            }
            case 1: {
                this.databaseVariableName = (String)objectInputStream.readObject();
                this.databaseStandardVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.usedItemList = (String[][])objectInputStream.readObject();
                this.isUserDriven = objectInputStream.readBoolean();
                this.compositeDataId = -1;
                this.databaseVariableDomain = 0;
                this.databaseStandardDomain = 0;
                this.databaseGreyDomain = 0;
                break;
            }
            case 2: 
            case 3: {
                this.databaseVariableName = (String)objectInputStream.readObject();
                this.databaseStandardVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.usedItemList = (String[][])objectInputStream.readObject();
                this.isUserDriven = objectInputStream.readBoolean();
                this.helpId = (String)objectInputStream.readObject();
                this.compositeDataId = -1;
                this.databaseVariableDomain = 0;
                this.databaseStandardDomain = 0;
                this.databaseGreyDomain = 0;
                break;
            }
            case 4: {
                this.databaseVariableName = (String)objectInputStream.readObject();
                this.databaseStandardVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.usedItemList = (String[][])objectInputStream.readObject();
                this.isUserDriven = objectInputStream.readBoolean();
                this.helpId = (String)objectInputStream.readObject();
                this.compositeDataId = objectInputStream.readInt();
                this.databaseVariableDomain = 0;
                this.databaseStandardDomain = 0;
                this.databaseGreyDomain = 0;
                break;
            }
            case 5: {
                this.databaseVariableName = (String)objectInputStream.readObject();
                this.databaseStandardVariable = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.usedItemList = (String[][])objectInputStream.readObject();
                this.isUserDriven = objectInputStream.readBoolean();
                this.helpId = (String)objectInputStream.readObject();
                this.compositeDataId = objectInputStream.readInt();
                this.databaseVariableDomain = objectInputStream.readInt();
                this.databaseStandardDomain = objectInputStream.readInt();
                this.databaseGreyDomain = objectInputStream.readInt();
                break;
            }
            default: {
                String string = "Cannot deserialize version " + n + " EclComboBoxModel";
                throw new IOException(string);
            }
        }
    }

    public void setController(EclComboBox eclComboBox) {
        this.controller = eclComboBox;
    }

    public String toString() {
        return "[" + (this.databaseVariableName == null ? "null" : this.databaseVariableName) + ", " + (this.databaseStandardVariable == null ? "null" : this.databaseStandardVariable) + ", " + (this.databaseGreyVariable == null ? "null" : this.databaseGreyVariable) + (this.compositeDataId == -1 ? "" : ", " + this.compositeDataId) + "]";
    }

    public boolean updatedGreyValue(MaskedIntegerValue maskedIntegerValue) {
        boolean bl = true;
        if (this.databaseGreyVariable != null) {
            if (maskedIntegerValue == null || maskedIntegerValue.getValue() != 0 && maskedIntegerValue.getValue() != 1) {
                bl = false;
            } else {
                this.getController().setGreying(maskedIntegerValue.getValue() == 0, false);
            }
        } else {
            this.getController().setGreying(false, false);
        }
        return bl;
    }

    public boolean updatedViewWithNewList(MaskedIntegerValue maskedIntegerValue, MaskedIntegerValue maskedIntegerValue2, MaskedIntegerValue maskedIntegerValue3) {
        if (this.getController().getEclComboBoxView() == null) {
            this.createView();
        }
        boolean bl = false;
        if (this.areStandardValuesConsistent(maskedIntegerValue2) && this.areIndexValuesConsistent(maskedIntegerValue)) {
            this.getController().getEclComboBoxView().initialiseView(this.createListView(maskedIntegerValue, maskedIntegerValue2));
            bl = this.getController().getEclComboBoxView().setSelectedIndex(this.getController().mapCompleteListIndexToIndex(maskedIntegerValue.getValue()), false);
            if (bl) {
                this.updatedGreyValue(maskedIntegerValue3);
            }
        } else {
            this.getController().getEclComboBoxView().initialiseView(null);
        }
        return bl;
    }

    public boolean updatedViewWithNewMasks(MaskedIntegerValue maskedIntegerValue, MaskedIntegerValue maskedIntegerValue2) {
        boolean bl = false;
        if (this.areIndexValuesConsistent(maskedIntegerValue)) {
            this.getController().getEclComboBoxView().initialiseView(this.createListView(maskedIntegerValue, maskedIntegerValue2));
            bl = this.getController().getEclComboBoxView().setSelectedIndex(this.getController().mapCompleteListIndexToIndex(maskedIntegerValue.getValue()), false);
        } else {
            this.getController().getEclComboBoxView().initialiseView(null);
        }
        return bl;
    }

    public boolean updatedViewWithNewStandard(MaskedIntegerValue maskedIntegerValue, MaskedIntegerValue maskedIntegerValue2) {
        boolean bl = false;
        if (this.areStandardValuesConsistent(maskedIntegerValue2)) {
            this.getController().getEclComboBoxView().initialiseView(this.createListView(maskedIntegerValue, maskedIntegerValue2));
            bl = this.getController().getEclComboBoxView().setSelectedIndex(this.getController().mapCompleteListIndexToIndex(maskedIntegerValue.getValue()), false);
        } else {
            this.getController().getEclComboBoxView().initialiseView(null);
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(5);
        objectOutputStream.writeObject(this.databaseVariableName);
        objectOutputStream.writeObject(this.databaseStandardVariable);
        objectOutputStream.writeObject(this.databaseGreyVariable);
        objectOutputStream.writeObject(this.usedItemList);
        objectOutputStream.writeBoolean(this.isUserDriven);
        objectOutputStream.writeObject(this.helpId);
        objectOutputStream.writeInt(this.compositeDataId);
        objectOutputStream.writeInt(this.databaseVariableDomain);
        objectOutputStream.writeInt(this.databaseStandardDomain);
        objectOutputStream.writeInt(this.databaseGreyDomain);
    }
}

