/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.dataentry;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EditableEntryView;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EntryTypeState;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.LiveManipulator;
import java.awt.event.KeyEvent;

class DecimalState
extends EntryTypeState
implements LiveManipulator {
    private String addONEat(char[] cArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(cArray.length + 1);
        if (n == 0) {
            stringBuffer.append('1');
            stringBuffer.append(cArray);
        } else {
            stringBuffer.append(cArray, 0, n);
            stringBuffer.append('1');
            stringBuffer.append(cArray, n, cArray.length - n);
        }
        return stringBuffer.toString();
    }

    private void checkZeroValueOnChangeSign(char[] cArray, int n) {
        int n2 = n + 1;
        boolean bl = true;
        while (bl) {
            char c;
            if (n2 >= cArray.length || (c = cArray[n2]) == 'E') break;
            if (c != '.' && c != '0') {
                bl = false;
            }
            ++n2;
        }
        if (bl) {
            cArray[n] = 49;
        }
    }

    public String decrement(String string, int n) {
        String string2 = string;
        int n2 = string.length() - n - 1;
        if (string.charAt(n2) == '-' || string.charAt(n2) == 'E' || string.charAt(n2) == '.') {
            EventLog.instance().log("ERROR: " + this.toString() + ": decrement: Invalid index!");
            return string;
        }
        int n3 = string.indexOf("E");
        boolean bl = false;
        if (n2 > n3) {
            if (string.charAt(n3 + 1) == '-') {
                bl = true;
            }
        } else if (string.charAt(0) == '-') {
            bl = true;
        }
        string2 = bl ? this.incrementNumber(string, n2) : this.decrementNumber(string, n2);
        return string2;
    }

    private String decrementNumber(String string, int n) {
        String string2;
        char[] cArray = string.toCharArray();
        if (string.charAt(n) == '0') {
            string2 = this.decrementZERO(cArray, n);
        } else {
            cArray[n] = (char)(cArray[n] - '\u0001');
            string2 = new String(cArray);
        }
        return string2;
    }

    private void decrementPrecedingZeros(char[] cArray, int n) {
        while (n >= 0) {
            if (cArray[n] != '.') {
                if (cArray[n] == 'E') break;
                if (cArray[n] == '0') {
                    cArray[n] = 57;
                } else {
                    cArray[n] = (char)(cArray[n] - '\u0001');
                    break;
                }
            }
            --n;
        }
    }

    private String decrementZERO(char[] cArray, int n) {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer(cArray.length + 1);
        int n2 = n - 1;
        while (n2 >= 0) {
            if (cArray[n2] == 'E') {
                this.checkZeroValueOnChangeSign(cArray, n);
                this.makeNumberNegative(cArray, n2 + 1, stringBuffer);
                break;
            }
            if (cArray[n2] != '.') {
                if (cArray[n2] == '-') {
                    this.checkZeroValueOnChangeSign(cArray, n);
                    stringBuffer.append(cArray, 0, n2);
                    stringBuffer.append(cArray, n2 + 1, cArray.length - n2 - 1);
                    break;
                }
                if (cArray[n2] != '0') {
                    bl = false;
                    break;
                }
            }
            --n2;
        }
        if (!bl) {
            this.decrementPrecedingZeros(cArray, n);
            stringBuffer.append(cArray);
        } else if (n2 == -1) {
            this.checkZeroValueOnChangeSign(cArray, n);
            this.makeNumberNegative(cArray, 0, stringBuffer);
        }
        return stringBuffer.toString();
    }

    public String getTypeString() {
        return "Dec";
    }

    public String increment(String string, int n) {
        String string2 = string;
        int n2 = string.length() - n - 1;
        if (string.charAt(n2) == '-' || string.charAt(n2) == 'E' || string.charAt(n2) == '.') {
            EventLog.instance().log("ERROR: " + this.toString() + ": increment: Invalid index!");
            return string;
        }
        int n3 = string.indexOf("E");
        boolean bl = false;
        if (n2 > n3) {
            if (string.charAt(n3 + 1) == '-') {
                bl = true;
            }
        } else if (string.charAt(0) == '-') {
            bl = true;
        }
        string2 = bl ? this.decrementNumber(string, n2) : this.incrementNumber(string, n2);
        return string2;
    }

    private String incrementNumber(String string, int n) {
        char[] cArray = string.toCharArray();
        String string2 = string;
        boolean bl = true;
        int n2 = n;
        while (bl && n2 >= 0) {
            char c = string.charAt(n2);
            if (c != '.') {
                if (c == 'E' || c == '-') {
                    string2 = this.addONEat(cArray, n2 + 1);
                    break;
                }
                if (c == '9') {
                    cArray[n2] = 48;
                    if (n2 == 0) {
                        string2 = this.addONEat(cArray, 0);
                    }
                } else {
                    cArray[n2] = (char)(cArray[n2] + '\u0001');
                    string2 = new String(cArray);
                    bl = false;
                }
            }
            --n2;
        }
        return string2;
    }

    public boolean isCharSelectable(String string) {
        boolean bl = false;
        if (string == null || string.length() != 1) {
            EventLog.instance().log("ERROR: " + this.toString() + ": isCharSelectable: invalid character received");
        } else {
            char c = string.charAt(0);
            if (c >= '0' && c <= '9') {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isInsertModeSupported() {
        return true;
    }

    public boolean isSeparatorChar(char c) {
        return false;
    }

    public boolean isValid(String string) {
        return true;
    }

    public static void main(String[] stringArray) {
        DecimalState decimalState = new DecimalState();
        String string = "0.020E0423";
        int n = 0;
        while (n < 700) {
            string = decimalState.decrement(string, 6);
            System.out.println(string);
            ++n;
        }
        System.out.println();
        n = 0;
        while (n < 700) {
            string = decimalState.increment(string, 6);
            System.out.println(string);
            ++n;
        }
    }

    private void makeNumberNegative(char[] cArray, int n, StringBuffer stringBuffer) {
        if (n == 0) {
            stringBuffer.append('-');
            stringBuffer.append(cArray);
        } else {
            stringBuffer.append(cArray, 0, n);
            stringBuffer.append('-');
            stringBuffer.append(cArray, n, cArray.length - n);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent, EditableEntryView editableEntryView) {
        switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
            case 49: 
            case 2000: {
                editableEntryView.processChar('1');
                keyEvent.consume();
                break;
            }
            case 50: 
            case 2001: {
                editableEntryView.processChar('2');
                keyEvent.consume();
                break;
            }
            case 51: 
            case 2002: {
                editableEntryView.processChar('3');
                keyEvent.consume();
                break;
            }
            case 52: 
            case 2003: {
                editableEntryView.processChar('4');
                keyEvent.consume();
                break;
            }
            case 53: 
            case 2004: {
                editableEntryView.processChar('5');
                keyEvent.consume();
                break;
            }
            case 54: 
            case 2005: {
                editableEntryView.processChar('6');
                keyEvent.consume();
                break;
            }
            case 55: 
            case 2006: {
                editableEntryView.processChar('7');
                keyEvent.consume();
                break;
            }
            case 56: 
            case 2007: {
                editableEntryView.processChar('8');
                keyEvent.consume();
                break;
            }
            case 57: 
            case 2008: {
                editableEntryView.processChar('9');
                keyEvent.consume();
                break;
            }
            case 48: 
            case 2009: {
                editableEntryView.processChar('0');
                keyEvent.consume();
                break;
            }
            case 69: 
            case 2014: {
                editableEntryView.processChar('E');
                keyEvent.consume();
                break;
            }
            case 46: 
            case 2017: {
                editableEntryView.processChar('.');
                keyEvent.consume();
                break;
            }
            case 109: 
            case 2018: {
                editableEntryView.processChar('-');
                keyEvent.consume();
            }
        }
    }

    public boolean supportPaddedText() {
        return true;
    }

    public String toString() {
        return "EclDataEntry: DecimalState";
    }

    DecimalState() {
    }
}

