/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.dataentry;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.CompositeData;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.CompositeDataReceiver;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcGreyableComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseComponent;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclDataEntryDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseActionnedComponentHandler;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EclDataEntryModel;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EclDataEntryView;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.io.IOException;

public class EclDataEntry
extends EclipseComponent
implements CcGreyableComponent,
KnownLengthStringDataReceiver,
CompositeDataReceiver {
    private EclDataEntryModel eclModel;
    private transient EclDataEntryView eclView;
    private transient boolean hasFocus;
    private transient ApplicationObject theApplicationObject;
    private transient ApplicationObject theGreyApplicationObject;
    private transient boolean hasTrappedTransientError = false;
    private transient KnownLengthStringValue thePreviousStringValue = null;
    private transient MaskedIntegerValue thePreviousGreyValue = null;
    private transient boolean trappedCompositeDataError = true;
    private transient ApplicationGenericMetaData metaData = null;
    private transient boolean isInitialChange;
    private static transient MouseActionnedComponentHandler theMouseHandler = null;

    public EclDataEntry() {
        if (Beans.isDesignTime()) {
            this.getEclModel().initialiseDefaults();
        }
        this.setSize(70, 20);
        this.enableEvents(12L);
        this.createMouseHandler();
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else {
            String string = applicationObject.getName();
            if (this.getEclModel().getPropertyIDForName(string) == 10) {
                this.theApplicationObject = applicationObject;
            } else {
                this.theGreyApplicationObject = applicationObject;
            }
        }
    }

    public void changeValue(String string) {
        KnownLengthStringValue knownLengthStringValue = new KnownLengthStringValue(string);
        if (this.getEclModel().getCompositeDataID() != -1) {
            knownLengthStringValue.describe(this.getMetaData());
        }
        KnownLengthStringValue knownLengthStringValue2 = this.thePreviousStringValue;
        this.thePreviousStringValue = null;
        if (!this.theApplicationObject.change(knownLengthStringValue)) {
            EclipseSystem.instance().beep();
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: Requested change failed.");
            this.thePreviousStringValue = knownLengthStringValue2;
            this.getEclDataEntryView().setText(this.thePreviousStringValue.getValue());
        }
    }

    protected void createMouseHandler() {
        if (theMouseHandler == null) {
            theMouseHandler = new MouseActionnedComponentHandler();
        }
        this.enableEvents(16L);
    }

    public void finishInitialise() {
        this.isInitialChange = true;
        this.trapTransientError(true);
        this.getEclModel().finishInitialise();
    }

    public Color getBackground() {
        return this.hasTrappedTransientError ? EclDataEntryDefaults.transientErrorColour : super.getBackground();
    }

    EclDataEntryView getEclDataEntryView() {
        return this.eclView;
    }

    protected EclipseView getEclipseView() {
        return this.getEclDataEntryView();
    }

    public EclDataEntryModel getEclModel() {
        if (this.eclModel == null) {
            this.eclModel = new EclDataEntryModel();
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
        return this.eclModel;
    }

    private ApplicationMetaData getMetaData() {
        if (this.metaData == null) {
            this.metaData = new ApplicationGenericMetaData();
            try {
                PrimitiveTypesWriter primitiveTypesWriter = this.metaData.getPrimitiveTypesWriter();
                primitiveTypesWriter.write(this.getEclModel().getCompositeDataID());
                this.metaData.completedMetaDataInitialisation();
            }
            catch (IOException iOException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": getMetaData: Creation of meta data failed!");
                this.metaData = null;
            }
        }
        return this.metaData;
    }

    String getPreviousStringValue() {
        return this.thePreviousStringValue == null ? null : this.thePreviousStringValue.getValue();
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    protected void initialiseModel() {
        if (this.eclModel == null) {
            this.getEclModel();
        } else if (this.eclView == null) {
            this.getEclModel().createView();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    void permanentError() {
        this.setBackground(EclDataEntryDefaults.permanentErrorColour);
        this.hasTrappedTransientError = false;
        this.setGreying(true, false);
        this.getEclModel().createView();
        this.setVisible(true);
        this.unregister();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        switch (focusEvent.getID()) {
            case 1004: {
                if (!this.isEnabled()) {
                    EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
                    this.hasFocus = false;
                    return;
                }
                this.hasFocus = true;
                break;
            }
            case 1005: {
                this.hasFocus = false;
            }
        }
        this.getEclDataEntryView().processFocusEvent(focusEvent);
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        this.getEclDataEntryView().processKeyEvent(keyEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.getEclDataEntryView().getMouseActionnedComponent() != null) {
            theMouseHandler.processMouseEvent(mouseEvent, this.getEclDataEntryView().getMouseActionnedComponent(), this.hasFocus, this.isEnabled());
        }
    }

    public void receiveCompositeData(CompositeData compositeData, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theApplicationObject) {
            this.trappedCompositeDataError = !compositeData.update(this.getEclModel().getCompositeDataID(), this.getEclDataEntryView(), this.isInitialChange);
            this.isInitialChange = false;
            if (this.hasTrappedTransientError) {
                this.testForValidity();
            } else {
                this.trapTransientError(this.trappedCompositeDataError);
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void receiveKnownLengthStringData(KnownLengthStringValue knownLengthStringValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theApplicationObject) {
            if (!knownLengthStringValue.equals(this.thePreviousStringValue)) {
                this.thePreviousStringValue = knownLengthStringValue;
                if (this.hasTrappedTransientError) {
                    this.testForValidity();
                } else {
                    this.trapTransientError(!this.getEclDataEntryView().setText(knownLengthStringValue.getValue()));
                    this.repaint();
                }
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theGreyApplicationObject) {
            if (!maskedIntegerValue.equals(this.thePreviousGreyValue)) {
                this.thePreviousGreyValue = maskedIntegerValue;
                if (this.hasTrappedTransientError) {
                    this.testForValidity();
                } else {
                    this.trapTransientError(!this.getEclModel().updatedGreyValue(this.thePreviousGreyValue));
                    this.repaint();
                }
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void setEclDataEntryView(EclDataEntryView eclDataEntryView) {
        this.eclView = eclDataEntryView;
    }

    public void setEclModel(EclDataEntryModel eclDataEntryModel) {
        this.eclModel = eclDataEntryModel;
        if (eclDataEntryModel != null) {
            this.eclModel.setController(this);
            this.eclModel.createView();
        }
    }

    public void setGreying(boolean bl, boolean bl2) {
        if (this.isEnabled() == bl) {
            this.setEnabled(!bl);
            if (this.getEclDataEntryView() != null) {
                this.getEclDataEntryView().setGreyProperty(bl);
            }
            if (bl2) {
                this.repaint();
            }
        }
        if (bl && this.hasFocus()) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    void setPreviousStringValue(String string) {
        this.thePreviousStringValue = new KnownLengthStringValue(string);
    }

    private void testForValidity() {
        if (this.getEclModel().getCompositeDataID() == -1) {
            if (this.thePreviousStringValue != null && this.getEclModel().updatedGreyValue(this.thePreviousGreyValue)) {
                this.trapTransientError(!this.getEclDataEntryView().setText(this.thePreviousStringValue.getValue()));
                this.repaint();
            }
        } else if (!this.trappedCompositeDataError && this.getEclModel().updatedGreyValue(this.thePreviousGreyValue)) {
            this.trapTransientError(false);
            this.repaint();
        }
    }

    public String toString() {
        String string = this.getName();
        String string2 = string == null || string.length() == 0 ? "EclDataEntry" : string;
        return String.valueOf(string2) + this.getEclModel().toString();
    }

    public void trapTransientError(boolean bl) {
        if (this.hasTrappedTransientError != bl) {
            this.hasTrappedTransientError = bl;
            if (this.getEclDataEntryView() != null) {
                this.getEclDataEntryView().notifyEclipseComponentChanged();
            }
        }
        if (bl) {
            this.setGreying(true, false);
        }
    }

    public void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister(this);
            this.theApplicationObject = null;
            this.thePreviousStringValue = null;
        }
        if (this.theGreyApplicationObject != null) {
            this.theGreyApplicationObject.unregister(this);
            this.theGreyApplicationObject = null;
            this.thePreviousGreyValue = null;
        }
        if (this.getEclDataEntryView() != null) {
            this.getEclDataEntryView().unregister();
        }
        if (this.hasFocus) {
            EclipseFocusManager.getInstance().changeLockState(false, this);
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible(this);
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
            this.permanentError();
        }
    }
}

