/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.dataentry;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseModel;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclDataEntryDefaults;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.AccessibleEclDataEntryModel;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EclDataEntry;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EclDataEntryView;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EclDataEntryModel
implements Serializable,
EclipseModel {
    static final long serialVersionUID = -1384128544069183847L;
    private EclDataEntry controller;
    private int type;
    private boolean isLive;
    private String databaseVariableName;
    private String databaseGreyVariable;
    private int maxCharNumber;
    private boolean editable;
    private String helpId = null;
    private String menuText;
    private String windowClassName;
    private int compositeDataId;

    public EclDataEntryModel() {
        this.databaseGreyVariable = null;
        this.databaseVariableName = null;
        this.type = 0;
        this.isLive = false;
        this.maxCharNumber = 0;
        this.editable = true;
        this.helpId = null;
        this.compositeDataId = -1;
        this.menuText = null;
        this.windowClassName = null;
    }

    public EclDataEntryModel(int n, boolean bl, String string, String string2, int n2) {
        this.type = n;
        this.isLive = bl;
        this.databaseVariableName = string;
        this.databaseGreyVariable = string2;
        this.maxCharNumber = n2;
        this.editable = true;
        this.helpId = null;
        this.compositeDataId = -1;
        this.menuText = null;
        this.windowClassName = null;
    }

    public EclDataEntryModel(int n, boolean bl, String string, String string2, int n2, boolean bl2) {
        this.type = n;
        this.isLive = bl;
        this.databaseVariableName = string;
        this.databaseGreyVariable = string2;
        this.maxCharNumber = n2;
        this.editable = bl2;
        this.helpId = null;
        this.compositeDataId = -1;
        this.menuText = null;
        this.windowClassName = null;
    }

    public EclDataEntryModel(int n, boolean bl, String string, String string2, int n2, boolean bl2, String string3) {
        this.type = n;
        this.isLive = bl;
        this.databaseVariableName = string;
        this.databaseGreyVariable = string2;
        this.maxCharNumber = n2;
        this.editable = bl2;
        this.helpId = string3;
        this.compositeDataId = -1;
        this.menuText = null;
        this.windowClassName = null;
    }

    public EclDataEntryModel(int n, boolean bl, String string, String string2, int n2, boolean bl2, String string3, int n3, String string4, String string5) {
        this.type = n;
        this.isLive = bl;
        this.databaseVariableName = string;
        this.databaseGreyVariable = string2;
        this.maxCharNumber = n2;
        this.editable = bl2;
        this.helpId = string3;
        this.compositeDataId = n3;
        this.menuText = string4;
        this.windowClassName = string5;
    }

    protected AccessibleEclDataEntryModel createAccessibleModel() {
        return new AccessibleEclDataEntryModel(this.type, this.isLive, this.databaseVariableName, this.databaseGreyVariable, this.maxCharNumber, this.editable, this.compositeDataId, this.helpId, this.menuText, this.windowClassName, this.getController());
    }

    public void createView() {
        this.controller.setHelpId(this.helpId);
        if (this.getController().getBackground() == null) {
            this.getController().setBackground(EclDataEntryDefaults.background);
        }
        if (this.getController().getFont() == null) {
            this.getController().setFont(EclDataEntryDefaults.font);
        }
        if (this.getController().getForeground() == null) {
            this.getController().setForeground(EclDataEntryDefaults.foreground);
        }
        if (this.getController().getEclDataEntryView() == null) {
            this.getController().setEclDataEntryView(new EclDataEntryView(this.getController()));
        }
        this.getController().getEclDataEntryView().initialise(this.type, this.isLive, this.maxCharNumber, this.editable, this.menuText, this.windowClassName, this.getCompositeDataID() != -1);
    }

    public void finishInitialise() {
        if (this.databaseVariableName == null) {
            EventLog.instance().log(String.valueOf(this.controller.toString()) + " requires a variable name.");
            this.controller.permanentError();
        } else {
            ApplicationManager.instance().request(this.getController().getDomainName(), 0, this.databaseVariableName, (ApplicationObjectObserver)this.getController());
            if (this.databaseGreyVariable != null) {
                ApplicationManager.instance().request(this.getController().getDomainName(), 0, this.databaseGreyVariable, (ApplicationObjectObserver)this.getController());
            }
        }
    }

    int getCompositeDataID() {
        return this.compositeDataId;
    }

    protected EclDataEntry getController() {
        return this.controller;
    }

    public int getPropertyIDForName(String string) {
        int n = 0;
        if (string.equals(this.databaseVariableName)) {
            n = 10;
        } else if (string.equals(this.databaseGreyVariable)) {
            n = 12;
        }
        return n;
    }

    public void initialiseDefaults() {
        this.getController().setBackground(EclDataEntryDefaults.background);
        this.getController().setForeground(EclDataEntryDefaults.foreground);
        this.getController().setFont(EclDataEntryDefaults.font);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                this.type = objectInputStream.readInt();
                this.isLive = objectInputStream.readBoolean();
                this.databaseVariableName = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.maxCharNumber = objectInputStream.readInt();
                this.editable = true;
                this.compositeDataId = -1;
                break;
            }
            case 1: {
                this.type = objectInputStream.readInt();
                this.isLive = objectInputStream.readBoolean();
                this.databaseVariableName = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.maxCharNumber = objectInputStream.readInt();
                this.editable = objectInputStream.readBoolean();
                this.compositeDataId = -1;
                break;
            }
            case 2: {
                this.type = objectInputStream.readInt();
                this.isLive = objectInputStream.readBoolean();
                this.databaseVariableName = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.maxCharNumber = objectInputStream.readInt();
                this.editable = objectInputStream.readBoolean();
                this.helpId = (String)objectInputStream.readObject();
                this.compositeDataId = -1;
                break;
            }
            case 3: {
                this.type = objectInputStream.readInt();
                this.isLive = objectInputStream.readBoolean();
                this.databaseVariableName = (String)objectInputStream.readObject();
                this.databaseGreyVariable = (String)objectInputStream.readObject();
                this.maxCharNumber = objectInputStream.readInt();
                this.editable = objectInputStream.readBoolean();
                this.helpId = (String)objectInputStream.readObject();
                this.compositeDataId = objectInputStream.readInt();
                this.menuText = (String)objectInputStream.readObject();
                this.windowClassName = (String)objectInputStream.readObject();
                break;
            }
            default: {
                String string = "Cannot deserialize version " + n + " EclDataEntryModel";
                throw new IOException(string);
            }
        }
    }

    public void setController(EclDataEntry eclDataEntry) {
        this.controller = eclDataEntry;
    }

    public String toString() {
        return "[" + (this.databaseVariableName == null ? "null" : this.databaseVariableName) + ", " + (this.databaseGreyVariable == null ? "null" : this.databaseGreyVariable) + (this.compositeDataId == -1 ? "" : ", " + this.compositeDataId) + "]";
    }

    public boolean updatedGreyValue(MaskedIntegerValue maskedIntegerValue) {
        boolean bl = true;
        if (this.databaseGreyVariable != null) {
            if (maskedIntegerValue == null || maskedIntegerValue.getValue() != 0 && maskedIntegerValue.getValue() != 1) {
                bl = false;
            } else {
                this.getController().setGreying(maskedIntegerValue.getValue() == 0, false);
            }
        } else if (this.getCompositeDataID() == -1) {
            this.getController().setGreying(false, false);
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(3);
        objectOutputStream.writeInt(this.type);
        objectOutputStream.writeBoolean(this.isLive);
        objectOutputStream.writeObject(this.databaseVariableName);
        objectOutputStream.writeObject(this.databaseGreyVariable);
        objectOutputStream.writeInt(this.maxCharNumber);
        objectOutputStream.writeBoolean(this.editable);
        objectOutputStream.writeObject(this.helpId);
        objectOutputStream.writeInt(this.compositeDataId);
        objectOutputStream.writeObject(this.menuText);
        objectOutputStream.writeObject(this.windowClassName);
    }
}

