/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.dataentry;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.EditablePropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.GreyPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.components.EclipseView;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclDataEntryDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseActionnedComponent;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EclDataEntry;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EditableEntryView;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.NonEditableEntryView;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.ViewImplementation;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;

public class EclDataEntryView
implements EclipseView,
TextPropertyAccessor,
GreyPropertyAccessor,
EditablePropertyAccessor {
    private EclDataEntry myController;
    private int theType;
    private boolean isLive;
    private int maxLength = 0;
    private boolean editable = true;
    private String theDialogMenuText;
    private String theDialogClassName;
    private boolean supportNonEditableView = false;
    private static UnconsumedKeyHandler theMainKeyController = null;
    private ViewImplementation myViewImplementation = null;
    private boolean isValid = true;

    public EclDataEntryView(EclDataEntry eclDataEntry) {
        this.myController = eclDataEntry;
    }

    private void changeEditableProperty(boolean bl, boolean bl2) {
        if (this.supportNonEditableView) {
            if (this.editable == bl) {
                if (this.myViewImplementation == null) {
                    ViewImplementation viewImplementation = this.myViewImplementation = this.editable ? this.getEditableView() : this.getNonEditableView();
                    if (bl2) {
                        this.notifyEclipseComponentChanged();
                    }
                } else if (!bl && this.myViewImplementation instanceof EditableEntryView) {
                    this.myViewImplementation = this.getNonEditableView();
                    if (bl2) {
                        this.notifyEclipseComponentChanged();
                    }
                }
            } else {
                this.editable = bl;
                ViewImplementation viewImplementation = this.myViewImplementation = this.editable ? this.getEditableView() : this.getNonEditableView();
                if (bl2) {
                    this.notifyEclipseComponentChanged();
                }
            }
        } else {
            this.editable = bl;
            if (this.myViewImplementation == null || !(this.myViewImplementation instanceof EditableEntryView)) {
                this.myViewImplementation = this.getEditableView();
                if (bl2) {
                    this.notifyEclipseComponentChanged();
                }
            }
        }
    }

    Color getBackground() {
        Color color = this.myController.getBackground();
        if (color != EclDataEntryDefaults.permanentErrorColour && color != EclDataEntryDefaults.transientErrorColour) {
            color = !this.isValid ? EclDataEntryDefaults.permanentErrorColour : (this.editable ? this.myController.getBackground() : null);
        }
        return color;
    }

    EclDataEntry getController() {
        return this.myController;
    }

    String getDialogClassName() {
        return this.theDialogClassName;
    }

    String getDialogMenuText() {
        return this.theDialogMenuText;
    }

    private ViewImplementation getEditableView() {
        EditableEntryView editableEntryView = new EditableEntryView(this);
        editableEntryView.initialise(this.theType, this.isLive);
        if (this.myController.getPreviousStringValue() != null) {
            editableEntryView.setTextProperty(this.myController.getPreviousStringValue());
        }
        editableEntryView.setGreyProperty(this.myController.isEnabled());
        return editableEntryView;
    }

    /*
     * Unable to fully structure code
     */
    UnconsumedKeyHandler getMainKeyController() {
        block2: {
            if (EclDataEntryView.theMainKeyController != null) break block2;
            var1_1 = this.getController().getParent();
            if (var1_1 != null) ** GOTO lbl6
            throw new NullPointerException("Cannot find the parent of " + this.getController().toString());
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.getParent();
lbl6:
                // 2 sources

                ** while (var1_1.getParent() != null)
            }
lbl7:
            // 1 sources

            if (!(var1_1 instanceof UnconsumedKeyHandler)) {
                throw new NullPointerException("The root parent " + var1_1.toString() + " doesn't implement UnconsumedKeyHandler");
            }
            EclDataEntryView.theMainKeyController = (UnconsumedKeyHandler)var1_1;
        }
        return EclDataEntryView.theMainKeyController;
    }

    int getMaxLength() {
        return this.maxLength;
    }

    public MouseActionnedComponent getMouseActionnedComponent() {
        return this.myViewImplementation.getMouseActionnedComponent();
    }

    private ViewImplementation getNonEditableView() {
        NonEditableEntryView nonEditableEntryView = new NonEditableEntryView(this);
        return nonEditableEntryView;
    }

    String getTextProperty() {
        return this.myController.getPreviousStringValue();
    }

    public void initialise(int n, boolean bl, int n2, boolean bl2, String string, String string2, boolean bl3) {
        this.theType = n;
        this.isLive = bl;
        this.maxLength = n2;
        this.theDialogMenuText = string;
        this.theDialogClassName = string2;
        this.supportNonEditableView = bl3;
        this.changeEditableProperty(bl2, false);
        this.notifyEclipseComponentChanged();
    }

    boolean isEditable() {
        return this.editable;
    }

    boolean isRightJustified() {
        return this.theType == 0 || this.theType == 1 || this.theType == 2;
    }

    boolean isValid() {
        return this.isValid;
    }

    public void notifyEclipseComponentChanged() {
        FontMetrics fontMetrics = null;
        if (this.getController().getFont() != null) {
            fontMetrics = this.getController().getFontMetrics(this.getController().getFont());
        }
        if (fontMetrics != null) {
            int n = (this.getController().getBounds().width - 6) / fontMetrics.charWidth('0');
            this.isValid = n >= this.maxLength;
        }
        if (this.myViewImplementation != null) {
            this.myViewImplementation.notifyEclipseComponentChanged();
        }
        this.repaint();
    }

    public void paint(Graphics graphics) {
        this.myViewImplementation.paint(graphics);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        this.myViewImplementation.sendFocusEvent(focusEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() != 401) {
            keyEvent.consume();
        } else if (!this.editable) {
            switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                case 27: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 107: 
                case 112: 
                case 113: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: {
                    break;
                }
                default: {
                    EclipseSystem.instance().beep();
                    keyEvent.consume();
                }
            }
            if (!keyEvent.isConsumed()) {
                this.getMainKeyController().processUnconsumedKeyEvents(keyEvent, this.getController());
            }
        } else {
            this.myViewImplementation.sendKeyEvent(keyEvent);
        }
    }

    public void repaint() {
        this.myController.repaint();
    }

    public boolean setEditableProperty(boolean bl) {
        this.changeEditableProperty(bl, true);
        return true;
    }

    public boolean setGreyProperty(boolean bl) {
        this.myController.setGreying(bl, false);
        if (this.editable) {
            ((EditableEntryView)this.myViewImplementation).setGreyProperty(bl);
        }
        return true;
    }

    public boolean setText(String string) {
        return this.myViewImplementation.setTextProperty(string);
    }

    public boolean setTextProperty(String string) {
        if (string != null) {
            if (!string.equals(this.myController.getPreviousStringValue())) {
                this.getController().setPreviousStringValue(string);
                this.myViewImplementation.setTextProperty(string);
            }
            return true;
        }
        return false;
    }

    public void unregister() {
        this.myViewImplementation.unregister();
    }
}

