/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.viewlayer.components.dataentry;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclDataEntryDefaults;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.MouseActionnedComponent;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.BinaryState;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.DataEntryMenu;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.DateState;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.DecimalState;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.DurationState;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EclDataEntry;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EclDataEntryView;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EntryTypeState;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.FilenameState;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.HexadecimalState;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.IPState;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.LiveManipulator;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.MACState;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.PaddedText;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.SubnetState;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.TextState;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.TimeState;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.ViewImplementation;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Caret;
import com.sun.java.swing.text.DefaultCaret;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.beans.Beans;
import java.util.StringTokenizer;

public class EditableEntryView
extends JTextField
implements ViewImplementation,
MouseActionnedComponent {
    private int currentMode;
    private int cursorMode;
    private EntryTypeState myTypeState;
    private String thePreviousValue;
    private LiveManipulator liveManipulator;
    private final EclDataEntryView myDelegator;
    private static final DataEntryMenu popupMenu = new DataEntryMenu();
    private String[] theHistoryText = new String[4];
    private String[] thePresetText = new String[4];
    private boolean shouldGoToNavigationMode = true;
    private boolean isInError = false;
    private boolean isPopupVisible = false;

    public EditableEntryView(EclDataEntryView eclDataEntryView) {
        this.myDelegator = eclDataEntryView;
        DefaultCaret defaultCaret = new DefaultCaret();
        defaultCaret.setBlinkRate(0);
        this.setCaret((Caret)defaultCaret);
        this.setSelectedTextColor(EclDataEntryDefaults.highlightedTextColor);
        this.setSelectionColor(EclDataEntryDefaults.highlightColor);
    }

    private void actionBackspaceKey() {
        switch (this.getCursorMode()) {
            case 1: {
                boolean bl = true;
                try {
                    if (this.getCaret().getDot() > 0) {
                        this.getDocument().remove(this.getCaret().getDot() - 1, 1);
                        bl = false;
                    }
                }
                catch (BadLocationException badLocationException) {}
                if (bl) {
                    EclipseSystem.instance().beep();
                }
                this.repaint();
                break;
            }
            case 2: {
                EclipseSystem.instance().beep();
                break;
            }
            case 3: {
                if (!EclipseSystem.instance().isControllingClient()) break;
                this.setPreviousValue(this.getText());
                this.changeTextValue("", false);
                this.setCursorMode(1);
            }
        }
    }

    private void actionCancelKey() {
        switch (this.getMode()) {
            case 1: {
                if (this.thePreviousValue.length() == 0) break;
                this.changeTextValue(this.thePreviousValue, false);
                this.backToNavigationMode();
                break;
            }
            case 2: {
                this.changeTextValue(this.thePreviousValue, false);
            }
            case 3: {
                this.backToNavigationMode();
            }
        }
    }

    private void actionDefaultKeys(KeyEvent keyEvent) {
        int n;
        if (this.getMode() == 2) {
            this.myTypeState.processKeyEvent(keyEvent, this);
        } else if (this.getMode() == 1 && (n = keyEvent.getKeyCode()) != 16 && n != 18 && n != 17 && EclipseSystem.instance().isControllingClient()) {
            this.myTypeState.processKeyEvent(keyEvent, this);
            this.setMode(2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void actionDownKey(KeyEvent var1_1) {
        switch (this.getMode()) {
            case 1: {
                if (!EditableEntryView.popupMenu.isVisible()) {
                    if (this.getCursorMode() == 1 || this.getCursorMode() == 2) break;
                    this.myDelegator.getMainKeyController().processUnconsumedKeyEvents(var1_1, this.getController());
                    break;
                }
                this.setText(this.getText());
                break;
            }
            case 3: {
                var2_2 = this.getText();
                var3_3 = this.getSelectionStart();
                var4_4 = var2_2.length() - Math.max(var3_3, this.getSelectionEnd());
                var5_5 = this.liveManipulator.decrement(var2_2, var4_4);
                this.changeTextValue(String.valueOf(var5_5) + "<live>", true);
                if (!EclipseFocusManager.getInstance().isFocusLocked(this.getController())) ** GOTO lbl40
                var5_5 = this.getText();
                if (var5_5.length() <= var2_2.length()) ** GOTO lbl27
                var6_6 = var3_3 + 1;
                while (var6_6 < var5_5.length()) {
                    this.setSelectionStart(var6_6);
                    this.setSelectionEnd(var6_6 + 1);
                    if (!this.liveManipulator.isCharSelectable(this.getSelectedText())) {
                        ++var6_6;
                        continue;
                    }
                    ** GOTO lbl41
                }
                ** GOTO lbl41
lbl27:
                // 1 sources

                if (var5_5.length() >= var2_2.length()) ** GOTO lbl37
                var6_7 = var3_3 == 0 ? 0 : var3_3 - 1;
                while (var6_7 < var5_5.length()) {
                    this.setSelectionStart(var6_7);
                    this.setSelectionEnd(var6_7 + 1);
                    if (!this.liveManipulator.isCharSelectable(this.getSelectedText())) {
                        ++var6_7;
                        continue;
                    }
                    ** GOTO lbl41
                }
                ** GOTO lbl41
lbl37:
                // 1 sources

                this.setSelectionStart(var3_3);
                this.setSelectionEnd(var3_3 + 1);
                ** GOTO lbl41
lbl40:
                // 1 sources

                this.backToNavigationMode();
lbl41:
                // 6 sources

                this.repaint();
            }
        }
    }

    private void actionLeftKey(KeyEvent keyEvent) {
        switch (this.getCursorMode()) {
            case 1: {
                if (this.getCaretPosition() == 0) {
                    EclipseSystem.instance().beep();
                    break;
                }
                this.setCaretPosition(this.getCaretPosition() - 1);
                this.repaint();
                break;
            }
            case 2: {
                if (this.getMode() == 2) {
                    int n = this.getSelectionStart();
                    int n2 = n - 1;
                    while (n2 >= 0) {
                        char c = this.getText().charAt(n2);
                        if (!this.myTypeState.isSeparatorChar(c)) {
                            n = n2;
                            break;
                        }
                        --n2;
                    }
                    this.select(n, n + 1);
                    this.repaint();
                    break;
                }
                if (this.getMode() == 3) {
                    int n = this.getSelectionStart();
                    int n3 = this.getSelectionEnd();
                    int n4 = n - 1;
                    while (n4 >= 0) {
                        this.setSelectionStart(n4);
                        this.setSelectionEnd(n4 + 1);
                        if (this.liveManipulator.isCharSelectable(this.getSelectedText())) break;
                        --n4;
                    }
                    if (n4 < 0) {
                        this.setSelectionStart(n);
                        this.setSelectionEnd(n3);
                        EclipseSystem.instance().beep();
                        break;
                    }
                    this.repaint();
                    break;
                }
                System.out.println("Not implemented: OverWrite cursor with Mode =" + this.getMode() + " 0:OUT,1:NAV,2:EDIT,3:LIVE");
                break;
            }
            case 3: {
                this.myDelegator.getMainKeyController().processUnconsumedKeyEvents(keyEvent, this.getController());
            }
        }
    }

    private void actionRightKey(KeyEvent keyEvent) {
        if (this.getMode() == 1) {
            if (!popupMenu.isVisible()) {
                if (this.getCursorMode() == 1) {
                    if (this.getCaretPosition() == this.getText().length()) {
                        EclipseSystem.instance().beep();
                    } else {
                        this.setCaretPosition(this.getCaretPosition() + 1);
                        this.repaint();
                    }
                } else if (this.getCursorMode() == 2) {
                    int n = this.getSelectionStart();
                    int n2 = n + 1;
                    while (n2 < this.getText().length()) {
                        char c = this.getText().charAt(n2);
                        if (!this.myTypeState.isSeparatorChar(c)) {
                            n = n2;
                            break;
                        }
                        ++n2;
                    }
                    this.select(n, n + 1);
                    this.repaint();
                } else {
                    this.myDelegator.getMainKeyController().processUnconsumedKeyEvents(keyEvent, this.getController());
                }
            } else {
                this.setText(this.getText());
            }
        } else if (this.getCursorMode() == 2) {
            if (this.liveManipulator != null) {
                int n;
                int n3 = this.getSelectionStart();
                int n4 = n = this.getSelectionEnd();
                while (n4 < this.getText().length()) {
                    this.setSelectionStart(n4);
                    this.setSelectionEnd(n4 + 1);
                    if (this.liveManipulator.isCharSelectable(this.getSelectedText())) break;
                    ++n4;
                }
                if (n4 >= this.getText().length()) {
                    this.setSelectionStart(n3);
                    this.setSelectionEnd(n);
                    EclipseSystem.instance().beep();
                } else {
                    this.repaint();
                }
            } else {
                int n = this.getSelectionStart();
                int n5 = n + 1;
                while (n5 < this.getText().length()) {
                    char c = this.getText().charAt(n5);
                    if (!this.myTypeState.isSeparatorChar(c)) {
                        n = n5;
                        break;
                    }
                    ++n5;
                }
                this.select(n, n + 1);
                this.repaint();
            }
        } else if (this.getCursorMode() == 1) {
            if (this.getCaretPosition() == this.getText().length()) {
                EclipseSystem.instance().beep();
            } else {
                this.setCaretPosition(this.getCaretPosition() + 1);
                this.repaint();
            }
        }
    }

    private void actionSelectKey() {
        switch (this.getMode()) {
            case 1: {
                if (this.getCursorMode() == 3) {
                    this.activatePopupMenu();
                    break;
                }
                this.changeTextValue(this.getText(), true);
                this.backToNavigationMode();
                break;
            }
            case 2: 
            case 3: {
                if (!this.myTypeState.isValid(this.getText())) {
                    EclipseSystem.instance().beep();
                    this.setText(this.thePreviousValue);
                } else {
                    this.changeTextValue(this.getText(), true);
                }
                this.backToNavigationMode();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void actionUpKey(KeyEvent var1_1) {
        switch (this.getMode()) {
            case 1: {
                if (!EditableEntryView.popupMenu.isVisible()) {
                    if (this.getCursorMode() == 1 || this.getCursorMode() == 2) break;
                    this.myDelegator.getMainKeyController().processUnconsumedKeyEvents(var1_1, this.getController());
                    break;
                }
                this.setText(this.getText());
                break;
            }
            case 3: {
                var2_2 = this.getText();
                var3_3 = this.getSelectionStart();
                var4_4 = var2_2.length() - Math.max(var3_3, this.getSelectionEnd());
                var5_5 = this.liveManipulator.increment(var2_2, var4_4);
                this.changeTextValue(String.valueOf(var5_5) + "<live>", true);
                if (!EclipseFocusManager.getInstance().isFocusLocked(this.getController())) ** GOTO lbl40
                var5_5 = this.getText();
                if (var5_5.length() <= var2_2.length()) ** GOTO lbl27
                var6_6 = var3_3 + 1;
                while (var6_6 < var5_5.length()) {
                    this.setSelectionStart(var6_6);
                    this.setSelectionEnd(var6_6 + 1);
                    if (!this.liveManipulator.isCharSelectable(this.getSelectedText())) {
                        ++var6_6;
                        continue;
                    }
                    ** GOTO lbl41
                }
                ** GOTO lbl41
lbl27:
                // 1 sources

                if (var5_5.length() >= var2_2.length()) ** GOTO lbl37
                var6_7 = var3_3 == 0 ? 0 : var3_3 - 1;
                while (var6_7 < var5_5.length()) {
                    this.setSelectionStart(var6_7);
                    this.setSelectionEnd(var6_7 + 1);
                    if (!this.liveManipulator.isCharSelectable(this.getSelectedText())) {
                        ++var6_7;
                        continue;
                    }
                    ** GOTO lbl41
                }
                ** GOTO lbl41
lbl37:
                // 1 sources

                this.setSelectionStart(var3_3);
                this.setSelectionEnd(var3_3 + 1);
                ** GOTO lbl41
lbl40:
                // 1 sources

                this.backToNavigationMode();
lbl41:
                // 6 sources

                this.repaint();
            }
        }
    }

    private void activatePopupMenu() {
        popupMenu.setComponentFocusableOnClose(this.getController());
        popupMenu.initialise(this.theHistoryText, this.thePresetText, this.includeLiveUpdate(), this.myDelegator.getDialogMenuText(), this.myDelegator.getDialogClassName(), this);
        popupMenu.showRelativeToComponent(this.getController(), 0, ((Component)((Object)this)).getBounds().height + 3);
        popupMenu.requestFocus();
    }

    void backToNavigationMode() {
        this.setMode(1);
        this.setCursorMode(3);
        this.repaint();
    }

    private boolean changeTextProperty(String string) {
        int n = 5 * this.myDelegator.getMaxLength() + 4;
        this.isInError = false;
        if (string != null) {
            String string2;
            boolean bl;
            boolean bl2 = bl = string.indexOf(",") == -1;
            if (bl) {
                string2 = string;
            } else {
                if (string.length() <= n + 2) {
                    this.reportInconsistentData("Received meaningless string from the database =" + string);
                    return false;
                }
                string2 = string.substring(0, this.myDelegator.getMaxLength());
            }
            if (!this.myTypeState.supportPaddedText() || this.getMode() == 3) {
                string2 = string2.trim();
            }
            this.setPreviousValue(string2);
            this.changeTextValue(string2, false);
            this.thePresetText = new String[]{null, null, null, null};
            this.theHistoryText = new String[]{null, null, null, null};
            if (!bl) {
                string2 = string.substring(this.myDelegator.getMaxLength() + 1, this.myDelegator.getMaxLength() * 2 + 1);
                if (string2.trim().length() != 0) {
                    this.theHistoryText[0] = string2;
                }
                if ((string2 = string.substring(this.myDelegator.getMaxLength() * 2 + 2, this.myDelegator.getMaxLength() * 3 + 2)).trim().length() != 0) {
                    this.theHistoryText[1] = string2;
                }
                if ((string2 = string.substring(this.myDelegator.getMaxLength() * 3 + 3, this.myDelegator.getMaxLength() * 4 + 3)).trim().length() != 0) {
                    this.theHistoryText[2] = string2;
                }
                if ((string2 = string.substring(this.myDelegator.getMaxLength() * 4 + 4, this.myDelegator.getMaxLength() * 5 + 4)).trim().length() != 0) {
                    this.theHistoryText[3] = string2;
                }
                if (string.charAt(this.myDelegator.getMaxLength()) != ",".charAt(0) || string.charAt(this.myDelegator.getMaxLength() * 2 + 1) != ",".charAt(0) || string.charAt(this.myDelegator.getMaxLength() * 3 + 2) != ",".charAt(0) || string.charAt(this.myDelegator.getMaxLength() * 4 + 3) != ",".charAt(0) || string.charAt(this.myDelegator.getMaxLength() * 5 + 4) != ",".charAt(0)) {
                    this.reportInconsistentData("Data length received doesn't match length defined at design-time : " + string);
                    return false;
                }
                int n2 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1), ",");
                while (stringTokenizer.hasMoreTokens() && n2 != 4) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.trim().length() != 0) {
                        this.thePresetText[n2] = string2;
                    }
                    ++n2;
                }
            }
            return true;
        }
        this.reportInconsistentData("Received null string from database");
        return false;
    }

    void changeTextValue(String string, boolean bl) {
        if (bl) {
            this.getController().changeValue(string);
        } else if (!string.equals(this.getText())) {
            this.setText(string);
        }
    }

    public void doLeftClickAction() {
        if (this.getCursorMode() == 3) {
            this.activatePopupMenu();
        }
    }

    public void doRightClickAction() {
        this.myDelegator.getMainKeyController().processUnconsumedKeyEvents(InstrumentKeyMappings.getMenuKeyEvent(this.getController()), this.getController());
    }

    private void fillWithHashes() {
        StringBuffer stringBuffer = new StringBuffer(this.myDelegator.getMaxLength());
        int n = 0;
        while (n < this.myDelegator.getMaxLength()) {
            stringBuffer.append("#");
            ++n;
        }
        this.setText(stringBuffer.toString());
    }

    private EclDataEntry getController() {
        return this.myDelegator.getController();
    }

    private int getCursorMode() {
        return this.cursorMode;
    }

    public Point getLocationOnScreen() {
        if (this.getController() == null) {
            return super.getLocationOnScreen();
        }
        return this.getController().getLocationOnScreen();
    }

    private int getMode() {
        return this.currentMode;
    }

    public MouseActionnedComponent getMouseActionnedComponent() {
        return this;
    }

    public Container getParent() {
        if (this.getController() == null) {
            return super.getParent();
        }
        return this.getController().getParent();
    }

    public boolean hasFocus() {
        if (this.getController() == null) {
            return super.hasFocus();
        }
        return this.getController().hasFocus();
    }

    private boolean includeLiveUpdate() {
        return this.liveManipulator != null;
    }

    public void initialise(int n, boolean bl) {
        this.setCaretPosition(0);
        this.setMode(0);
        this.setCursorMode(0);
        switch (n) {
            case 0: {
                DecimalState decimalState = new DecimalState();
                this.myTypeState = decimalState;
                if (bl) {
                    this.liveManipulator = decimalState;
                    break;
                }
                this.liveManipulator = null;
                break;
            }
            case 1: {
                this.myTypeState = new BinaryState();
                this.liveManipulator = null;
                break;
            }
            case 2: {
                this.myTypeState = new HexadecimalState();
                this.liveManipulator = null;
                break;
            }
            case 3: {
                this.myTypeState = new TextState();
                this.liveManipulator = null;
                break;
            }
            case 4: {
                this.myTypeState = new DateState();
                this.liveManipulator = null;
                break;
            }
            case 5: {
                this.myTypeState = new TimeState();
                this.liveManipulator = null;
                break;
            }
            case 6: {
                this.myTypeState = new DurationState();
                this.liveManipulator = null;
                break;
            }
            case 7: {
                this.myTypeState = new IPState();
                this.liveManipulator = null;
                break;
            }
            case 8: {
                this.myTypeState = new PaddedText();
                this.liveManipulator = null;
                break;
            }
            case 9: {
                this.myTypeState = new MACState();
                this.liveManipulator = null;
                break;
            }
            case 10: {
                this.myTypeState = new FilenameState();
                this.liveManipulator = null;
                break;
            }
            case 11: {
                this.myTypeState = new SubnetState();
                this.liveManipulator = null;
            }
        }
    }

    public boolean isEnabled() {
        return this.getController().isEnabled();
    }

    public void notifyEclipseComponentChanged() {
        if (this.myDelegator.isRightJustified()) {
            this.setHorizontalAlignment(4);
        } else {
            this.setHorizontalAlignment(2);
        }
        ((Component)((Object)this)).setBounds(0, 0, this.getController().getBounds().width, this.getController().getBounds().height);
        ((Component)((Object)this)).setForeground(this.getController().getForeground());
        this.setFont(this.getController().getFont());
        this.updateBackground();
        if (Beans.isDesignTime()) {
            this.fillWithHashes();
        }
    }

    public void notifyPopupVisibilityChange(boolean bl) {
        this.isPopupVisible = bl;
    }

    protected void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
        if (this.hasFocus() || popupMenu.isVisible()) {
            switch (this.getMode()) {
                case 1: {
                    graphics.setColor(EclDataEntryDefaults.focusColour);
                    graphics.drawRect(0, 0, this.getWidth() - 2, this.getHeight() - 2);
                    break;
                }
                case 2: {
                    graphics.setColor(EclDataEntryDefaults.editColor);
                    graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    graphics.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
                    break;
                }
                case 3: {
                    graphics.setColor(EclDataEntryDefaults.liveColor);
                    graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    graphics.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
                }
            }
        }
    }

    protected void paintComponent(Graphics graphics) {
        if (this.isInError) {
            this.getHighlighter().removeAllHighlights();
        } else {
            switch (this.getCursorMode()) {
                case 0: {
                    this.getHighlighter().removeAllHighlights();
                    break;
                }
                case 1: {
                    this.getHighlighter().removeAllHighlights();
                    break;
                }
                case 3: {
                    this.selectAll();
                }
            }
        }
        super.paintComponent(graphics);
    }

    void processChar(char c) {
        int n;
        if (this.getCursorMode() == 3) {
            if (this.myTypeState.isInsertModeSupported()) {
                this.setPreviousValue(this.getText());
                this.changeTextValue("", false);
                this.setCursorMode(1);
            } else {
                this.setPreviousValue(this.getText());
                this.setCursorMode(2);
                if (this.getText() != null && this.getText().length() > 0) {
                    if (!this.myDelegator.isRightJustified()) {
                        this.setSelectionStart(0);
                        this.setSelectionEnd(1);
                    } else {
                        n = this.getText().length();
                        this.setSelectionStart(n);
                        this.setSelectionEnd(n - 1);
                    }
                }
            }
        }
        if (this.getCursorMode() == 2) {
            if (this.getText().length() == 0) {
                this.changeTextValue(String.valueOf(c), false);
                this.setSelectionStart(0);
                this.setSelectionEnd(1);
            } else {
                int n2;
                StringBuffer stringBuffer = new StringBuffer(this.getText());
                if (this.getCaret().getDot() > this.getCaret().getMark()) {
                    n2 = this.getCaret().getDot();
                    this.getCaret().getMark();
                    stringBuffer.setCharAt(this.getCaret().getMark(), c);
                } else {
                    this.getCaret().getDot();
                    n2 = this.getCaret().getMark();
                    stringBuffer.setCharAt(this.getCaret().getDot(), c);
                }
                this.changeTextValue(stringBuffer.toString(), false);
                int n3 = n2;
                while (n3 < this.getText().length()) {
                    char c2 = this.getText().charAt(n3);
                    if (!this.myTypeState.isSeparatorChar(c2)) {
                        n2 = n3;
                        break;
                    }
                    ++n3;
                }
                if (n2 == this.getText().length()) {
                    --n2;
                }
                this.select(n2, n2 + 1);
            }
            this.repaint();
        } else {
            n = 1;
            String string = "";
            if (this.getText() != null) {
                string = this.getText();
            }
            if (string.length() != this.myDelegator.getMaxLength()) {
                try {
                    this.getDocument().insertString(this.getCaret().getDot(), String.valueOf(c), null);
                    n = 0;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (n != 0) {
                EclipseSystem.instance().beep();
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        this.myTypeState.processFocusEvent(focusEvent);
        switch (focusEvent.getID()) {
            case 1005: {
                if (popupMenu.isVisible()) break;
                if (!this.getText().equals(this.thePreviousValue)) {
                    this.changeTextValue(this.thePreviousValue, false);
                }
                this.setMode(0);
                this.setCursorMode(0);
                this.setSelectionStart(0);
                this.setSelectionEnd(0);
                break;
            }
            case 1004: {
                if (!this.shouldGoToNavigationMode) break;
                this.setMode(1);
                if (!this.myDelegator.isEditable()) break;
                this.setCursorMode(3);
            }
        }
        this.shouldGoToNavigationMode = true;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this.myTypeState != null) {
            switch (InstrumentKeyMappings.deriveKeyType(keyEvent)) {
                case 10: {
                    this.actionSelectKey();
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    this.actionDownKey(keyEvent);
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    this.actionUpKey(keyEvent);
                    keyEvent.consume();
                    break;
                }
                case 107: 
                case 112: 
                case 113: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: {
                    this.actionCancelKey();
                    this.myDelegator.getMainKeyController().processUnconsumedKeyEvents(keyEvent, this.getController());
                    keyEvent.consume();
                    break;
                }
                case 27: {
                    if (this.getCursorMode() == 3) {
                        this.myDelegator.getMainKeyController().processUnconsumedKeyEvents(keyEvent, this.getController());
                        break;
                    }
                    this.actionCancelKey();
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    this.actionLeftKey(keyEvent);
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    this.actionRightKey(keyEvent);
                    keyEvent.consume();
                    break;
                }
                case 8: 
                case 2019: {
                    if (this.myTypeState.isInsertModeSupported()) {
                        this.actionBackspaceKey();
                    }
                    keyEvent.consume();
                    break;
                }
                default: {
                    this.actionDefaultKeys(keyEvent);
                    keyEvent.consume();
                }
            }
        }
    }

    char removePreviousCharacter() {
        char c = '\u0000';
        try {
            if (this.getCaret().getDot() > 0) {
                c = this.getText().charAt(this.getCaret().getDot() - 1);
                this.getDocument().remove(this.getCaret().getDot() - 1, 1);
            }
        }
        catch (BadLocationException badLocationException) {}
        return c;
    }

    public void repaint() {
        if (this.myDelegator == null) {
            super.repaint();
        } else {
            this.getController().repaint();
        }
    }

    private void reportInconsistentData(String string) {
        this.isInError = true;
        this.fillWithHashes();
        this.setPreviousValue(this.getText());
        this.updateBackground();
        EventLog.instance().log("Error in " + this.getController() + " " + string);
        this.repaint();
    }

    public void requestFocus() {
        if (this.getController() == null) {
            super.requestFocus();
        } else {
            this.getController().requestFocus();
        }
    }

    public void sendFocusEvent(FocusEvent focusEvent) {
        this.processFocusEvent(focusEvent);
    }

    public void sendKeyEvent(KeyEvent keyEvent) {
        this.processKeyEvent(keyEvent);
    }

    private void setCursorMode(int n) {
        this.cursorMode = n;
        switch (this.cursorMode) {
            case 1: {
                this.getCaret().setVisible(true);
            }
            case 2: {
                EclipseFocusManager.getInstance().changeLockState(true, this.getController());
                break;
            }
            case 0: 
            case 3: {
                EclipseFocusManager.getInstance().changeLockState(false, null);
            }
        }
    }

    public void setGreyProperty(boolean bl) {
        if (super.isEnabled() == bl) {
            this.setEnabled(!bl);
            this.setText(this.getText());
        }
    }

    private void setMode(int n) {
        this.currentMode = n;
        switch (this.currentMode) {
            case 0: 
            case 1: {
                this.getCaret().setVisible(false);
                break;
            }
            case 2: 
            case 3: {
                if (this.cursorMode == 2) {
                    this.getCaret().setSelectionVisible(true);
                    this.getCaret().setVisible(false);
                    break;
                }
                this.getCaret().setVisible(true);
                this.getCaret().setSelectionVisible(false);
            }
        }
    }

    private void setPreviousValue(String string) {
        if (!string.equals(this.thePreviousValue)) {
            this.thePreviousValue = string;
        }
    }

    public boolean setTextProperty(String string) {
        if (this.getController().isEnabled() != this.isEnabled()) {
            this.setEnabled(this.getController().isEnabled());
        }
        this.updateBackground();
        return this.changeTextProperty(string);
    }

    void switchToEditMode() {
        if (EclipseSystem.instance().isControllingClient()) {
            String string = this.getText();
            this.setPreviousValue(string);
            if (this.myTypeState instanceof TextState) {
                this.setCursorMode(1);
                this.setMode(2);
                this.setCaretPosition(string.length());
            } else {
                this.setCursorMode(2);
                this.setMode(2);
                this.setSelectionStart(string.length());
                this.setSelectionEnd(string.length() - 1);
            }
            this.shouldGoToNavigationMode = false;
        }
        this.requestFocus();
    }

    void switchToLiveUpdate() {
        if (EclipseSystem.instance().isControllingClient()) {
            this.setPreviousValue(this.getText());
            this.setCursorMode(2);
            this.setMode(3);
            String string = this.getText().trim();
            this.setText(string);
            int n = string.length();
            this.setSelectionStart(n);
            this.setSelectionEnd(n - 1);
            this.shouldGoToNavigationMode = false;
        }
        this.requestFocus();
    }

    public void unregister() {
        if (this.isPopupVisible) {
            popupMenu.setVisible(false);
            EclipseFocusManager.getInstance().changeLockState(false, this.getController());
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible((Component)((Object)this));
        }
    }

    private void updateBackground() {
        if (this.isInError) {
            this.setOpaque(true);
            ((Component)((Object)this)).setBackground(EclDataEntryDefaults.transientErrorColour);
        } else {
            Color color = this.myDelegator.getBackground();
            ((Component)((Object)this)).setBackground(color);
            if (color == null) {
                this.setOpaque(false);
            } else {
                this.setOpaque(true);
            }
        }
    }
}

